<?php
include('inc/header.php');
include("inc/resize_image.php");
$page_name_text = 'السلايدر';
$table_name = 'slider';
?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <ol class="breadcrumb">
        <li><a href="index.php"><i class="fa fa-dashboard"></i> لوحة التحكم</a></li>
        <li class="active"><a href="slider.php"> <?php echo $page_name_text ?></a></li>
    </ol>
</section>

<section class="content">
    <div class="box box-primary">
        <div class="box-header">
            <h3 class="box-title"> السلايدر </h3>
            <div class="box-tools pull-left">
                <a href="slider.php?action=add" class="btn btn-primary"><i class="fa fa-plus"></i> إضافة</a>
            </div>
        </div>
        <div class="box-body">
            <?php
            $action = !isset($_GET['action']) ? "view" :$_GET['action'];
            if ($action=="view"){
                $AllItems = getAllItems('slider');
            if(sizeof($AllItems) > 0){
                ?>
                <table class="table table-bordered table-striped datatables">
                    <thead>
                    <tr>
                        <th width="10%" align="center">#</th>
                        <th width="25%" align="center">الخلفية</th>
                        <th width="25%" align="center">العنوان</th>
                        <th width="25%" align="center">تاريخ الاضافة / التعديل</th>
                        <th width="15%" align="center">الاجراء</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php
                    for($i=0;$i<sizeof($AllItems);$i++){
                        $id          = $AllItems[$i]['id'];
                        $title       = $AllItems[$i]['title'];
                        $content     = $AllItems[$i]['content'];
                        $link        = $AllItems[$i]['link'];
                        $image       = $AllItems[$i]['image'];
                        $state       = $AllItems[$i]['state'];
                        $add_date    = $AllItems[$i]['add_date'];
                        $last_update = $AllItems[$i]['last_update'];
                        ?>
                        <tr >
                            <td align="center"><?php echo $i+1?></td>
                            <td align="center">
                                <?php
                                if(!empty($image) && file_exists('../uploads/'.$table_name.'/thumb/'.$image)){
                                    ?>
                                    <img src="../uploads/<?php echo $table_name.'/thumb/'.$image?>" class="img-responsive" width="85" />
                                    <?php
                                }else{
                                    ?>
                                    لا يوجد
                                    <?php
                                }
                                ?>
                            </td>
                            <td align="center"><?php echo $title?></td>
                            <td align="center">
                                <?php
                                if($last_update==0){
                                    echo $add_date;
                                }else{
                                    echo $last_update;
                                }

                                ?>
                            </td>
                            <td align="center">
                                <?php
                                if($state==1){
                                    echo'<a href="slider.php?action=show&id='.$id.'&state=0" class="btn btn-success" data-toggle="tooltip" title="حجب" ><i class="fa fa-check-circle"></i></a>';
                                }else{
                                    echo'<a href="slider.php?action=show&id='.$id.'&state=1" class="btn btn-danger" data-toggle="tooltip" title=" تفعيل" ><i class="fa  fa-ban"></i></a>';
                                }
                                ?>
                                <a class="btn btn-default" href="slider.php?action=edit&id=<?php echo $id?>"  data-toggle="tooltip" title="" data-original-title="تعديل">
                                    <i class="fa fa-edit text-blue"></i></a>
                                <a class="btn btn-default confirm" href="slider.php?action=del&id=<?php echo $id?>"  data-toggle="tooltip" title="" data-original-title="حذف">
                                    <i class="fa fa-trash-o text-red"></i></a></td>
                        </tr>
                        <?php
                    }
                    ?>
                    </tbody>
                </table>
            <?php
            }else{
                echo '<div class="callout callout-warning"><h4>السجل فارغ !  </h4></div>';
            }


            }elseif($action=="add"){
            ?>
                <div class="callout callout-info">
                    <h4>ملاحظة </h4>
                    <p> - الخلفية يجب أن تكون بلاحقة jpg فقط </p>
                    <p> -  أبعاد الخلفية الدنيا (1000*1580)</p>

                </div>
            <?php
            if (isset($_POST['Add'])){
                $title         = $_POST['title'];
                $title_en      = $_POST['title_en'];
                $content       = $_POST['content'];
                $content_en    = $_POST['content_en'];
                $link          = $_POST['link'];
                $image_file    = $_FILES['image_file']['name'];
                $image_temp    = $_FILES['image_file']['tmp_name'];

                $INSERT = $con->prepare("INSERT INTO slider (title,title_en,content,content_en,link,image,add_date,state) VALUES (:stitle,:stitle_en,:scontent,:scontent_en,:slink,:simage,now(),1)");
                $INSERT->execute(array(
                    ':stitle'=>$title,
                    ':stitle_en'=>$title_en,
                    ':scontent'=>$content,
                    ':scontent_en'=>$content_en,
                    ':slink'=>$link,
                    ':simage'=>''
                ));

                $count = $INSERT->rowCount();
                if($count > 0){
                    $id = $con->lastInsertId();
                    if(!empty($image_file)){
                        $ext = strtolower(end(explode('.',$image_file)));
                        $image_name  = "slider_".$id.".".$ext;
                        $target_path = "../uploads/".$table_name.'/'.$image_name;
                        $small_path  = "../uploads/".$table_name.'/thumb/'.$image_name;
                        if(move_uploaded_file($image_temp,$target_path)){
                            list($width,$height) = getimagesize($target_path);
                            if($width > 200)
                            {
                                list($width1,$height1)=calculate_width_height($width,$height,200,$height);
                                resize($target_path,$small_path,$width1,$height1);
                            }
                            $UPDATE   =  $con->prepare("UPDATE slider SET image=? WHERE id=?");
                            $UPDATE->execute(array($image_name,$id));
                        }
                    }
                    echo'<div class="alert alert-success alert-dismissable"><i class="fa fa-check"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button> تمت الإضافة بنجاح.</div>';
                    echo '<META HTTP-EQUIV="Refresh" CONTENT="2;URL=slider.php" >';
                }

            }
            ?>
                <div class="tabbed-info page-row">
                    <ul class="nav nav-tabs" style="margin-bottom:15px;">
                        <li class="active">
                            <a href="#tab-1" data-toggle="tab"> عربي <i class="fa"></i></a>
                        </li>
                        <li class="">
                            <a href="#tab-2" data-toggle="tab"> انكليزي  <i class="fa"></i></a>
                        </li>
                    </ul>
                    <form  enctype="multipart/form-data" class="form-horizontal" role="form" action="" method="post"  id="upload_form">

                        <div class="tab-content">
                            <div class="tab-pane active" id="tab-1">
                                <div class="form-group">
                                    <label for="title" class="col-sm-2 control-label">عنوان  : </label>
                                    <div class="col-sm-6">
                                        <input type="text" name="title" class="form-control text-right" id="title" placeholder="">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="content" class="col-sm-2 control-label">المحتوى  : </label>
                                    <div class="col-sm-6">
                                        <textarea name="content" rows="5" class="form-control textarea" id="content"></textarea>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="link" class="col-sm-2 control-label">الرابط  : </label>
                                    <div class="col-sm-6">
                                        <input type="text" name="link" class="form-control ltr">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="image_file" class="col-sm-2 control-label">الخلفية   : </label>
                                    <div class="col-sm-6">
                                        <div class="text-info">لا ضرورة لقص الصورة , فقط يرجى الالتزام بالأبعاد [1000*1580] كحد أدنى</div>
                                        <input type="file" name="image_file" id="image_file"  />
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab-2">
                                <div class="form-group">
                                    <label for="title_en" class="col-sm-2 control-label">عنوان : </label>
                                    <div class="col-sm-6">
                                        <input type="text" name="title_en" class="form-control ltr">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="content_en" class="col-sm-2 control-label">المحتوى : </label>
                                    <div class="col-sm-6">
                                        <textarea name="content_en" rows="5" class="form-control  ltr textarea_en"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-6 col-sm-offset-2">
                                <button type="submit" name="Add" class="btn btn-primary"><i class="fa fa-save"></i> حفظ </button>
                            </div>
                        </div>
                    </form>
                </div>
                <script type="text/javascript">
                    $(document).ready(function() {

                        $('#upload_form').bootstrapValidator({
                            feedbackIcons: {
                                valid: 'glyphicon glyphicon-ok',
                                invalid: 'glyphicon glyphicon-remove',
                                validating: 'glyphicon glyphicon-refresh'
                            },
                            fields: {
                                image_file: {
                                    validators: {
                                        notEmpty: {
                                            message: ''
                                        }
                                    },
                                    file: {
                                        extension: 'jpg',
                                        type: 'image/jpeg',
                                        message: 'نوع الصورة غير مسموح , يسمح فقط بالأنواع [jpg]'
                                    }
                                }
                            }
                        });
                    });
                </script>
            <?php
            }elseif($action=="edit"){
            $id = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
            $Item = getItemById('slider',$id);
            if(count($Item) > 0){
                $title      = $Item['title'];
                $title_en   = $Item['title_en'];
                $content    = stripslashes($Item['content']);
                $content_en = stripslashes($Item['content_en']);
                $link       = $Item['link'];
                $image      = $Item['image'];
            }
            ?>
                <div class="callout callout-info">
                    <h4>ملاحظة هامة</h4>
                    <p> - الخلفية يجب أن تكون بلاحقة jpg فقط </p>
                    <p> -  أبعاد الخلفية (1580*1000)</p>
                </div>
            <?php
            if (isset($_POST['Edit'])){
                $title         = $_POST['title'];
                $title_en      = $_POST['title_en'];
                $content       = $_POST['content'];
                $content_en    = $_POST['content_en'];
                $link          = $_POST['link'];
                $image_file    = $_FILES['image_file']['name'];
                $image_temp    = $_FILES['image_file']['tmp_name'];

                $UPDATE = $con->prepare("UPDATE slider SET title=:stitle,title_en=:stitle_en,content=:scontent,content_en=:scontent_en,link=:slink,last_update=now() WHERE id=:sid");
                $UPDATE->execute(array(
                    ':stitle'=>$title,
                    ':stitle_en'=>$title_en,
                    ':scontent'=>$content,
                    ':scontent_en'=>$content_en,
                    ':slink'=>$link,
                    ':sid'=>$id
                ));
                if(!empty($image_file)){
                    $img_name = 'slider_'.$id;
                    $ext = strtolower(end(explode('.',$image_file)));
                    $image_name  = "slider_".$id.".".$ext;
                    $target_path = "../uploads/".$table_name.'/'.$image_name;
                    $small_path  = "../uploads/".$table_name.'/thumb/'.$image_name;

                    if(move_uploaded_file($image_temp,$target_path)){
                        list($width,$height) = getimagesize($target_path);
                        if($width > 200)
                        {
                            list($width1,$height1)=calculate_width_height($width,$height,200,$height);
                            resize($target_path,$small_path,$width1,$height1);
                        }
                        $UPDATE_IMG   =  $con->prepare("UPDATE slider SET image=? WHERE id=?");
                        $UPDATE_IMG->execute(array($image_name,$id));
                    }
                }
                echo'<div class="alert alert-success alert-dismissable"><i class="fa fa-check"></i><button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button> تم التعديل بنجاح.</div>';
                echo '<META HTTP-EQUIV="Refresh" CONTENT="2;URL=slider.php" >';

            }
            ?>
                <div class="tabbed-info page-row">
                    <ul class="nav nav-tabs" style="margin-bottom:15px;">
                        <li class="active">
                            <a href="#tab-1" data-toggle="tab"> عربي <i class="fa"></i></a>
                        </li>
                        <li class="">
                            <a href="#tab-2" data-toggle="tab"> انكليزي  <i class="fa"></i></a>
                        </li>
                    </ul>
                    <form  enctype="multipart/form-data" class="form-horizontal" role="form" action="" method="post"  id="upload_form">

                        <div class="tab-content">
                            <div class="tab-pane active" id="tab-1">
                                <div class="form-group">
                                    <label for="title" class="col-sm-2 control-label">عنوان  : </label>
                                    <div class="col-sm-6">
                                        <input type="text" name="title" class="form-control text-right" id="title" value="<?php echo $title?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="content" class="col-sm-2 control-label">المحتوى  : </label>
                                    <div class="col-sm-6">
                                        <textarea name="content" rows="5" class="form-control text-right textarea" id="content"><?php echo $content?></textarea>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="link" class="col-sm-2 control-label">الرابط  : </label>
                                    <div class="col-sm-6">
                                        <input type="text" name="link" class="form-control ltr"  value="<?php echo $link?>">
                                    </div>
                                </div>


                                <div class="form-group">
                                    <label for="image_file" class="col-sm-2 control-label">الخلفية   : </label>
                                    <div class="col-sm-6">
                                        <div class="text-info">لا ضرورة لقص الصورة , فقط يرجى الالتزام بالأبعاد [1000*1580] كحد أدنى</div>
                                        <input type="file" name="image_file" id="image_file"/>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="image_file" class="col-sm-2 control-label">    </label>
                                    <div class="col-sm-10">
                                        <?php
                                        if(!empty($image) && file_exists('../uploads/'.$table_name.'/'.$image)){
                                            $img_path='../uploads/'.$table_name.'/'.$image;
                                            echo '<img id="preview"  src="'.$img_path.'" width="500"/>';

                                        }
                                        ?>
                                    </div>
                                </div>



                            </div>
                            <div class="tab-pane" id="tab-2">
                                <div class="form-group">
                                    <label for="title_en" class="col-sm-2 control-label">عنوان : </label>
                                    <div class="col-sm-6">
                                        <input type="text" name="title_en" class="form-control ltr"  value="<?php echo $title_en?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="content_en" class="col-sm-2 control-label">المحتوى : </label>
                                    <div class="col-sm-6">
                                        <textarea rows="5" name="content_en" class="form-control  ltr textarea_en"><?php echo $content_en?></textarea>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-6 col-sm-offset-2">
                                <button type="submit" name="Edit" class="btn btn-primary"><i class="fa fa-save"></i> حفظ </button>
                            </div>
                        </div>
                    </form>
                </div>
                <script type="text/javascript">
                    $(document).ready(function() {

                        $('#upload_form').bootstrapValidator({
                            feedbackIcons: {
                                valid: 'glyphicon glyphicon-ok',
                                invalid: 'glyphicon glyphicon-remove',
                                validating: 'glyphicon glyphicon-refresh'
                            },
                            fields: {
                                image_file: {
                                    validators: {
                                        file: {
                                            extension: 'jpg',
                                            type: 'image/jpeg',
                                            message: 'نوع الصورة غير مسموح , يسمح فقط بالأنواع [jpg]'
                                        }
                                    }
                                }
                            }
                        });
                    });
                </script>
                <?php

            }elseif($action=="show"){
                $id    = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
                $state = isset($_GET['state']) && is_numeric($_GET['state']) ? intval($_GET['state']):0;

                $UPDATE = $con->prepare("UPDATE slider SET state=:sstate WHERE id=:sid");
                $UPDATE->execute(array(':sstate'=>$state,':sid'=>$id));
                header('Location: slider.php');
                exit();

            }elseif($action=="del"){
                $id = isset($_GET['id']) && is_numeric($_GET['id']) ? intval($_GET['id']):0;
                $Item = getItemById('slider',$id);
                if(count($Item) > 0){
                    $imagename = $Item['image'];
                    //$png       = $Item['png'];
                    $img_path='../uploads/'.$table_name.'/'.$imagename;
                    $thumb_path = '../uploads/'.$table_name.'/thumb/'.$imagename;
                    $DELETE = $con->prepare("DELETE FROM slider WHERE id=:sid");
                    $DELETE->bindParam(":sid",$id);
                    $DELETE->execute();
                    if(!empty($imagename) && file_exists($img_path)){
                        @unlink($img_path);
                        @unlink($thumb_path);
                    }
                    header('Location: slider.php');
                    exit();
                }
            }else{
                echo '<div class="alert alert-warning">الصفحة غير موجودة</div>';
            }
            ?>
        </div>
    </div>
</section>
<?php
include('inc/footer.php');
?>
