<?php
/********************************************
 * Function Page                            *
 * Powered by: SyrianMonster.com            *
 * Author: Saleh Alali - salali79@gmail.com *
 * Date: 15/05/2017
********************************************/
//////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// Admin Function ///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function loggedAdminIn($admin_id){
		return isset($admin_id);
	}

	function adminData($admin_id){
		global $con;
		$statement = $con->prepare("SELECT * FROM admin WHERE id=?");
		$statement->execute(array($admin_id));
		$row = $statement->fetch();
		return $row;
	}

//////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////// Items Function ///////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function getAllItems($table, $state='all', $order = ' ORDER BY id DESC '){
		global $con;
		if($state == 'all'){
			$state_q = '';
		}else{
			$state_q = ' WHERE state ='.$state;
		}
		$statement = $con->prepare("SELECT * FROM $table $state_q $order");
		$statement->execute();
		$row = $statement->fetchAll();
		return $row;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function getLimitItems($table, $state='all',$start=0,$limit=12, $order = ' ORDER BY id DESC '){
		global $con;
		if($state == 'all'){
			$state_q = '';
		}else{
			$state_q = ' WHERE state ='.$state;
		}
		$statement = $con->prepare("SELECT * FROM $table $state_q $order LIMIT $start,$limit");
		$statement->execute();
		$row = $statement->fetchAll();
		return $row;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function getOneItem($table,$where=' '){
		global $con;
		if($where == ' '){
			$state_q = '';
		}else{
			$state_q = $where;
		}
		$statement = $con->prepare("SELECT * FROM $table$state_q  LIMIT 1");
		$statement->execute();
		$row = $statement->fetch();
		return $row;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function getItemById($table,$id){
		global $con;
		$statement = $con->prepare("SELECT * FROM ".$table." WHERE id=?");
		$statement->execute(array($id));
		$row = $statement->fetch();
		return $row;
	}

//////////////////////////////////////////////////////////////////////////////////////////////////////
	function checkItem($select,$from,$value){
		global $con;
		$statement = $con->prepare("SELECT $select FROM $from WHERE $select = ?");
		$statement->execute(array($value));
		$count = $statement->rowCount();
		return $count;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function countItems($item,$table){
		global $con;
		$statement = $con->prepare("SELECT COUNT($item) FROM $table");
		$statement->execute();
		return $statement->fetchColumn();
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function latestItems($table, $select = '*', $order ='id', $limit = 2){
		global $con;
		$statement = $con->prepare("SELECT $select FROM $table ORDER BY $order DESC LIMIT $limit");
		$statement->execute();
	    $row = $statement->fetchAll();
	    return $row;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function getSpecialItems($table, $where = '', $order = ' ORDER BY id DESC '){
		global $con;
		if($where == ' '){
			$sql = ' ';
		}else{
			$sql = $where;
		}
		$statement = $con->prepare("SELECT * FROM $table$sql$order");
		$statement->execute();
		return $statement->fetchAll();
	}
/////////////////////////////////////////////////////////////////////////////////////
////////////////////////// Categories Function //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
	function getLastLevelCat(){
		global $con;
		$statement = $con->prepare("SELECT * FROM  categories WHERE id not in (SELECT LEVEL FROM categories) AND LEVEL !=0");
		$statement->execute();
		$row = $statement->fetchAll();
		return $row;
	}
////////////////////////////////////////////////////////////////////////////////////
	function getMainCat(){
		global $con;
		$statement = $con->prepare("SELECT * FROM  categories WHERE parent =0 AND state=1 ORDER BY cat_order ASC");
		$statement->execute();
		$row = $statement->fetchAll();
		return $row;
	}
////////////////////////////////////////////////////////////////////////////////////
	function getAllSecondaryCat($catid){
		global $con;
		$statement = $con->prepare("SELECT * FROM  categories WHERE parent = ? AND state=1  ORDER BY cat_order ASC,id ASC");
		$statement->execute(array($catid));
		$row = $statement->fetchAll();
		return $row;
	}

////////////////////////////////////////////////////////////////////////////////////
	function getAllCatToAddSecondaryCat(){
		global $con;
		$statement = $con->prepare("SELECT * FROM categories WHERE  id not in (SELECT cat_id FROM products)");
		$statement->execute();
		$row = $statement->fetchAll();
		return $row;
	}
////////////////////////////////////////////////////////////////////////////////////
	/*function getAllCatToEditSecondaryCat($catid){
		global $con;
		$statement = $con->prepare("SELECT * FROM categories WHERE id != ? AND $catid not in (level) AND id not in (SELECT cat_id FROM products)");
		$statement->execute(array($catid));
		$row = $statement->fetchAll();
		return $row;
	}*/
function getAllCatToEditSecondaryCat($catid){
    global $con;
    $statement = $con->prepare("SELECT * FROM categories WHERE id != ? AND id not in (SELECT cat_id FROM products)");
    $statement->execute(array($catid));
    $row = $statement->fetchAll();
    return $row;
}
/////////////////////////////////////////////////////////////////////////////////////
	function checkCatToAddSecondaryCat($id){
		global $con;
		$statement = $con->prepare("SELECT id FROM  categories WHERE  id = ?  AND id not in (SELECT cat_id FROM products)");
		$statement->execute(array($id));
		$count = $statement->rowCount();
		return $count;
	}
	/////////////////////////////////////////////////////////////////////////////////////
	function getAllCatToAddProducts(){
		global $con;
		$statement = $con->prepare("SELECT * FROM  categories WHERE id not in (SELECT LEVEL FROM categories) ");
		$statement->execute();
		$row = $statement->fetchAll();
		return $row;
	}
/////////////////////////////////////////////////////////////////////////////////////
	/*function checkCatToAddProducts($id){
		global $con;
		$statement = $con->prepare("SELECT id FROM  categories WHERE LEVEL !=0 AND id = ?  AND id not in (SELECT LEVEL FROM categories) ");
		$statement->execute(array($id));
		$count = $statement->rowCount();
		return $count;
	}*/
function checkCatToAddProducts($id){
    global $con;
    $statement = $con->prepare("SELECT id FROM  categories WHERE id = ?  AND id not in (SELECT LEVEL FROM categories) ");
    $statement->execute(array($id));
    $count = $statement->rowCount();
    return $count;
}
/////////////////////////////////////////////////////////////////////////////////////
////////////////////////// Products Function //////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
	function getProductImg($id){
		global $con;
		$statement = $con->prepare("SELECT * FROM products_img WHERE product_id = ?");
		$statement->execute(array($id));
		return $statement->fetchAll();
	}
/////////////////////////////////////////////////////////////////////////////////////
	function countProductByBrand($brandid){
		global $con;
		$statement = $con->prepare("SELECT COUNT(id) FROM products WHERE brand_id = ?");
		$statement->execute(array($brandid));
		return $statement->fetchColumn();
	}
////////////////////////////////////////////////////////////////////////////////////
	function getProductsByBrand($brandid,$state='all'){
		global $con;
		if($state == 'all'){
			$state_q = '';
		}else{
			$state_q = ' AND state ='.$state;
		}
		$statement = $con->prepare("SELECT * FROM products WHERE brand_id =? $state_q");
		$statement->execute(array($brandid));
		$row = $statement->fetchAll();
		return $row;
	}
////////////////////////////////////////////////////////////////////////////////////
	function getProductsByCat($catid,$state='all'){
		global $con;
		if($state == 'all'){
			$state_q = '';
		}else{
			$state_q = ' AND state ='.$state;
		}
		$statement = $con->prepare("SELECT * FROM products WHERE cat_id =? $state_q");
		$statement->execute(array($catid));
		$row = $statement->fetchAll();
		return $row;
	}
////////////////////////////////////////////////////////////////////////////////////
	function getProductsByCatLevel($catlevel,$state='all'){
		global $con;
		$sub_cat_array = array();
		$pro_array = array();
		if($state == 'all'){
			$state_q = '';
		}else{
			$state_q = ' AND state ='.$state;
		}

		$sub_cat = $con->prepare("SELECT * FROM categories WHERE  `level` REGEXP '".$catlevel."' $state_q");
		//$sub_cat = $con->prepare("SELECT * FROM categories WHERE  `level` REGEXP ',".$catlevel."$' OR `level`='".$catlevel."' $state_q");
		$sub_cat->execute();
		$sub_cat_row = $sub_cat->fetchAll();
		if(count($sub_cat_row) > 0 ){
			foreach ($sub_cat_row as  $sub_cat_value) {
				$sub_cat_id = $sub_cat_value['id'];
				$sub_cat_array[] = $sub_cat_id;
			}
		}else{
			$sub_cat_array[] =  $cat_id;
		}
		$sub_cat_array = implode(',',$sub_cat_array);
		$pro = $con->prepare("SELECT * FROM products WHERE cat_id in (".$sub_cat_array.") $state_q");
		$pro->execute();
		$row_pro = $pro->fetchAll();
		if(count($row_pro) > 0){
			foreach ($row_pro as  $pro_value) {
				$pro_id = $pro_value['id'];
				$pro_array[] = $pro_id;
			}
		}
		return $pro_array;
	}
////////////////////////////////////////////////////////////////////////////////////
	function getLimitProducts($start=0,$limit=12, $order = ' ORDER BY id DESC ',$and=' '){
		global $con;
		$statement = $con->prepare("SELECT * FROM products WHERE state=1 $and$order LIMIT $start,$limit");
		$statement->execute();
		$row = $statement->fetchAll();
		return $row;
	}

////////////////////////////////////////////////////////////////////////////////////
	function getLevelCat($arr,$lang='ar',$main_cat=''){
	    $level_arr = explode(',', $arr);
		$level_arr = array_reverse($level_arr);
		$level_arr_name = '<ol>';
		$i=0;
		foreach ($level_arr as $value) {
			$i++;
			if($i == 1){
				$main_cat = $main_cat;
			}else{
				$main_cat = '';
			}
			$item = getItemById('categories',$value);
			if($lang=='ar'){
				$item_title = $item['title'];
			}else{
				$item_title = $item['title_en'];
			}
			$level_arr_name .= '<li>'.$item_title.$main_cat.'_'.$item['id'].'</li>';
		}
		$level_arr_name .= '</ol>';
		return $level_arr_name;
	}

///////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////// Setting Function //////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function getSettingByName($name){
		global $con;
		$statement = $con->prepare("SELECT * FROM settings WHERE name=?");
		$statement->execute(array($name));
		$row = $statement->fetch();
		return $row;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////// Search Function /////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
/* function searchItems($suggested,$lang,$state){
	 global $con;
	 $sub_cat_array = array();
	 $pro_array = array();
	 $keyword   = "%$suggested%";
	 $statement = $con->prepare("(SELECT * FROM products WHERE state=$state AND (title like :data1 OR content like :data2 or title_en like :data1 OR content_en like :data2)) UNION ALL
								 (SELECT * FROM products WHERE state=$state AND
									 brand_id in (SELECT id FROM brands WHERE (title like :data1 or title_en like :data1)))") ;
	 $statement->bindParam(':data1', $keyword);
	 $statement->bindParam(':data2', $keyword);
	 if($statement->execute()){
	 $row = $statement->fetchAll();
	 if(count($row) > 0){
		 foreach ($row as  $value) {
			 $pro_array[] = $value['id'];
		 }
	 //$pro_array = implode(',',$pro_array);
	 }
	 }else{
		 echo 'ffff';
	 }
	 //echo 'products: '.count($pro_array);
	 $cat = $con->prepare("(SELECT * FROM categories WHERE (title like :data1 or title_en like :data1))") ;
	 $cat->bindParam(':data1', $keyword);
	 $cat->execute();
	 $cat_row = $cat->fetchAll();
	 //echo 'categories: '.count($cat_row);
	 if(count($cat_row) > 0){
		 foreach ($cat_row as  $cat_value) {
			 $cat_id    = $cat_value['id'];
			 $sub_cat = $con->prepare("SELECT * FROM categories WHERE  `level` REGEXP '".$cat_id."'");
			 //$sub_cat = $con->prepare("SELECT * FROM categories WHERE  `level` REGEXP ',".$cat_id."$' OR `level`='".$cat_id."'");
			 $sub_cat->execute();
			 $sub_cat_row = $sub_cat->fetchAll();
			 if(count($sub_cat_row) > 0 ){
				 foreach ($sub_cat_row as  $sub_cat_value) {
					 $sub_cat_id = $sub_cat_value['id'];
					 $sub_cat_array[] = $sub_cat_id;
				 }
			 }else{
				 $sub_cat_array[] =  $cat_id;
			 }
		 }
		 //echo 'sub_categories: '.count($sub_cat_array);
		 $sub_cat_array = implode(',',$sub_cat_array);
		 $pro = $con->prepare("SELECT * FROM products WHERE cat_id in (".$sub_cat_array.")");
		 $pro->execute();
		 $row_pro = $pro->fetchAll();
		 if(count($row_pro) > 0){
			 foreach ($row_pro as  $pro_value) {
				 $pro_id = $pro_value['id'];
				 $pro_array[] = $pro_id;
			 }
		 }
	 }
	 //echo $sub_cat_array;
	 $pro_array_final = array_unique($pro_array);
	 //echo count($pro_array_finel);
	 return $pro_array_final;
} */
///////////////////////////////////////////////////////////////////////////////////
function searchItems($suggested,$lang='ar',$state=1){
    global $con;
    if($lang=='ar'){
        $title = 'title';
        $content = 'content';
    }else{
        $title = 'title_en';
        $content = 'content_en';
    }
    $keyword   = "%$suggested%";
    $statement = $con->prepare("(SELECT id,'about' AS tbl FROM about WHERE state=$state AND ($title like :data1 OR content like :data2) ) UNION ALL
    							(SELECT id,'news' AS tbl FROM news WHERE state=$state AND ($title like :data1 OR content like :data2) ) UNION ALL
								(SELECT id,'categories' AS tbl FROM categories WHERE state=$state AND ($title like :data1) AND id in (SELECT cat_id FROM products)) UNION ALL
        						(SELECT id,'products' AS tbl FROM products WHERE state=$state AND ($title like :data1 OR content like :data2)) ORDER BY tbl ") ;
    $statement->bindParam(':data1', $keyword);
    $statement->bindParam(':data2', $keyword);
    $statement->execute();
    $row = $statement->fetchAll();
    return $row;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////// getHeader Function ////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
function getHeaderTop($site_name ='', $title ='',$page_url ='', $keywords ='', $description ='', $author ='', $image ='', $twitter_site ='', $twitter_creator ='', $twitter_domain =''){
    $meta = '<!DOCTYPE html>
    <html>
    <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <base href="'.HOST_NAME.'" />
    <meta property="og:locale:alternate" content="en_US"/>
    <meta property="og:type" content="article"/>
    <meta name="twitter:card" content="summary_large_image"/>
    <title>'.$title.'</title>
    <meta name="keywords"            content="'.$keywords.'"/>
    <meta name="description"         content="'.$description.'"/>
    <meta name="author"              content="'.$author.'">
    <meta name="twitter:site"        content="'.$twitter_site.'"/>
    <meta name="twitter:creator"     content="'.$twitter_creator.'"/>
    <meta name="twitter:domain"      content="'.$twitter_domain.'"/>
    <meta name="twitter:title"       content="'.$title.'"/>
    <meta name="twitter:description" content="'.$description.'"/>
    <meta name="twitter:image"       content="'.$image.'"/>
    <meta property="og:site_name"    content="'.$site_name.'"/>
    <meta property="og:title"        content="'.$title.'"/>
    <meta property="og:description"  content="'.$description.'"/>
    <meta property="og:url"          content="'.$page_url.'">
    <meta property="og:image"        content="'.$image.'"/>';
    return $meta;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////// getMenuName Function ////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
function getMenuName($id,$lang){
    global $con;
    $statement = $con->prepare("SELECT * FROM menu WHERE id=?");
    $statement->execute(array($id));
    $row = $statement->fetch();
    if($lang=='ar'){
        $menu_name = $row['title'];
    }else{
        $menu_name = $row['title_en'];
    }
    return $menu_name;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////
function getMenuNameByPageName($page_name,$lang){
    global $con;
    $statement = $con->prepare("SELECT * FROM menu WHERE page_name=?");
    $statement->execute(array($page_name));
    $row = $statement->fetch();
    if($lang=='ar'){
        $menu_name = $row['title'];
    }else{
        $menu_name = $row['title_en'];
    }
    return $menu_name;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////
function getPageHeader($page_id){
    global $con;
    $statement = $con->prepare("SELECT * FROM menu WHERE id=?");
    $statement->execute(array($page_id));
    $row = $statement->fetch();
    $menu_img = $row['image'];
    return $menu_img;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////Other function////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////
	function strlenText($txt){
		$txt = str_replace('&nbsp;',' ',$txt);
		$txt = strip_tags($txt);
		return strlen($txt);
	}
	function cutText($txt,$lg_max){
        $strg = "";
        $txt = str_replace('&nbsp;',' ',$txt);
        $txt = strip_tags($txt);
        if (strlen($txt) > $lg_max)
        {
            $strg = mb_substr($txt, 0, $lg_max, "UTF-8");
            $last_space = strrpos($strg, " ");
            if ($last_space !=0){$strg = mb_substr($strg, 0, $last_space,"UTF-8")." ...";}
            return $strg;
        }else{
          return $txt;

        }

    }
	////////////////////////////////////////////////////////////////////////////////////////////////
	function auto_copyright($year = 'auto'){
	 if(intval($year) == 'auto'){ $year = date('Y'); }
	 if(intval($year) == date('Y')){ echo intval($year); }
	 if(intval($year) < date('Y')){ echo intval($year) . ' - ' . date('Y'); }
	 if(intval($year) > date('Y')){ echo date('Y'); }
	 }
