<?php
use PHPMailer\PHPMailer\PHPMailer;
include_once('PHPMailer/PHPMailer.php');
include_once('PHPMailer/Exception.php');
//----
if (isset($_REQUEST['submit'])){
	
	$temp_name=strip_tags($_REQUEST['c_name']);
	$form_name=htmlentities($temp_name, ENT_QUOTES);
	
	$temp_phone=strip_tags($_REQUEST['c_phone']);
	$form_phone=htmlentities($temp_phone, ENT_QUOTES);
	
	$temp_email=strip_tags($_REQUEST['c_email']);
	$form_email=htmlentities($temp_email, ENT_QUOTES);
	
	$temp_message=strip_tags($_REQUEST['c_message']);
	$form_message=htmlentities($temp_message, ENT_QUOTES);
	
	if($_REQUEST['captcha']<>$_SESSION['code']){
		$_SESSION['complaintdone']='<div class="alert alert-warning" role="alert" id="success_message">'.$CheckVerificationCode.'</div>';	
		$_SESSION['info']=array($form_name,$form_phone,$form_email,$form_message);	
		
	}else{
		
		$messageBody .= '<p>'.$contact_name.': ' . $form_name . '</p>' . "\n";
		$messageBody .= '<br>' . "\n";
		$messageBody .= '<p>'.$contact_phone.': ' . $form_phone . '</p>' . "\n";
		$messageBody .= '<br>' . "\n";
		$messageBody .= '<p>'.$contact_email.': ' . $form_email . '</p>' . "\n";
		$messageBody .= '<br>' . "\n";
		$messageBody .= '<br>' . "\n";
		$messageBody .= '<p>'.$contact_message.': ' . $form_message . '</p>' . "\n";
	
        $mail=new PHPMailer();
        $mail->CharSet = 'UTF-8';
        $mail->addAddress('info@auhd.edu.sy');
        $mail->setFrom($form_email);
        $mail->Subject=$ComplaintSubject;
        $mail->isHTML(true);
        $mail->Body=$messageBody;
        if($mail->send()){
            $_SESSION['complaintdone']='<div class="alert alert-success" role="alert" id="success_message">'.$ComplaintMessageDone.'</div>';
            $_SESSION['info']='';
        }
        
    }
}
//--------------------
$home_department=$database->query('select * from '.$tab2.' where Xtype=1 order by Id ASC LIMIT 0,8')->fetchAll();
$home_doctors=$database->query('select * from '.$tab2.' where Xtype=2 order by Id ASC LIMIT 0,8')->fetchAll();
$home_patients1=$database->query('select * from '.$tab2.' where Xtype=3 order by Id ASC LIMIT 0,4')->fetchAll();
$home_patients2=$database->query('select * from '.$tab2.' where Xtype=3 order by Id ASC LIMIT 0,4')->fetchAll();
$home_stat=$database->get($tab8,'*',["Id"=>1]);
$home_events=$database->query('select * from '.$tab2.' where Xtype in (4,5,6,7) order by RecDate DESC LIMIT 0,3')->fetchAll();

$home_ads1=$database->query('select * from '.$tab2.' where Xtype in (13,14) order by RecDate DESC LIMIT 0,4')->fetchAll();
$home_ads2=$database->query('select * from '.$tab2.' where Xtype in (15,16) order by RecDate DESC LIMIT 0,4')->fetchAll();

?>
<section class="medical-departments-area">
    <div class="container">
        <div class="sec-title">
            <h1><?php echo $MedicalDepartmentsDivisions?></h1>
            <span class="border"></span>
        </div>
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="medical-departments-carousel">
                <?php
                foreach($home_department as $home_department){   
                    $dept_href='./'.$DepartmentsDir.'/'.$home_department['Id'].'/'.$_SESSION['lang'].'';
                ?>
                    <div class="single-item text-center">
                        <div class="iocn-holder" style="padding-<?php echo $align?>: 30%">
                            <span class="d-block">                        
                                <img src="./img/uploads1/<?php echo $home_department['RecIcon']?>" alt="<?php echo $home_department['RecTitle'.$_SESSION['lang'].'']?>" style="width: 60%"/>   
                            </span>    
                        </div>
                        <div class="text-holder">
                            <h3 style="overflow: hidden; white-space: nowrap; text-overflow: ellipsis; line-height: normal" title="<?php echo $home_department['RecTitle'.$_SESSION['lang'].'']?>"><?php echo $home_department['RecTitle'.$_SESSION['lang'].'']?></h3>
                            <p>
                                <?php
                                    $a= strip_tags($home_department['RecDesc'.$_SESSION['lang'].'']);
                                    echo string_cut($a,12);
                                ?>
                            </p>
                        </div>
                        <a class="readmore" href="<?php echo $dept_href?>"><?php echo $ReadMore2?></a>
                    </div>
                <?php
                }
                ?>
                </div>
            </div>    
        </div>
    </div>
</section>



<section class="service-area">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <div class="img-holder">
                    <img src="images/services/doctor.jpg" alt="Awesome Image">
                    <div class="overlay-content">
                        <p><?php echo $UniversityOfDamascus?><br>
						<?php echo $AssadUniversityHospitalinDamascus?></p>  
                    </div>    
                </div>
            </div>
            <div class="col-md-8">
                <div class="text-holder">
                    <!--Start tab box-->
                    <div class="tab-box">
                        <div class="tab-content">
                            <!--Start single tab pane-->
                            <?php
                            $i=0;
                            foreach($home_patients1 as $home_patients1){
                                $pat_href='./'.$PatientsDir.'/'.$home_patients1['Id'].'/'.$_SESSION['lang'].'';
                                
                                if($i<=0){
                                    $tab_active='active';
                                }else{
                                    $tab_active='';
                                }
                            ?>
                            <div class="tab-pane <?php echo $tab_active?>" id="<?php echo $home_patients1['Id']?>">
                                <div class="inner-content">
                                    <div class="sec-title">
                                        <h1><?php echo $ImportantInformationForPatientsAndVisitors?></h1>
                                        <span class="border"></span>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="text-box">
                                                <h3><?php echo $home_patients1['RecTitle'.$_SESSION['lang'].'']?></h3>
                                                <p>
                                                    <?php
                                                        $a= strip_tags($home_patients1['RecDesc'.$_SESSION['lang'].'']);
                                                        echo string_cut($a,35);
                                                    ?>
                                                </p>
                                                <a class="thm-btn" href="<?php echo $pat_href?>"><?php echo $ReadMore2?></a>
                                            </div>    
                                        </div>    
                                        <div class="col-md-6">
                                            <div class="img-box">
                                                <img src="./img/uploads1/medium/<?php echo $home_patients1['RecThumb']?>" alt="<?php echo $home_patients1['RecTitle'.$_SESSION['lang'].'']?>">
                                            </div>    
                                        </div>    
                                    </div>
                                </div>  
                            </div>
                        <?php
                                $i++;
                            }
                        ?>    
                        </div>
                        <ul class="nav nav-tabs tab-menu">
                        <?php
                        $j=0;
                        foreach($home_patients2 as $home_patients2){    
                            
                            if($j<=0){
                                $thumb_active='active';
                            }else{
                                $thumb_active='';
                            }
                        ?>    
                            <li class="<?php echo $thumb_active?>">
                                <a href="#<?php echo $home_patients2['Id']?>" data-toggle="tab">
                                    <div class="img-holder">
                                        <img src="./img/uploads1/small/<?php echo $home_patients2['RecThumb']?>" alt="<?php echo $home_patients2['RecTitle'.$_SESSION['lang'].'']?>">
                                        <div class="overlay-style-one">
                                            <div class="box">
                                                <div class="content">
                                                    <div class="iocn-holder">
                                                        <span class="flaticon-plus-symbol"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                                <h3><?php echo $home_patients2['RecTitle'.$_SESSION['lang'].'']?></h3>
                            </li>
                        <?php
                            $j++;
                        }
                        ?>    
                        </ul> 
                    </div>
                    <!--End tab box--> 
                </div>
            </div>
        </div>
    </div>
</section>
<section class="team-area">
    <div class="container">
        <div class="sec-title mar0auto text-center">
            <h1><?php echo $Doctors?></h1>
            <span class="border"></span>
        </div>
        <div class="row">
            <!--Start single item-->
            <div class="col-md-12">
                <div class="testimonial-carousel">
                    <!--Start single testimonial item-->
                    <?php
                    foreach($home_doctors as $home_doctors){
                        $doc_href='./'.$DoctorsDir.'/'.$home_doctors['Id'].'/'.$_SESSION['lang'].'';
                        $doc_dept=$database->get($tab2,'*',["Id"=>$home_doctors['CatId']]);
                        if($home_doctors['RecThumb']){
                            $docThumb=$home_doctors['RecThumb'];
                        }else{
                            $docThumb='docDeff.jpg';
                        }
                    ?>
                        <div class="single-team-member">
                            <a href="<?php echo $doc_href?>">
                            <div class="img-holder">
                                <img src="./img/uploads1/medium/<?php echo $docThumb?>" alt="<?php echo $home_doctors['RecTitle'.$_SESSION['lang'].'']?>">
                                <div class="overlay-style">
                                    <div class="box">
                                        <div class="content">
                                            <div class="top">
                                                <h3><?php echo $home_doctors['RecTitle'.$_SESSION['lang'].'']?></h3>
                                                <span><?php echo $doc_dept['RecTitle'.$_SESSION['lang'].'']?></span>
                                            </div>
                                            <span class="border"></span>
                                            <div class="bottom">
                                                <ul>
                                                    <li><i class="fa fa-phone" aria-hidden="true"></i><span dir="ltr"><?php echo $home_doctors['Xphone']?></span></li>
                                                    <li><i class="fa fa-envelope" aria-hidden="true"></i><?php echo $home_doctors['Xemail']?></li>
                                                </ul>    
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="text-holder">
                                    <h3><?php echo $home_doctors['RecTitle'.$_SESSION['lang'].'']?></h3>
                                    <span><?php echo $doc_dept['RecTitle'.$_SESSION['lang'].'']?></span>
                                </div>    
                            </div>
                            </a>
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>
            <!--End single item-->

        </div>
    </div>
</section>
<section class="fact-counter-area" style="background-image:url(images/resources/fact-counter-bg.jpg);">
    <div class="container">
        <div class="sec-title text-center">
            <h1><?php echo $HospitalStatistics?></h1>
        </div>
        <div class="row">
            <!--Start single item-->
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <ul>
                    <li>
                        <div class="single-item text-center">
                            <div class="icon-holder">
                                <span class="flaticon-medical"></span> 
                            </div>
                            <h1><span class="timer" data-from="1" data-to="<?php echo $home_stat['RecTitle1']?>" data-speed="5000" data-refresh-interval="50"><?php echo $home_stat['RecTitle1']?></span></h1>
                            <h3><?php echo $YearsOfService?></h3>
                        </div>
                    </li>
                    <li>
                        <div class="single-item text-center">
                            <div class="icon-holder">
                                <span class="flaticon-smile"></span> 
                            </div>
                            <h1><span class="timer" data-from="1" data-to="<?php echo $home_stat['RecTitle2']?>" data-speed="5000" data-refresh-interval="50"><?php echo $home_stat['RecTitle2']?></span></h1>
                            <h3><?php echo $PatientsNum?></h3>
                        </div>
                    </li>
                    <li>
                        <div class="single-item text-center">
                            <div class="icon-holder">
                                <span class="flaticon-medical-1"></span> 
                            </div>
                            <h1><span class="timer" data-from="1" data-to="<?php echo $home_stat['RecTitle3']?>" data-speed="5000" data-refresh-interval="50"><?php echo $home_stat['RecTitle3']?></span></h1>
                            <h3><?php echo $OperationsPerformed?></h3>
                        </div>
                    </li>
                    <li>
                        <div class="single-item text-center">
                            <div class="icon-holder">
                                <span class="flaticon-ribbon"></span> 
                            </div>
                            <h1><span class="timer" data-from="1" data-to="<?php echo $home_stat['RecTitle2']?>" data-speed="5000" data-refresh-interval="50"><?php echo $home_stat['RecTitle2']?></span></h1>
                            <h3><?php echo $Awards?></h3>
                        </div>
                    </li>
                </ul>
            </div>
            <!--End single item-->
     
        </div>
    </div>
</section>

<section class="latest-blog-area">
    <div class="container">
        <div class="sec-title">
            <h1><?php echo $LatestEvents?></h1>
            <span class="border"></span>
        </div>
        <div class="row">
        <?php
        foreach($home_events as $home_events){  
            switch($home_events['Xtype']){
                case 4:
                    $event_href='./'.$NewsHospitalDir.'/'.$home_events['Id'].'/'.$_SESSION['lang'].'';
                    break;
                case 5:
                    $event_href='./'.$NewsExhibitionDir.'/'.$home_events['Id'].'/'.$_SESSION['lang'].'';
                    break;
                case 6:
                    $event_href='./'.$NewsActivitiesDir.'/'.$home_events['Id'].'/'.$_SESSION['lang'].'';
                    break;
                case 7:
                    $event_href='./'.$NewsLecturesDir.'/'.$home_events['Id'].'/'.$_SESSION['lang'].'';
                    break;
            }
        ?>
            <div class="col-md-4">
                <div class="single-blog-item">
                    <div class="img-holder">
                        <img src="./img/uploads1/medium/<?php echo $home_events['RecThumb']?>" alt="<?php echo $home_events['RecTitle'.$_SESSION['lang'].'']?>">
                        <div class="overlay-style-one">
                            <div class="box">
                                <div class="content">
                                    <a href="<?php echo $event_href?>"><span class="flaticon-plus-symbol"></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="text-holder">
                        <a href="<?php echo $event_href?>">
                            <h3 class="blog-title"><?php echo $home_events['RecTitle'.$_SESSION['lang'].'']?></h3>
                        </a>
                        <div class="text">
                            <p>
                            <?php
                                $a= strip_tags($home_events['RecDesc'.$_SESSION['lang'].'']);
                                echo string_cut($a,18);
                            ?>
                            </p>
                        </div>
                        <ul class="meta-info">
                            <li><a href="javascript:;"><i class="fa fa-calendar" aria-hidden="true"></i><?php echo date("F j, Y, g:i a",$home_events['RecDate']);?></a></li>
                           
                        </ul>
                    </div>    
                </div>    
            </div>
        <?php
        }
        ?>
        </div>
    </div>
</section>

<section class="facilities-appointment-area">
    <div class="container">
        <div class="row">
            <div class="col-md-8">
                <div class="facilities-content-box">
                    <div class="sec-title">
                        <h1><?php echo $ImportantAds?></h1>
                        <span class="border"></span>
                    </div>
                    <div class="facilities-carousel">
                       
                        <!------Start single facilities item------->
                        <div class="single-facilities-item">
                            <div class="row">
                                <?php
                                if(count($home_ads1)>0){
                                    foreach($home_ads1 as $home_ads1){
                                        switch($home_ads1['Xtype']){
                                            case 13:
                                                $ads1_href='./'.$ImportantAdsDir.'/'.$home_ads1['Id'].'/'.$_SESSION['lang'].'';
                                                break;
                                            case 14:
                                                $ads1_href='./'.$TendersDir.'/'.$home_ads1['Id'].'/'.$_SESSION['lang'].'';
                                                break;
                                        }
                                ?>
                                <div class="col-md-6">
                                    <div class="single-item">
                                        <div class="icon-holder">
                                            <div class="icon-box">
                                                <div class="icon">
                                                    <span class="flaticon-medical"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-holder">
                                            <a href="<?php echo $ads1_href?>">
                                                <h3>
                                                    <?php echo $home_ads1['RecTitle'.$_SESSION['lang'].'']?>
                                                </h3>
                                            </a>
                                            <p>
                                                <?php
                                                    $a= strip_tags($home_ads1['RecDesc'.$_SESSION['lang'].'']);
                                                    echo string_cut($a,10);
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                        
                        <div class="single-facilities-item">
                            <div class="row">
                                <?php
                                if(count($home_ads2)>0){
                                    foreach($home_ads2 as $home_ads2){
                                        switch($home_ads2['Xtype']){
                                            case 15:
                                                $ads2_href='./'.$PurchaseOrdersDir.'/'.$home_ads2['Id'].'/'.$_SESSION['lang'].'';
                                            break;
                                            case 16:
                                                $ads2_href='./'.$DecisionsCircularsDir.'/'.$home_ads2['Id'].'/'.$_SESSION['lang'].'';
                                            break;
                                        }
                                ?>
                                <div class="col-md-6">
                                    <div class="single-item">
                                        <div class="icon-holder">
                                            <div class="icon-box">
                                                <div class="icon">
                                                    <span class="flaticon-medical"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-holder">
                                            <a href="<?php echo $ads2_href?>">
                                                <h3>
                                                    <?php echo $home_ads2['RecTitle'.$_SESSION['lang'].'']?>
                                                </h3>
                                            </a>
                                            <p>
                                                <?php
                                                    $a= strip_tags($home_ads2['RecDesc'.$_SESSION['lang'].'']);
                                                    echo string_cut($a,10);
                                                ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                    }
                                }
                                ?>
                            </div>                        
                        </div>

                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="appointment ">
                    <div class="sec-title">
                        <h1><?php echo $ComplaintSubmitTitle?></h1>
                        <span class="border"></span>
                    </div>
                    <?php echo $_SESSION['complaintdone']?>
                    <form  action="" method="post" role="form" data-toggle="validator">
                        <div class="row">
                            <div class="col-md-12">
                                
                              <div class="form-group">
                                <input name="c_name" type="text" class="form-control" id="c_name" placeholder="<?php echo $ComplaintName?>" required style="border-radius: 0px; box-shadow: none">
                              </div>
                                
                              <div class="form-group">
                                <input name="c_phone" type="phone" class="form-control" id="c_phone" placeholder="<?php echo $ComplaintPhone?>" style="border-radius: 0px; box-shadow: none" required>
                              </div>
                                
                              <div class="form-group">
                                <input name="c_email" type="email" class="form-control" id="c_email" placeholder="<?php echo $ComplaintEmail?>" style="border-radius: 0px; box-shadow: none" required>
                              </div>
                                
                              <div class="form-group">
                                  <textarea rows="4" name="c_message" class="form-control" placeholder="<?php echo $ComplaintMessage?>" style="border-radius: 0px; box-shadow: none" ></textarea>
                              </div>
                              <div class="form-group">
                                    <div style="display: block; padding-bottom: 10px">
                                      <label style="font-weight: normal"><?php echo $VerificationCode?> <img src="./image.php"></label>
                                    </div>
                                  <input name="captcha" type="text" id="captcha" dir="ltr" class="form-control"  style="border-radius: 0px; box-shadow: none">
                                </div>
<!--                                <button class="thm-btn bgclr-1" type="submit"><?php echo $ComplaintBtn?></button> -->
                                <input name="submit" type="submit" class="thm-btn bgclr-1" id="submit" value="<?php echo $ComplaintBtn?>">
                            </div>
                        </div>
                    </form>        
                </div>
            </div>
            
        </div>
    </div>    
</section>