<?php

include "../include/config.php";
include "../include/common_functions.php";
include "../include/functions_auth.php";
include "../common.php";
include "../include/config.inc.php";
include "../include/forms_function.php";
include "../include/class.form.php";

header('Content-type: text/html; charset=utf-8');
$smarty->assign('template_root', $config['admin_theme_path']);

$header = MainMenu("forms");

@$sel = $_REQUEST['sel'];

$_REQUEST['id_attr'] = strip_tags($_REQUEST['id_attr']);
$_REQUEST['id_sec'] = strip_tags($_REQUEST['id_sec']);

switch ($sel) {
    case 'get_section_attrs'://echo 1;
        $id_section = $_REQUEST['id_section'];
        GetSectionAttrs($id_section);
        break;
    case 'get_attr_form':
        $act = $_REQUEST['act'];
        $id_section = $_REQUEST['id_sec'];
        $id_attr = $_REQUEST['id_attr'];
        GetAttributeForm($act, $id_section, $id_attr);
        break;
    case 'get_attr_props_form':
        $control_type = $_REQUEST['control_type'];
        $id_attr = isset($_REQUEST['id_attr']) ? $_REQUEST['id_attr'] : 0;
        GetAttributePropertiesForm($control_type, $id_attr);
        break;
    case 'add_attr':
        $id_section = $_REQUEST['id_sec'];
        AddAttribute($id_section);
        break;
    case 'update_attr':
        $id_attr = $_REQUEST['id_attr'];
        $id_section = $_REQUEST['id_sec'];
        UpdateAttribute($id_attr, $id_section);
        break;
    case 'del_section_attr':
        $id_attr = $_REQUEST['id_attr'];
        $form = new Form($dbconn, $config);
        $form->delSectionAttribute($id_attr);
        echo "";
        break;
}

function GetSectionAttrs($id_section) {
    global $dbconn, $config, $smarty, $admin_nl_gentemplates;

    $form = new Form($dbconn, $config);
    $attrs = $form->getSectionAttributes($id_section, $total_count);

    $smarty->assign('attrs', $attrs);
    $smarty->assign('total_count', $total_count);
    $smarty->assign('id_section', $id_section);
    header("Content-Type: text/plain; charset=utf-8");
    $smarty->display("$admin_nl_gentemplates/ajax_sec_attrs.tpl");
}

function GetAttributeForm($act, $id_section, $id_attr) {
    global $dbconn, $config, $smarty, $admin_nl_gentemplates;

    $form = new Form($dbconn, $config);
    $regs = $form->getRegExps();

    if ($act == 'new') {
        $save_link = "ajax_sections.php?sel=add_attr&id_sec=" . $id_section;
    } else {
        $attr = $form->getSectionAttribute($id_attr);
        $type = $form->getControlType($control_type);
        $save_link = "ajax_sections.php?sel=update_attr&id_attr=" . $id_attr . "&id_sec=" . $id_section;
        if ($attr['control_type'] == 'select') {
            $max_ref = 0;
            foreach ($attr['setup']['values'] as $index => $option) {
                $s_data[] = implode('&', $option);
                if ($max_ref < $option['id'])
                    $max_ref = $option['id'];
            }
            $s_data = implode(';', $s_data);
            $s_data.=';';
            $smarty->assign('max_ref', $max_ref);
            $smarty->assign('s_data', $s_data);
            $ds = $form->getAllDataSources();
            $smarty->assign('ds', $ds);
        }
        $smarty->assign('attr', $attr);
        $smarty->assign('type_text', $type);
    }
    $id_attr = isset($id_attr) ? $id_attr : 'null';
    $smarty->assign('id_attr', $id_attr);
    $smarty->assign('act', $act);
    $smarty->assign('save_link', $save_link);
    $smarty->assign('regs', $regs);

    if ($act != 'new') {
        $smarty->assign('type', $attr['control_type']);
        $attr_form_content = $smarty->fetch("$admin_nl_gentemplates/attr_props_form.tpl");
        $smarty->assign('attr_form_content', $attr_form_content);
    }
    $smarty->display("$admin_nl_gentemplates/attr_edit_form.tpl");
}

function GetAttributePropertiesForm($control_type, $id_attr) {
    global $dbconn, $config, $smarty, $admin_nl_gentemplates;

    $form = new Form($dbconn, $config);
    $regs = $form->getRegExps();

    $type = $form->getControlType($control_type);
    if ($id_attr > 0) {
        $attr = $form->getSectionAttribute($id_attr);
        if ($attr['control_type'] == $control_type)
            $smarty->assign('attr', $attr);
    }

    if ($control_type == 'select') {
        $ds = $form->getAllDataSources();
        $smarty->assign('ds', $ds);
    }
    $smarty->assign('type', $control_type);
    $smarty->assign('type_text', $type);
    $smarty->assign('regs', $regs);
    $smarty->display("$admin_nl_gentemplates/attr_props_form.tpl");
}

function AddAttribute($id_section) {
    global $dbconn, $config, $smarty, $admin_nl_gentemplates;

    $attr_data['field_name'] = $_REQUEST['field_name'];
    $attr_data['mandatory'] = isset($_REQUEST['mandatory']) ? 'Y' : 'N';
    $attr_data['control_type'] = $_REQUEST['control_type'];
    $attr_setup = array();

    switch ($_REQUEST['control_type']) {
        case 'checkbox':
            $attr_setup['def_value'] = isset($_REQUEST['def_value']) ? 1 : 0;
            break;
        case 'text':
            $attr_setup['def_value'] = $_REQUEST['def_value'];
            $attr_setup['max_len'] = $_REQUEST['max_len'];
            $attr_setup['reg_exp'] = $_REQUEST['reg_exp'];
            break;
        case 'select':
            $attr_setup = array();
            $i = 0;
            $temp = explode(';', $_REQUEST['s_data']);
            foreach ($temp as $element) {
                if ($element == '')
                    continue;
                $temp_elem = explode('&', $element);
                $attr_setup['values'][$i]['id'] = $temp_elem[0];
                $attr_setup['values'][$i]['name'] = $temp_elem[1];
                $i++;
            }
            $attr_setup['select_type'] = $_REQUEST['select_type'];
            if ($attr_setup['select_type'] == 'listbox') {
                $attr_setup['vsize'] = $_REQUEST['vsize'];
                $attr_setup['is_mult'] = isset($_REQUEST['is_mult']) ? 1 : 0;
            }
            $attr_setup['datasource'] = $_REQUEST['datasource'];
            break;
        case 'textarea':
            $attr_setup['def_value'] = $_REQUEST['def_value'];
            $attr_setup['reg_exp'] = $_REQUEST['reg_exp'];
            break;
        case 'password':
            $attr_setup['reg_exp'] = $_REQUEST['reg_exp'];
            break;
        case 'date':
            $attr_setup['min_age'] = $_REQUEST['min_age'];
            $attr_setup['max_age'] = $_REQUEST['max_age'];
            break;
    }

    $attr_data['setup'] = $attr_setup;
    $form = new Form($dbconn, $config);
    $form->addSectionAttribute($id_section, $attr_data);
    header("location: form_blocks.php?id_section=" . $id_section);
}

function UpdateAttribute($id_attr, $id_section) {
    global $dbconn, $config, $smarty, $lang;

    $attr_data['field_name'] = $_REQUEST['field_name'];
    $attr_data['mandatory'] = isset($_REQUEST['mandatory']) ? 'Y' : 'N';
    $attr_data['control_type'] = $_REQUEST['control_type'];
    $attr_setup = array();

    switch ($_REQUEST['control_type']) {
        case 'checkbox':
            $attr_setup['def_value'] = isset($_REQUEST['def_value']) ? 1 : 0;
            break;
        case 'text':
            $attr_setup['def_value'] = $_REQUEST['def_value'];
            $attr_setup['max_len'] = $_REQUEST['max_len'];
            $attr_setup['reg_exp'] = $_REQUEST['reg_exp'];
            break;
        case 'select':
            $attr_setup = array();
            $i = 0;
            $temp = explode(';', $_REQUEST['s_data']);
            foreach ($temp as $element) {
                if ($element == '')
                    continue;
                $temp_elem = explode('&', $element);
                $attr_setup['values'][$i]['id'] = $temp_elem[0];
                $attr_setup['values'][$i]['name'] = $temp_elem[1];
                $i++;
            }
            $attr_setup['select_type'] = $_REQUEST['select_type'];
            if ($attr_setup['select_type'] == 'listbox') {
                $attr_setup['vsize'] = intval($_REQUEST['vsize']);
                $attr_setup['is_mult'] = isset($_REQUEST['is_mult']) ? 1 : 0;
            }
            $attr_setup['datasource'] = $_REQUEST['datasource'];
            break;
        case 'textarea':
            $attr_setup['def_value'] = $_REQUEST['def_value'];
            $attr_setup['reg_exp'] = $_REQUEST['reg_exp'];
            break;
        case 'password':
            $attr_setup['reg_exp'] = $_REQUEST['reg_exp'];
            break;
        case 'date':
            $attr_setup['min_age'] = $_REQUEST['min_age'];
            $attr_setup['max_age'] = $_REQUEST['max_age'];
            break;
    }

    $attr_data['setup'] = $attr_setup;
    $form = new Form($dbconn, $config);
    $form->updateSectionAttribute($id_attr, $attr_data);
    header("location: form_blocks.php?id_section=" . $id_section);
}

