<?php

include "include/config.php";
include "include/common_functions.php";
include "include/functions_auth.php";
include "common.php";
include "include/config.inc.php";
include "include/newsletters_function.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$file_name = $config["server"] . "/newsletters.php";
$smarty->assign("form_action", $file_name);
$this_page = "newsletters";
$smarty->assign("this_page", $this_page);

if ($mode == 1) {
    @$sel = $_POST["sel"] ? $_POST["sel"] : $_GET["sel"];
    switch ($sel) {
        case "delete": if (IsFunctionAllowed($auth["id"], 2)) {
                DeleteNewsletter();
            } else {
                ListNewsletter();
            } break;
        case "addarchive": if (IsFunctionAllowed($auth["id"], 5)) {
                AddToArchive();
            } else {
                ListNewsletter();
            } break;
        case "view_archive": ViewArchive();
            break;
        case "delete_archive": DeleteFromArhive();
            break;
        case "create_step1": if (IsFunctionAllowed($auth["id"], 1)) {
                Create_Step1();
            } else {
                ListNewsletter();
            } break;
        case "save_step1": Save_Step1();
            break;
        case "save_step2": Save_Step2();
            break;
        case "view": ViewNewsletter();
            break;
        case "send": if (IsFunctionAllowed($auth["id"], 4)) {
                SendNewsletter();
            } else {
                ListNewsletter();
            } break;
        case "send_ajax": SendAjax();
            break;
        case "spam_dialog": SpamDialog();
            break;
        case "check_spam": CheckSpam();
            break;
        case "viewcompatibility": ViewCompatibility();
            break;
        case "rule_client": RuleClient();
            break;
        case "schedule": ScheduleList();
            break;
        case "add_schedule": AddSchedule();
            break;
        case "schedule_delete": DeleteSchedule();
            break;
        case "undelivered": Undelivered();
            break;
        case "error_send": Error_Send();
            break;
        case "undeliv_send": Failed_Send();
            break;
        case "location": Location();
            break;
        case "set_filter": SetFilter();
            break;
        case "set_a_filter": SetAFilter();
            break;
        default: ListNewsletter();
    }
}

function ListNewsletter() {
    global $lang, $config, $smarty, $dbconn, $auth;

    AdminMainMenu("newsletters");
    if (IsFunctionAllowed($auth["id"], 4)) {
        $smarty->assign("send_newsl", 1);
    }
    if (IsFunctionAllowed($auth["id"], 1)) {
        $smarty->assign("create_newsl", 1);
    }
    if (IsFunctionAllowed($auth["id"], 2)) {
        $smarty->assign("delete_newsl", 1);
    }
    if (IsFunctionAllowed($auth["id"], 5)) {
        $smarty->assign("archive_newsl", 1);
    }

    $settings = GetUserSettings(array('send_period', 'from_name', 'from_email', 'smtp_quota', 'send_period', 'is_tips'));
    $is_test = ($settings["from_email"] != "") ? 1 : 0;

    $strSQL = "SELECT COUNT(id) FROM " . CRELEASES_TABLE . " WHERE id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $amount = $res->fields[0];

    $data = array();
    $i = 0;
    $strSQL = "SELECT cr.id, cr.subject, DATE_FORMAT(cr.date,'{$config["date_format"]}') as date,cr.format, cr.priority, cr.is_attach, IF((SELECT id FROM " . ARCHIVE_TABLE . " WHERE newsletter_id=cr.id),1,0) as in_archive FROM " . CRELEASES_TABLE . " cr WHERE cr.id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $data[$i]['id'] = $res->fields[0];
        $data[$i]['subject'] = $res->fields[1];
        $data[$i]['date'] = $res->fields[2];
        $data[$i]['format'] = $res->fields[3];
        $data[$i]['format_str'] = $lang["newsletters"][$res->fields[3]];
        $data[$i]['priority'] = $res->fields[4];
        $data[$i]['is_attach'] = $res->fields[5];
        $data[$i]['in_archive'] = $res->fields[6];
        $i++;
        $res->MoveNext();
    }
    ArrStripSlashes($data);

    $type_dispatch = GetUserSettings("type_dispatch");
    $smtp_s = GetSmtpInfo(1);

    if ($type_dispatch == "smtp" && count($smtp_s) == 0) {
        $smarty->assign("is_smtp", 0);
    }

    get_smarty_array_list("newsletter_page", $config["newsletter_page"]);
    $smarty->assign("is_test", $is_test);
    $smarty->assign("amount", $amount);
    $smarty->assign("data", $data);
    $smarty->assign("is_tips", $settings['is_tips']);

    $smarty->display($config["admin_nl_gentemplates"] . "/newsletters.tpl");
}

function Create_Step1($error = 0) {
    global $smarty, $config, $auth, $dbconn, $lang;

    AdminMainMenu("newsletters");
    $id = intval($_GET["id"]);
    $data = array();
    if ($id) {
        $strSQL = "SELECT id, subject, format FROM " . CRELEASES_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}";
        $res = $dbconn->Execute($strSQL);
        $data["id"] = $res->fields[0];
        $data["subject"] = $res->fields[1];
        $data["format"] = $res->fields[2];
    }
    ArrStripSlashes($data);
    if ($error) {
        $smarty->assign("error", $lang["err"]["empty_newsl_subject"]);
        $smarty->assign("data", $_POST);
    } else {
        $smarty->assign("data", $data);
    }

    $smarty->assign("temp", getTemplates());

    $settings = GetUserSettings(array('is_tips'));
    $smarty->assign("is_tips", $settings['is_tips']);

    $smarty->display($config["admin_nl_gentemplates"] . "/newsletters_create_step1.tpl");
}

function Save_Step1() {
    global $smarty, $config, $auth, $dbconn;

    if ($_POST["subject"] == "") {
        Create_Step1(1);
        exit;
    }
    $badwordchars = array(
        "\xe2\x80\x98", // left single quote
        "\xe2\x80\x99", // right single quote
        "\xe2\x80\x9c", // left double quote
        "\xe2\x80\x9d", // right double quote
        "\xe2\x80\x94", // em dash
        "\xe2\x80\xa6" // elipses
    );
    $fixedwordchars = array(
        "&#8216;",
        "&#8217;",
        '&#8220;',
        '&#8221;',
        '&mdash;',
        '&#8230;'
    );
    $_POST["subject"] = token2br(str_replace($badwordchars, $fixedwordchars, $_POST["subject"]));

    ArrAddSlashes($_POST);
    $id = intval($_POST["id"]);
    if (!$id) {
        $strSQL = "INSERT INTO " . CRELEASES_TABLE . " (subject,format,date,id_user) VALUES('{$_POST["subject"]}','{$_POST["format"]}', NOW(),{$auth["id"]})";
        $dbconn->Execute($strSQL);
        $id = $dbconn->_insertid();
    } else {
        $strSQL = "UPDATE " . CRELEASES_TABLE . " SET subject='{$_POST["subject"]}',format='{$_POST["format"]}' WHERE id={$id} AND id_user={$auth["id"]}";
        $dbconn->Execute($strSQL);
    }

    Create_Step2($id);
    exit;
}

function Create_Step2($id, $error = 0) {
    global $smarty, $config, $auth, $dbconn, $lang;

    AdminMainMenu("newsletters");
    $data = array();
    $strSQL = "SELECT id,body,body_text,format,priority,match_confirm, subject FROM " . CRELEASES_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $row = $res->GetRowAssoc(false);
    $data["id"] = $row["id"];
    $data["body"] = $row["body"];
    $data["body_text"] = $row["body_text"];
    $data["format"] = $row["format"];
    $data["priority"] = $row["priority"];
    $data["match_confirm"] = $row["match_confirm"];
    $data["attach"] = array();
    $data["attach"] = getAttaches($id);
    $data["attach_count"] = count($data["attach"]);
    $data["lists"] = array();
    $data["lists"] = getLists($id);
    $data["lists_count"] = count($data["lists"]);
    $data["target"] = array();
    $data["target"] = getLists($id, 1);
    $data["target_count"] = count($data["target"]);

    $data["subject"] = $row['subject'];

    if (isset($_POST["temp_id"])) {
        $content = getTemplates(intval($_POST["temp_id"]));
        if ($data["format"] == "text") {
            $data["body_text"] = token2br($content["body_text"]);
        } else {
            $data["body"] = token2br($content["body_html"]);
        }
    }

    foreach ($config["priority"] as $val => $out) {
        $priority_values[] = $val;
        $priority_output[] = $out;
    }
    $smarty->assign("priority_values", $priority_values);
    $smarty->assign("priority_output", $priority_output);

    ArrStripSlashes($data);
    if ($error) {
        $smarty->assign("error", $lang["err"]["empty_newsl_content"]);
        $data = $_POST;
        $data["attach"] = array();
        $data["attach"] = getAttaches($id);
        foreach ($data["attach"] as $key => $val) {
            if (in_array($data["attach"][$key]["id"], $data["attaches"]))
                $data["attach"][$key]["sel"] = 1;
        }
        $data["attach_count"] = count($data["attach"]);
        $data["lists"] = array();
        $data["lists"] = getLists($id);
        foreach ($data["lists"] as $key => $val) {
            if (in_array($data["lists"][$key]["id"], $data["list"]))
                $data["lists"][$key]["sel"] = 1;
        }
        $data["lists_count"] = count($data["lists"]);
    }

    //Initialize FCKEditor
    include_once "fckeditor/fckeditor.php";

    $editor = new FCKeditor('body_html');
    $editor->Value = $data["body"];
    $editor->Width = '100%';
    $editor->Height = '500';
    $editor->BasePath = $config["server"] . '/fckeditor/';
    $editor->Config['AutoDetectLanguage'] = false;
    $fck_lang = file_exists($config["site_path"] . '/fckeditor/editor/lang/' . $config["lang_code"] . ".js") ? $config["lang_code"] : "en";
    $editor->Config['DefaultLanguage'] = $fck_lang;
    $smarty->assign("editor", $editor->CreateHtml());
    //Initialize FCKEditor

    $google_track = GetUserSettings(array('use_google_analytics_tracking', 'google_analytics_source_default'));

    if ($google_track['use_google_analytics_tracking']) {
        $google_track['utm_campaign'] = GetGoogleData($data["id"], $auth["id"]);
    }

    $data['google_tracking'] = $google_track;
    $smarty->assign("data", $data);

    $settings = GetUserSettings(array('is_tips'));
    $smarty->assign("is_tips", $settings['is_tips']);

    $smarty->display($config["admin_nl_gentemplates"] . "/newsletters_create_step2.tpl");
    exit;
}

function Save_Step2() {
    global $smarty, $config, $auth, $dbconn, $file_name;

    $error = 0;
    if ($_POST["format"] == "html") {
        if ($_POST["body_html"] == "") {
            $error = 1;
        }
    } elseif ($_POST["format"] == "text") {
        if ($_POST["body_text"] == "") {
            $error = 1;
        }
    } elseif ($_POST["format"] == "htmltext") {
        if ($_POST["body_html"] == "" || $_POST["body_text"] == "") {
            $error = 1;
        }
    }
    if ($error) {
        Create_Step2(intval($_POST["id"]), 1);
        exit;
    }
    //echo $_POST["body_html"]; exit;
    ArrAddSlashes($_POST);

    $id = intval($_POST["id"]);
    $priority = intval($_POST["priority"]);
    $list = isset($_POST["list"]) ? $_POST["list"] : 0;
    $attach = isset($_POST["attaches"]) ? $_POST["attaches"] : '';
    $match_confirm = intval($_POST["match_confirm"]);

    $strSQL = "UPDATE " . CRELEASES_TABLE . "
					SET priority='{$priority}',body='{$_POST["body_html"]}',body_text='{$_POST["body_text"]}',match_confirm='{$match_confirm}'
					WHERE id={$id} AND id_user={$auth["id"]}";
    $dbconn->Execute($strSQL);

    $strSQL = "DELETE FROM " . CRELEASES_LISTS_TABLE . " WHERE crelease_id={$id}";
    $dbconn->Execute($strSQL);
    if ($list)
        foreach ($list as $list_id) {
            $strSQL = "INSERT INTO " . CRELEASES_LISTS_TABLE . " SET crelease_id={$id}, list_id={$list_id}";
            $dbconn->Execute($strSQL);
        }

    $strSQL = "DELETE FROM " . RELEASE_ATTACH_TABLE . " WHERE release_id={$id}";
    $dbconn->Execute($strSQL);

    if ($attach)
        foreach ($attach as $attach_id) {
            $strSQL = "INSERT INTO " . RELEASE_ATTACH_TABLE . " SET release_id={$id}, attach_id={$attach_id}";
            $dbconn->Execute($strSQL);
        }
    if (count($attach) > 0) {
        $strSQL = "UPDATE " . CRELEASES_TABLE . " SET is_attach=1 WHERE id={$id}";
        $dbconn->Execute($strSQL);
    }

    if (isset($_POST['utm_campaign'])) {
        $google_data['utm_campaign'] = mysql_real_escape_string($_POST['utm_campaign']);
        ChangeGoogleData($id, $auth["id"], $google_data);
    }

    $arch_file_name = false;
    $strSQL = "SELECT id, name FROM " . ARCHIVE_TABLE . " WHERE newsletter_id={$id} AND id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    if ($res->fields[0]) {
        $arch_file_name = $res->fields[1];
    }
    if ($arch_file_name) {
        $header = $footer = "";
        $strSQL = "SELECT id, subject, body FROM " . CRELEASES_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}";
        $res = $dbconn->Execute($strSQL);

        $res->fields[1] = str_replace("#", "", $res->fields[1]);
        $arch_file_name = str_replace(" ", "_", $res->fields[1]) . "_" . date("Y_m_d") . ".html";
        if (strpos($res->fields[2], "<html") === false) {
            $header = "<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'><title>{$arch_file_name}</title></head><body>";
            $footer = "</body></html>";
        } else {
            $res->fields[2] = str_replace("<head>", "<head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>", $res->fields[2]);
        }

        $file = $config["files_path"] . $arch_file_name;
        $fp = fopen($file, "w");
        $search = array("%BASIC:EMAIL%", "%BASIC:FIRSTNAME%", "%BASIC:SECONDNAME%", "%BASIC:UNSUBLINK%", "%BASIC:TELLFREND%", "%BASIC:WEBVERSION%");
        $replace = array("", "", "", "", "", "");
        $content = str_replace($search, $replace, $_POST["body_html"]);
        $file_content = $header . stripslashes($content) . $footer;
        if ($fp) {
            fwrite($fp, $file_content);
            fclose($fp);
        }
        chmod($file, 0777);
    }

    ListNewsletter();
    //header("Location: {$file_name}");
    exit;
}

function ViewNewsletter() {
    global $config, $smarty, $lang, $file_name;
    AdminMainMenu("newsletters");

    $format = ($_GET["format"] == "html" || $_GET["format"] == "") ? "body" : "body_text";
    $format = ($_GET["format"] == "htmltext") ? "body" : $format;
    $data = getContent(intval($_GET['id']), $format);

    //$data["content"] = preg_replace("'href\s*=\s*[\"\'](?![#])(.*://|)([-a-z0-9+&@#\/%=~_|\.?]*)[\"\']'ixe",
    $data["content"] = preg_replace("'href\s*=\s*[\"\']([^#\"\'>]+://|)?((?!mailto)[^#\"\'>]+)[\"\'>]'ixe", "'href=\"{$config["server"]}/click.php?cl='.urlencode('\\2').'\"'", $data["content"]);

    $smarty->assign("data", $data);
    $smarty->assign("selected", $_GET["format"]);
    $smarty->assign("form_action", $file_name . "?sel=view&id={$_GET['id']}");
    $smarty->assign("html", $lang["common"]["html"]);
    $smarty->assign("text", $lang["common"]["text"]);
    $smarty->display($config["admin_nl_gentemplates"] . "/templates_view.tpl");
    exit;
}

function getContent($id, $format = "body") {
    global $dbconn, $auth;

    if ($_GET["format"] == "") {
        $strSQL = "SELECT format,body,body_text FROM " . CRELEASES_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}";
        $res = $dbconn->Execute($strSQL);
        $data = array();
        $data["format"] = $res->fields[0];
        if ($res->fields[0] == "text") {
            $data["content"] = nl2br($res->fields[2]);
        } else {
            $data["content"] = $res->fields[1];
        }
    } else {
        $strSQL = "SELECT {$format}, format FROM " . CRELEASES_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}";
        $res = $dbconn->Execute($strSQL);
        if ($_GET["format"] == "text") {
            //echo $res->fields[0];
            $data["content"] = nl2br($res->fields[0]);
        } else {
            $data["content"] = $res->fields[0];
        }
        //$data["content"] = $res->fields[0];
        $data["format"] = $res->fields[1];
    }
    ArrStripSlashes($data);
    return $data;
}

function DeleteNewsletter() {
    if (isset($_POST["del"])) {
        foreach ($_POST["del"] as $val) {
            delRelease(intval($val));
        }
    } elseif (isset($_GET['did']) && !empty($_GET['did'])) {
        delRelease(intval($_GET['did']));
    }
    ListNewsletter();
    exit;
}

function ViewArchive() {
    global $lang, $config, $smarty, $dbconn, $auth;

    AdminMainMenu("newsletters");


    $strSQL = "SELECT COUNT(id) FROM " . ARCHIVE_TABLE . " WHERE id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $amount = $res->fields[0];

    $strSQL = "SELECT id, subject,DATE_FORMAT(date,'{$config["date_format"]}') as date,name,link FROM " . ARCHIVE_TABLE . " WHERE id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $data = array();
    $c = 0;
    while (!$res->EOF) {
        $data[$c]['id'] = $res->fields[0];
        $data[$c]['subject'] = $res->fields[1];
        $data[$c]['date'] = $res->fields[2];
        $data[$c]['name'] = $res->fields[3];
        $data[$c]['link'] = $res->fields[4];

        $res->MoveNext();
        $c++;
    }
    ArrStripSlashes($data);
    $smarty->assign("amount", $amount);
    $smarty->assign("data", $data);
    get_smarty_array_list("newsletter_page", $config["newsletter_page"]);

    $smarty->display($config["admin_nl_gentemplates"] . "/newsletters_archive.tpl");
}

function AddToArchive() {
    global $dbconn, $config, $auth;

    $id = intval($_GET['id']);
    $header = $footer = "";
    $strSQL = "SELECT id, name FROM " . ARCHIVE_TABLE . " WHERE newsletter_id={$id} AND id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    if ($res->fields[0]) {
        $strSQL = "DELETE FROM " . ARCHIVE_TABLE . " WHERE newsletter_id={$id} AND id_user={$auth["id"]}";
        $dbconn->Execute($strSQL);
        if (file_exists($config["site_path"] . "/files/" . $res->fields[1]))
            unlink($config["site_path"] . "/files/" . $res->fields[1]);
    }
    $strSQL = "SELECT id, subject, body FROM " . CRELEASES_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);

    $res->fields[1] = str_replace("#", "", $res->fields[1]);
    $file_name = str_replace(" ", "_", $res->fields[1]) . "_" . date("Y_m_d") . ".html";
    if (strpos($res->fields[2], "<html") === false) {
        $header = "<html><head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'><title>{$file_name}</title></head><body>";
        $footer = "</body></html>";
    } else {
        $res->fields[2] = str_replace("<head>", "<head><meta http-equiv='Content-Type' content='text/html; charset=utf-8'>", $res->fields[2]);
    }
    $file = $config["files_path"] . $file_name;
    $fp = fopen($file, "w");
    $search = array("%BASIC:EMAIL%", "%BASIC:FIRSTNAME%", "%BASIC:SECONDNAME%", "%BASIC:UNSUBLINK%", "%BASIC:TELLFREND%", "%BASIC:WEBVERSION%");
    $replace = array("", "", "", "", "", "");
    $content = str_replace($search, $replace, $res->fields[2]);
    $file_content = $header . stripslashes($content) . $footer;
    if ($fp) {
        fwrite($fp, $file_content);
        fclose($fp);
    }
    chmod($file, 0777);
    $strSQL = "INSERT INTO " . ARCHIVE_TABLE . " (subject,date,name,link,newsletter_id,id_user) VALUES('{$res->fields[1]}', NOW(),'{$file_name}','{$config["files_web"]}{$file_name}',{$id}, {$auth["id"]})";
    $dbconn->Execute($strSQL);

    ViewArchive();
    exit;
}

function DeleteFromArhive() {
    if (isset($_POST["del"])) {
        foreach ($_POST["del"] as $val) {
            delReleaseArhive(intval($val));
        }
    } elseif (isset($_GET['did']) && !empty($_GET['did'])) {
        delReleaseArhive(intval($_GET['did']));
    }
    //ListArhive();
    exit;
}

function SendNewsletter() {
    global $smarty, $config, $auth, $dbconn, $lang;
    //print_r($_SESSION['test_connections']); exit;
    AdminMainMenu("newsletters");
    if (!isset($_REQUEST["id"])) {
        ListNewsletter();
        exit;
    }
	
    $id = intval($_REQUEST["id"]);
    $error = 0;
    if ( isset($_POST["action"]) && ($_POST["action"] == "send" && count($_POST["list"]) > 0) ) {
		
        $id = intval($_POST['id']);
        ArrAddSlashes($_POST);
        $list = $_POST["list"] ? $_POST["list"] : 0;

        $sqllist = is_array($list) ? implode(',', $list) : $list;
        //Status=1 - Process; Status=2 - Complite; Status=3 - Cron;
        $strSQL = "INSERT INTO " . SEND_NEWSLETTERS_TABLE . " (id_newsletter, id_user, date_send, status, lists) VALUES({$id}, {$auth["id"]}, NOW(),1 , '{$sqllist}')";
        $dbconn->Execute($strSQL);
        $id_newsletter = $dbconn->Insert_ID();

        $_SESSION['send_counter'] = 0;

        $total_send = MakeQueue($id_newsletter, $_POST, $list, 0, 1, $id);


        unset($_SESSION['newsletter_data']);
        unset($_SESSION['send_settings']);
        unset($_SESSION['smtp_data']);

        $data = array();
        $data["id_newsletter"] = $id_newsletter;
        $data["total_send"] = $total_send;

        //header("Content-type: charset=utf-8");
        if ($config["phpversion"] == 4) {
            include_once "include/class.json.php";
            $json = new Services_JSON();
            echo $json->encode($data);
        } else {
            echo json_encode($data);
        }
        exit;
    } else {
        $error = 1;
    }

    if ($_REQUEST["is_test"] == "false") {
        $lists = getLists($id);
        $smarty->assign("lists", $lists);
        $target = getLists($id, 1);
        $smarty->assign("target", $target);
        //print_r($target); exit;
        $smarty->assign("list_count", count($lists));

        $strSQL = "SELECT match_confirm FROM " . CRELEASES_TABLE . " WHERE id={$id}";
        $res = $dbconn->Execute($strSQL);
        $row = $res->GetRowAssoc(false);
        if (!$error) {
            $smarty->assign("data", $row);
        } else {
            ArrStripSlashes($_POST);
            $smarty->assign("data", $_POST);
        }

        $smarty->assign("id", $id);
        $smarty->assign("jquery", 1);

        $settings = GetUserSettings(array('is_tips'));
        $smarty->assign("is_tips", $settings['is_tips']);

        $smarty->display($config["admin_nl_gentemplates"] . "/newsletters_send.tpl");
    } elseif ($_REQUEST["is_test"] == "true") {

        unset($_SESSION['newsletter_data']);
        unset($_SESSION['send_settings']);
        unset($_SESSION['smtp_data']);

        InitializationObjectForSend($id, false, $auth["id"], 0, true);
        InitializationObjectForSend($id, false, $auth["id"], 1, true);

        $data["status"] = 1;
        //header("Content-type: charset=utf-8");
        if ($config["phpversion"] == 4) {
            include_once "include/class.json.php";
            $json = new Services_JSON();
            echo $json->encode($data);
        } else {
            echo json_encode($data);
        }
        exit;
    }
}

function SendAjax() {
    global $smarty, $config, $auth, $dbconn, $lang;
    $id_newsletter = intval($_REQUEST["id_newsletter"]);
    $_SESSION['send_counter'] = $_SESSION['send_counter'] + 1;
    InitializationObjectForSend($id_newsletter, false);
    exit;
}

function SpamDialog() {
    global $config, $smarty;

    AdminMainMenu("newsletters");
    $smarty->assign("jquery", 1);
    $smarty->assign("no_logo", 1);
    $smarty->display($config["admin_nl_gentemplates"] . "/newsletters_check_spam.tpl");
}

function CheckSpam() {
    global $lang, $config, $smarty, $dbconn, $auth;

    AdminMainMenu("newsletters");
    ArrAddSlashes($_POST);
    $html = "";
    $error = "";

    if ($_POST["body"])
        if ($error = BadWordsCheck($_POST["body"])) {
            //words found
            $html .= "<span><b>{$lang["newsletters"]["spam_html"]}</b></span><br><br>
						<div class='help_text'>{$lang["newsletters"]["spam_exist"]}</div><br>
						<div>{$lang["newsletters"]["spam_word_detect"]}: {$error}</div><br>";

            /* <div>
              <img src='{$config["server"]}{$config["theme_path"]}{$config["default_image"]}/error.gif' alt='' border='0' />
              </div>
              {$lang["newsletters"]["spam_html"]} {$lang["err"]["bad_words"]} */
        } else {
            $html .= "<span><b>{$lang["newsletters"]["spam_html"]}</b></span><br><br>
						<div class='help_text'>{$lang["newsletters"]["spam_notexist"]}</div><br>
						<br>";

            /* <div class='help_text'>
              <img src='{$config["server"]}{$config["theme_path"]}{$config["default_image"]}/success.gif' alt='' border='0' />
              </div>
              {$lang["newsletters"]["spam_html_no"]} */
        }
    if ($_POST["body_text"])
        if ($error = BadWordsCheck($_POST["body_text"])) {
            //words found
            $html .= "<span><b>{$lang["newsletters"]["spam_text"]}</b></span><br><br>
						<div class='help_text'>{$lang["newsletters"]["spam_exist"]}</div><br>
						<div>{$lang["newsletters"]["spam_word_detect"]}: {$error}</div><br>";
            /* <div>
              <img src='{$config["server"]}{$config["theme_path"]}{$config["default_image"]}/error.gif' alt='' border='0' />
              </div>
              {$lang["newsletters"]["spam_text"]} {$lang["err"]["bad_words"]} */
        } else {
            $html .= "<span><b>{$lang["newsletters"]["spam_text"]}</b></span><br><br>
						<div class='help_text'>{$lang["newsletters"]["spam_notexist"]}</div><br>
						<br>";
            /* <div>
              <img src='{$config["server"]}{$config["theme_path"]}{$config["default_image"]}/error.gif' alt='' border='0' />
              </div>
              {$lang["newsletters"]["spam_text_no"]} */
        }
    echo $html;
}

function ViewCompatibility() {
    global $config, $smarty, $lang;

    AdminMainMenu("newsletters");

    @$view_mode = $_POST["view_mode"] ? $_POST["view_mode"] : $_GET["view_mode"];
    @$view_mode = $view_mode ? $view_mode : "original";
    $id_newsletter = intval($_GET["id_newsletter"]);

    $smarty->assign("id_newsletter", $id_newsletter);
    $smarty->assign("view_mode", $view_mode);
    $smarty->assign("jquery", 1);
    $smarty->assign("client", $lang["newsletters"]["client"]);
    $smarty->display($config["admin_nl_gentemplates"] . "/newsletters_view_compatibility.tpl");
}

function RuleClient() {
    global $config, $smarty, $lang, $auth, $dbconn;

    //$reqRuleName = isset($_GET['id'])? $_GET['id'] : null;
    $reqRuleName = isset($_POST['id']) ? $_POST['id'] : (isset($_GET['id']) ? $_GET['id'] : null);
    $id_newsletter = intval($_GET["id_newsletter"]);

    $design_rule_directory = "{$config["site_path"]}/include/design_rules/";
    $design_rule_files = list_files($design_rule_directory);

    foreach ($design_rule_files as $design_rule) {
        $filename_parts = pathinfo($design_rule);
        if (isset($filename_parts['extension']) && $filename_parts['extension'] == 'php') {
            require_once $design_rule_directory . $design_rule;
        }
    }

    $valid_design_rules = array_keys($GLOBALS['Design_Rules']);

    $strSQL = "SELECT body FROM " . CRELEASES_TABLE . " WHERE id={$id_newsletter} AND id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $content = $res->fields[0];

    @$action = $_GET["action"];
    switch ($action) {
        case "process_rules":
            if (in_array($reqRuleName, $valid_design_rules)) {
                $broken_rules = array();
                $broken_rules = RuleCheck($content, $reqRuleName, false);
                $print = "<div class='designRuleName'>" .
                        "<img class='align' src='{$config["server"]}{$config["theme_path"]}{$config["default_image"]}/" . (empty($broken_rules) ? "success.gif" : "error.gif") . "' alt='" . (empty($broken_rules) ? "success" : "failed") . "' />&nbsp;{$lang["newsletters"]["client"][$reqRuleName]}" .
                        "</div>";

                $response = "";
                if (!empty($broken_rules)) {
                    foreach ($broken_rules as $i => $broken_rule) {
                        $className = (($i + 1) % 2 == 0) ? "even" : "odd";
                        $response .= "<div class='" . $className . "'>" . $broken_rule . "</div>";
                    }
                } else {
                    $response .= "<div class='designRuleOK'>{$lang["newsletters"]["norules"]}</div>";
                }
                header('Content-type: text/html; charset=utf-8');
                print $print . $response;
            }
            exit;
        case "display":
            $new_content = RuleCheck($content, $reqRuleName, true);
            header('Content-type: text/html; charset=utf-8');
            echo $new_content;
            exit;
        default:
            $client = array();
            $i = 0;
            foreach ($valid_design_rules as $design_rule) {
                $client[$i]["rule"] = $design_rule;
                $client[$i]["name"] = $lang["newsletters"]["client"][$design_rule];
                $i++;
            }
            $smarty->assign("client", $client);
            $smarty->assign("jquery", 1);
            $smarty->assign("id_newsletter", $id_newsletter);
            $smarty->assign("loading_rule", $lang["newsletters"]["loading_rule"]);
            header('Content-type: text/html; charset="utf-8"');
            echo $smarty->fetch($config["admin_nl_gentemplates"] . "/newsletters_rule_client.tpl");
            exit;
    }
}

function RuleCheck($content, $design_type = 0, $replace_content = false) {
    global $config, $smarty, $lang, $GLOBALS;

    if (!$design_type) {
        return false;
    }
    if ($design_type == "original") {
        return $content;
    }
    if (!isset($GLOBALS['Design_Rules'][$design_type])) {
        return false;
    }
    $BrokenRules = array();
    foreach ($GLOBALS['Design_Rules'][$design_type] as $rule) {
        $matches_found = preg_match_all($rule['regular_expression'] . 'is', $content, $matches);

        if ($matches_found == 0) {
            continue;
        }

        $BrokenRules[] = $rule['description'];

        if (!$replace_content) {
            continue;
        }

        if (isset($rule['use_preg_replace']) && $rule['use_preg_replace'] == 1) {
            $content = preg_replace($rule['regular_expression'] . 'is', $rule['replacement'], $content);
        } else {
            $content = str_replace($matches[$rule['match_offset']], $rule['replacement'], $content);
        }
    }
    if (!$replace_content) {
        return $BrokenRules;
    } else {
        return $content;
    }
}

function ScheduleList($error = "") {
    global $lang, $config, $smarty, $dbconn, $auth;

    AdminMainMenu("newsletters");

    $data = array();
    $i = 0;

    //Status=1 - Process; Status=2 - Complite; Status=3 - Cron;
    $strSQL = "SELECT sn.id, c.subject, c.format,DATE_FORMAT(sn.date_send,'{$config["date_format"]} {$config["time_format"]}') as date_send
						FROM " . SEND_NEWSLETTERS_TABLE . " sn
						LEFT JOIN " . CRELEASES_TABLE . " c ON c.id=sn.id_newsletter AND c.id_user={$auth["id"]}
						WHERE sn.status=3 AND sn.id_user={$auth["id"]}";

    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $data[$i]['id'] = $res->fields[0];
        $data[$i]['subject'] = $res->fields[1];
        $data[$i]['format'] = $res->fields[2];
        $data[$i]['format_str'] = $lang["newsletters"][$res->fields[2]];
        $data[$i]['date'] = $res->fields[3];
        $i++;
        $res->MoveNext();
    }
    ArrStripSlashes($data);

    $newsletter = array();
    $strSQL = "SELECT id, subject FROM " . CRELEASES_TABLE . " WHERE id_user={$auth["id"]} ORDER BY subject";
    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $newsletter[$i]['id'] = $res->fields[0];
        $newsletter[$i]['name'] = $res->fields[1];
        $i++;
        $res->MoveNext();
    }
    ArrStripSlashes($newsletter);

    get_smarty_array_list("newsletter_page", $config["newsletter_page"]);
    if ($error != "")
        $smarty->assign("error", $error);
    $smarty->assign("int", array(1, 2, 3, 4, 5, 6));
    $smarty->assign("interval", $lang['interval']);
    $smarty->assign("amount", count($data));
    $smarty->assign("data", $data);
    $smarty->assign("newsletter", $newsletter);
    $smarty->assign("lang_code", $config["lang_code"]);

    $settings = GetUserSettings(array('is_tips'));
    $smarty->assign("is_tips", $settings['is_tips']);

    $smarty->display($config["admin_nl_gentemplates"] . "/newsletters_schedule.tpl");
}

function AddSchedule() {
    global $lang, $config, $smarty, $dbconn, $auth;

    if (!$_REQUEST["date_send"] || $_REQUEST["date_send"] == "" || !preg_match("|([0-9]{4})[-/\.]?([0-9]{1,2})[-/\.]?([0-9]{1,2})|", $_REQUEST["date_send"])) {
        ScheduleList($lang["err"]["schedule_date_sent"]);
        exit;
    }
    if (!$_REQUEST["id_newsletter"] || $_REQUEST["id_newsletter"] == "") {
        ScheduleList($lang["err"]["schedule_newsletter"]);
        exit;
    }

    ArrAddSlashes($_REQUEST);

    $period = "";
    if (isset($_REQUEST["int"])) {
        $period = intval($_REQUEST["int"]) . "|" . $_REQUEST["interval"];
    }

    if (isset($_REQUEST["time"])) {
        $time = " " . intval($_REQUEST["time_Hour"]) . ":" . intval($_REQUEST["time_Minute"]);
    } else {
        $time = "";
    }
    $id_newsletter = intval($_REQUEST["id_newsletter"]);

    $strSQL = "SELECT list_id FROM " . CRELEASES_LISTS_TABLE . " WHERE crelease_id={$id_newsletter}";
    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $row = $res->GetRowAssoc(false);
        $lists[$i]['id'] = $row["list_id"];
        $i++;
        $res->MoveNext();
    }

    //$lists = getLists($id_newsletter);
    $list_ids = array();
    foreach ($lists as $list) {
        $list_ids[] = $list['id'];
    }
    $lists = implode(',', $list_ids);
    //Status=1 - Process; Status=2 - Complite; Status=3 - Cron;
    $strSQL = "INSERT INTO " . SEND_NEWSLETTERS_TABLE . " (`id_newsletter`, `id_user`, `date_send`, `status`,`period`,`lists`) VALUES({$id_newsletter}, {$auth["id"]}, '{$_REQUEST["date_send"]}{$time}',3,'{$period}','{$lists}')";
    $dbconn->Execute($strSQL);
    ScheduleList();
}

function DeleteSchedule() {
    global $lang, $config, $smarty, $dbconn, $auth;

    if (!$_REQUEST["id"] || $_REQUEST["id"] == "") {
        ScheduleList();
        exit;
    }
    $id = intval($_REQUEST["id"]);

    //Status=1 - Process; Status=2 - Complite; Status=3 - Cron;
    $strSQL = "DELETE FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id={$id}";
    $dbconn->Execute($strSQL);
    ScheduleList();
}

function Undelivered() {
    global $lang, $config, $auth;

    $id_newsletter = intval($_REQUEST["id_newsletter"]);
    $total_send = IsQueue($id_newsletter, $auth["id"]);

    $data = array();
    $data["id_newsletter"] = $id_newsletter;
    $data["total_send"] = $total_send;

    //header("Content-type: charset=utf-8");
    if ($config["phpversion"] == 4) {
        include_once "include/class.json.php";
        $json = new Services_JSON();
        echo $json->encode($data);
    } else {
        echo json_encode($data);
    }
    exit;
}

function Error_Send() {
    global $lang, $config, $auth, $dbconn;

    $id_newsletter = intval($_REQUEST["id_newsletter"]);
    $total_send = IsQueue($id_newsletter, $auth["id"]);
    if (!$total_send) {
        $strSQL = "INSERT INTO " . WAITING_SEND_TABLE . " (id_subscriber,id_list,id_newsletter,id_user)
						SELECT u.id, su.id_list, su.id_newsletter, u.id_user
							FROM " . SEND_USERS_TABLE . " u
							LEFT JOIN " . SENT_USERS_TABLE . " su ON su.id_newsletter={$id_newsletter} AND su.status=" . ERROR . "
						WHERE u.id = su.id_subscriber AND u.id_user={$auth["id"]}";
        $dbconn->Execute($strSQL);
        $strSQL = "DELETE FROM " . SENT_USERS_TABLE . " WHERE id_newsletter={$id_newsletter} AND status=" . ERROR;
        $dbconn->Execute($strSQL);
        $total_send = IsQueue($id_newsletter, $auth["id"]);
    }
    //$settings = GetUserSettings(array('smtp_quota'), $auth["id"]);
    //if (intval($settings["smtp_quota"]) < $total_send && intval($settings["smtp_quota"]) != 0) {
    //	$total_send = intval($settings["smtp_quota"]);
    //}
    $data = array();
    $data["id_newsletter"] = $id_newsletter;
    $data["total_send"] = $total_send;

    header("Content-type: charset=utf-8");
    if ($config["phpversion"] == 4) {
        include_once "include/class.json.php";
        $json = new Services_JSON();
        echo $json->encode($data);
    } else {
        echo json_encode($data);
    }
    exit;
}

function Failed_Send() {
    global $lang, $config, $auth, $dbconn;

    $id_newsletter = intval($_REQUEST["id_newsletter"]);
    $total_send = IsQueue($id_newsletter, $auth["id"]);

    $data = array();
    $data["id_newsletter"] = $id_newsletter;
    $data["total_send"] = $total_send;

    header("Content-type: charset=utf-8");
    if ($config["phpversion"] == 4) {
        include_once "include/class.json.php";
        $json = new Services_JSON();
        echo $json->encode($data);
    } else {
        echo json_encode($data);
    }
    exit;
}

function Location() {
    global $config, $dbconn, $auth;

    if ((!isset($_GET["sel"])) || (!isset($_GET["id"])))
        exit;

    $id = intval($_GET["id"]);
    $action = $_GET["action"];

    header('Content-type: text/html; charset=utf-8');
    switch ($action) {
        case "template":
            $strSQL = "SELECT name FROM " . TEMPLATES_TABLE . " WHERE id={$id}";
            $res = $dbconn->Execute($strSQL);
            if (file_exists($config["site_path"] . "/pictures/{$res->fields[0]}.gif")) {
                echo "<img src=\"{$config["server"]}/pictures/{$res->fields[0]}.gif\" border=\"1\" title=\"{$res->fields[0]}\" width=\"300\">";
            } else {
                echo "<img src=\"{$config["server"]}/pictures/nopreview.gif\" border=\"1\" title=\"no preview available\" width=\"250\">";
            }
            break;
        case "view_large":
            $strSQL = "SELECT body, body_text FROM " . TEMPLATES_TABLE . " WHERE id={$id}";
            $res = $dbconn->Execute($strSQL);
            $body = $res->fields[0] ? $res->fields[0] : $res->fields[1];
            $body = html_entity_decode($body);
            echo $body;
            break;
        default: exit;
    }
}

function SetFilter() {
    global $config, $dbconn, $auth;

    $static_names_arr = array('fname', 'sname', 'email');
    $id_release = (isset($_REQUEST['id_release']) && intval($_REQUEST['id_release']) > 0) ? intval($_REQUEST['id_release']) : 0;
    if ($id_release > 0) {

        $data = array();

        foreach ($_REQUEST['filtertype'] as $key => $value) {
            if (!in_array($key, $static_names_arr)) {
                $key = intval($key);
            }
            $data[$key]['type'] = mysql_real_escape_string(strip_tags(trim($value)));
            $data[$key]['val'] = mysql_real_escape_string(strip_tags(trim($_REQUEST['filterval'][$key])));
        }

        ChangeFilterData($id_release, $auth['id'], $data);
    }

    /*
      Array
      (
      [filtertype] => Array
      (
      [0] => begin_from
      [1] => end_by
      [2] => contains
      )
      [filterval] => Array
      (
      [0] => Yu
      [1] => ev
      [2] => .ru
      )
      )
     */
}

function SetAFilter() {
    global $config, $dbconn, $auth;

    $static_names_arr = array('fname', 'sname', 'email');
    $id_autoresponder = (isset($_REQUEST['id_autoresponder']) && intval($_REQUEST['id_autoresponder']) > 0) ? intval($_REQUEST['id_autoresponder']) : 0;
    if ($id_autoresponder > 0) {

        $data = array();

        foreach ($_REQUEST['filtertype'] as $key => $value) {
            if (!in_array($key, $static_names_arr)) {
                $key = intval($key);
            }
            $data[$key]['type'] = mysql_real_escape_string(strip_tags(trim($value)));
            $data[$key]['val'] = mysql_real_escape_string(strip_tags(trim($_REQUEST['filterval'][$key])));
        }

        ChangeAFilterData($id_autoresponder, $auth['id'], $data);
    }
}

?>