<?php

include "include/config.php";
include "include/common_functions.php";
include "include/functions_auth.php";
include "common.php";
include "include/config.inc.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$this_page = "statistics";
$file_name = $config["server"] . "/statistics.php";
$smarty->assign("file_name", $file_name);

if ($mode == 1) {
    @$sel = $_POST["sel"] ? $_POST["sel"] : $_GET["sel"];
    switch ($sel) {
        case "sent": if (IsFunctionAllowed($auth["id"], 12)) {
                SentStatistics();
            } else {
                GeneralStatistics();
            } break;
        case "delete_stat": StatDelete();
            break;
        case "get_subscriber": GetSubscriber();
            break;
        case "responder": ResponderStatistics();
            break;
        case "email_campaigns": EmailCampaignsList();
            break;
        case "get_plot": SetObjectPlot();
            break;
        case "campaign_detailed": EmailCampaignView();
            break;
        case "campaign_export": EmailCampaignExport();
            break;
        case "campaign_print": EmailCampaignPrint();
            break;
        case "responder_stat": ResponderStatOne();
            break;
        case "responder_stat_export": ResponderStatOne('export');
            break;
        case "responder_stat_print": ResponderStatOne('print');
            break;
        default: if (IsFunctionAllowed($auth["id"], 11)) {
                GeneralStatistics();
            } else {
                header("index.php");
                exit;
            }
    }
}

function GeneralStatistics() {
    global $config, $smarty, $dbconn, $auth;

    AdminMainMenu("archive");
    //SetObjectPlot();
    switch (@$_GET["period"]) {
        case "1": $period1 = "";
            $period2 = "";
            break;
        case "7": $period1 = " AND date_status >= DATE_FORMAT((NOW() - INTERVAL 7 DAY),'%Y-%m-%d') AND date_status <= DATE_FORMAT(NOW(),'%Y-%m-%d') ";
            $period2 = " AND time >= DATE_FORMAT((NOW() - INTERVAL 7 DAY),'%Y-%m-%d') AND time <= DATE_FORMAT(NOW(),'%Y-%m-%d') ";
            break;
        case "30": $period1 = " AND date_status >= DATE_FORMAT((NOW() - INTERVAL 30 DAY),'%Y-%m-%d') AND date_status <= DATE_FORMAT(NOW(),'%Y-%m-%d') ";
            $period2 = " AND time >= DATE_FORMAT((NOW() - INTERVAL 30 DAY),'%Y-%m-%d') AND time <= DATE_FORMAT(NOW(),'%Y-%m-%d') ";
            break;
        default: $period1 = "";
            $period2 = "";
            $_GET["period"] = 1;
    }
    $strSQL = "SELECT COUNT(id) FROM " . SEND_USERS_TABLE . " WHERE id_user={$auth["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $total["total_subscribers"] = $rs->fields[0];

    $strSQL = "SELECT COUNT(DISTINCT client_id) FROM " . CLIENTS_LISTS_TABLE . " WHERE id_user={$auth["id"]} AND status_subscribe =" . SUBSCRIBE;
    $rs = $dbconn->Execute($strSQL);
    $total["subscribed_subscriber"] = $rs->fields[0];

    $strSQL = "SELECT COUNT(DISTINCT client_id) FROM " . CLICK_COUNTER_TABLE . " WHERE url='uns' AND link_type='unsubscribe' AND id_user={$auth["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $total["unsubscribed_subscriber"] = $rs->fields[0];

    $strSQL = "SELECT COUNT(id) FROM " . BOUNCE_EMAIL_TABLE . " WHERE id_user={$auth["id"]} AND view=0";
    $rs = $dbconn->Execute($strSQL);
    $total["bounce"] = $rs->fields[0];

    $strSQL = "SELECT COUNT(id) FROM " . LISTS_TABLE . " WHERE id_user={$auth["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $total["lists"] = $rs->fields[0];

    $strSQL = "SELECT COUNT(id) FROM " . CRELEASES_TABLE . " WHERE id_user={$auth["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $total["newsletters"] = $rs->fields[0];

    $i = 0;
    $data = array();
    $strSQL = "SELECT id, name FROM " . LISTS_TABLE . " WHERE id_user={$auth["id"]} ORDER BY name";
    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $row = $res->GetRowAssoc(false);
        $data[$i]["id"] = $row["id"];
        $data[$i]["list_name"] = $row["name"];

        $strSQL = "SELECT COUNT(DISTINCT client_id) FROM " . CLIENTS_LISTS_TABLE . " WHERE id_user={$auth["id"]} {$period1} AND status_subscribe=" . SUBSCRIBE . " AND list_id={$row["id"]}";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]["subscribe"] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT client_id) FROM " . CLICK_COUNTER_TABLE . " WHERE url='uns' {$period2} AND link_type='unsubscribe' AND id_user={$auth["id"]} AND list_id={$row["id"]}";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]["unsubscribe"] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT client_id) FROM " . CLIENTS_LISTS_TABLE . " WHERE id_user={$auth["id"]} {$period1} AND status_subscribe=" . UNCONF_SUB . " AND list_id={$row["id"]}";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]["unconfirm_subscribe"] = $rs->fields[0];

        $i++;
        $res->MoveNext();
    }

    $smarty->assign("period", $_GET["period"]);
    $smarty->assign("data", $data);
    $smarty->assign("total", $total);
    $smarty->display($config["admin_nl_gentemplates"] . "/archive_general_statistics.tpl");
    exit;
}

function SentStatistics() {
    global $config, $smarty, $dbconn, $auth, $lang;

    AdminMainMenu("archive");

    $strSQL = "SELECT * FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $amount = $res->RowCount();

    $data = array();
    $i = 0;
    /*
      $strSQL = "SELECT sn.*, DATE_FORMAT(sn.date_send,'{$config["date_format"]} {$config["time_format"]}') as date_send,
      (SELECT subject FROM " . CRELEASES_TABLE . " WHERE id=sn.id_newsletter) as subject
      FROM " . SEND_NEWSLETTERS_TABLE . " sn
      WHERE sn.id_user={$auth["id"]} AND is_responder=0";
     */

    $strSQL = "SELECT sn.*, (SELECT count(*) FROM " . SENT_USERS_TABLE . " WHERE id_newsletter=sn.id AND status=" . SEND . ") as snd_count,
            DATE_FORMAT(sn.date_send,'{$config["date_format"]} {$config["time_format"]}') as date_send,
            (SELECT subject FROM " . CRELEASES_TABLE . " WHERE id=sn.id_newsletter) as subject,
		(SELECT count(*) FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT id_subscriber FROM " . SENT_USERS_TABLE . " WHERE id_newsletter=sn.id_newsletter AND status=" . ERROR . ") AND id_user={$auth["id"]}) as count_error
              FROM " . SEND_NEWSLETTERS_TABLE . " sn
                    WHERE sn.id_user={$auth["id"]} AND is_responder=0";
    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $row = $res->GetRowAssoc(false);
        $data[$i]["id"] = $row["id"];
        $data[$i]["id_newsletter"] = $row["id_newsletter"];
        $data[$i]["date"] = $row["date_send"];
        $data[$i]["subject"] = stripslashes($row["subject"]);
        $data[$i]["count_all"] = $row["count_all"];
        $data[$i]["count_sent"] = $row["snd_count"];
        $data[$i]["count_error"] = $row["count_error"];
        $data[$i]["status"] = $row["status"];
        $data[$i]["status_str"] = $lang["archive"]["status"][$data[$i]["status"]];

        $strSQL = "SELECT id_subscriber FROM " . WAITING_SEND_TABLE . " WHERE id_newsletter={$data[$i]["id"]} AND id_user={$auth["id"]}";
        $rs1 = $dbconn->Execute($strSQL);
        if ($rs1->RowCount() > 0) {
            $wer = array();
            while (!$rs1->EOF) {
                $wer[] = $rs1->fields[0];
                $rs1->MoveNext();
            }
            $wer_str = implode(",", $wer);
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
								WHERE id IN ({$wer_str}) AND id_user={$auth["id"]}";
            $rs = $dbconn->Execute($strSQL);

            if ($rs && $rs->RowCount() > 0) {
                $data[$i]['undelivered'] = $rs->fields[0] ? $rs->RowCount() : 0;
            } else {
                $data[$i]['undelivered'] = 0;
            }
        } else {
            $data[$i]['undelivered'] = 0;
        }

        $strSQL = "SELECT COUNT(id) FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data[$i]["id"]} AND link_type='other' AND url !='uns'";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['link'] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data[$i]["id"]} AND url='uns' AND link_type='unsubscribe' AND id_user={$auth["id"]}) AND id_user={$auth["id"]}";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['unsubscribe'] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data[$i]["id"]} AND link_type='forward'";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['forward'] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT(id_subscr)) FROM " . CRELEASES_STAT_TABLE . " WHERE id_release={$data[$i]["id"]} AND id_user={$auth["id"]}";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['viewed'] = $rs->fields[0];

        if (!$data[$i]["subject"]) {
            unset($data[$i]);
        }
        $i++;
        $res->MoveNext();
    }

    get_smarty_array_list("archive_page", $config["archive_page"]);
    $smarty->assign("amount", $amount);
    $smarty->assign("data", $data);
    $smarty->display($config["admin_nl_gentemplates"] . "/archive_sent_newsletter_statistics.tpl");
    exit;
}

function ResponderStatistics() {
    global $config, $smarty, $dbconn, $auth, $lang;

    AdminMainMenu("archive");

    $strSQL = "SELECT COUNT(id) FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_user={$auth["id"]} AND is_responder=1";
    $res = $dbconn->Execute($strSQL);
    $amount = $res->fields[0];

    $data = array();
    $i = 0;
    $strSQL = "SELECT sn.*, DATE_FORMAT(sn.date_send,'{$config["date_format"]} {$config["time_format"]}') as date_send, (SELECT subject FROM " . AUTORESPONDER_TABLE . " WHERE id=sn.id_newsletter) as subject
					FROM " . SEND_NEWSLETTERS_TABLE . " sn
					WHERE sn.id_user={$auth["id"]} AND sn.is_responder=1";

    $res = $dbconn->Execute($strSQL);
    while (!$res->EOF) {
        $row = $res->GetRowAssoc(false);
        $data[$i]["id"] = $row["id"];
        $data[$i]["id_newsletter"] = $row["id_newsletter"];
        $data[$i]["date"] = $row["date_send"];
        $data[$i]["subject"] = stripslashes($row["subject"]);
        $data[$i]["count_all"] = $row["count_all"];
        $data[$i]["count_sent"] = $row["count_sent"];
        $data[$i]["count_error"] = $row["count_error"];
        $data[$i]["status"] = $row["status"];
        $data[$i]["status_str"] = $lang["archive"]["status"][$data[$i]["status"]];


        $strSQL = "SELECT id_subscriber FROM " . WAITING_SEND_TABLE . " WHERE id_newsletter={$data[$i]["id"]} AND id_user={$auth["id"]}";
        $rs1 = $dbconn->Execute($strSQL);
        if ($rs1->RowCount() > 0) {
            $wer = array();
            while (!$rs1->EOF) {
                $wer[] = $rs1->fields[0];
                $rs1->MoveNext();
            }
            $wer_str = implode(",", $wer);
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
								WHERE id IN ({$wer_str}) AND id_user={$auth["id"]}";
            $rs = $dbconn->Execute($strSQL);

            if ($rs && $rs->RowCount() > 0) {
                $data[$i]['undelivered'] = $rs->fields[0] ? $rs->RowCount() : 0;
            } else {
                $data[$i]['undelivered'] = 0;
            }
        } else {
            $data[$i]['undelivered'] = 0;
        }
        //$data[$i]["undelivered"] = $data[$i]["count_all"] - $data[$i]["count_sent"] - $data[$i]["count_error"];

        $strSQL = "SELECT COUNT(id) FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data[$i]["id"]} AND link_type='other' AND url !='uns'";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['link'] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data[$i]["id"]} AND url='uns' AND link_type='unsubscribe' AND id_user={$auth["id"]}) AND id_user={$auth["id"]}";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['unsubscribe'] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data[$i]["id"]} AND link_type='forward'";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['forward'] = $rs->fields[0];

        $strSQL = "SELECT COUNT(DISTINCT(id_subscr)) FROM " . CRELEASES_STAT_TABLE . " WHERE id_release={$data[$i]["id"]}";
        $rs = $dbconn->Execute($strSQL);
        $data[$i]['viewed'] = $rs->fields[0];

        if (!$data[$i]["subject"]) {
            unset($data[$i]);
        }
        $i++;
        $res->MoveNext();
    }

    get_smarty_array_list("archive_page", $config["archive_page"]);
    $smarty->assign("amount", $amount);
    $smarty->assign("data", $data);
    $smarty->assign("responder", 1);
    $smarty->display($config["admin_nl_gentemplates"] . "/archive_sent_newsletter_statistics.tpl");
    exit;
}

function StatDelete() {
    global $dbconn, $auth;

    $dbconn->Execute("DELETE FROM " . CLICK_COUNTER_TABLE . " WHERE id_user={$auth["id"]}");
    $dbconn->Execute("DELETE FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_user={$auth["id"]}");
    $dbconn->Execute("DELETE FROM " . CRELEASES_STAT_TABLE . " WHERE id_user={$auth["id"]}");
	
    SentStatistics();
    exit;
}

function GetSubscriber() {
    global $config, $smarty, $dbconn, $auth;

    AdminMainMenu("archive");
    if ($_REQUEST['id'] && strval(intval($_REQUEST['id'])) != $_REQUEST['id']) {
        $arr = @explode("_", $_REQUEST['id']);
        if (is_array($arr) && count($arr) > 0 && sizeof($arr) > 0) {
            $str_add = " IN (" . implode(",", $arr) . ")";
        } else {
            $str_add = "> 0";
        }
    } else {
        $id = intval($_REQUEST['id']);
        if (!$id) {
            $str_add = "> 0";
        } else {
            $str_add = "='" . $id . "'";
        }
    }
    
    @$action = $_REQUEST["action"];

    switch ($action) {
        case "sent":
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT id_subscriber FROM " . SENT_USERS_TABLE . " WHERE id_newsletter" . $str_add . " AND status=" . SEND . ") AND id_user={$auth["id"]}";
            break;
        case "error":
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT id_subscriber FROM " . SENT_USERS_TABLE . " WHERE id_newsletter" . $str_add . " AND status=" . ERROR . ") AND id_user={$auth["id"]}";
            break;
        case "undeliv":
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT id_subscriber FROM " . WAITING_SEND_TABLE . " WHERE id_newsletter" . $str_add . " AND id_user={$auth["id"]}) AND id_user={$auth["id"]}";
            break;
        case "unsubscribe":
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id" . $str_add . " AND url='uns' AND link_type='unsubscribe' AND id_user={$auth["id"]}) AND id_user={$auth["id"]}";
            break;
        case "view":
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT DISTINCT(id_subscr) FROM " . CRELEASES_STAT_TABLE . " WHERE id_release" . $str_add . ") AND id_user={$auth["id"]}";
            break;
        case "link":
            $strSQL = "SELECT sn.id, CONCAT(sn.firstname,' ',sn.secondname) as name, sn.email1, cc.url FROM " . CLICK_COUNTER_TABLE . " cc
							LEFT JOIN " . SEND_USERS_TABLE . " sn ON sn.id=cc.client_id AND sn.id_user={$auth["id"]}
							WHERE cc.release_id" . $str_add . " AND cc.link_type='other' AND cc.id_user={$auth["id"]} AND cc.url!='uns'";
            break;
        case "forward":
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id" . $str_add . " AND link_type='forward' AND id_user={$auth["id"]}) AND id_user={$auth["id"]}";
            break;
        default:
            $strSQL = "SELECT id, CONCAT(firstname,' ',secondname) as name, email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT id_subscriber FROM " . SENT_USERS_TABLE . " WHERE id_newsletter" . $str_add . " AND status=" . SEND . ") AND id_user={$auth["id"]}";
            break;
    }
    
    $rs = $dbconn->Execute($strSQL);
    $data = array();
    $i = 0;
    while (!$rs->EOF) {
        $data[$i]["id"] = $rs->fields[0];
        $data[$i]["name"] = stripslashes($rs->fields[1]);
        $data[$i]["email"] = $rs->fields[2];
        if ($action == "link")
            $data[$i]["link"] = htmlentities($rs->fields[3]);
        $i++;
        $rs->MoveNext();
    }
    $smarty->assign("data", $data);
    $smarty->assign("action", $action);
    $smarty->assign("id_newsletter", $id);
    $smarty->display($config["admin_nl_gentemplates"] . "/archive_get_subscriber.tpl");
    exit;
}

function EmailCampaignsList() {
    global $smarty, $dbconn, $lang, $auth, $config;

    AdminMainMenu("archive");

    $strSQL = "SELECT COUNT(*) FROM " . CRELEASES_TABLE . "";
    $res = $dbconn->Execute($strSQL);
    $amount = $res->fields[0];

    if ($amount > 0) {
        $data = array();
        $i = 0;
        $strSQL = "SELECT DISTINCT cr.id, cr.subject, DATE_FORMAT(cr.date,'{$config["date_format"]}') as date,cr.format, cr.priority, cr.is_attach, snt.lists as lists, count(snt.id_newsletter) AS sent_times
		FROM " . CRELEASES_TABLE . " cr
                LEFT JOIN " . CRELEASES_LISTS_TABLE . " clt ON clt.crelease_id=cr.id
                LEFT JOIN " . SEND_NEWSLETTERS_TABLE . " snt ON snt.id_newsletter=cr.id
                WHERE lists <> '' AND snt.id_user='" . $auth['id'] . "'
                GROUP BY cr.id";
        $res = $dbconn->Execute($strSQL);
        if ($res)
            while (!$res->EOF) {
                $data[$i]['id'] = $res->fields[0];
                $data[$i]['subject'] = $res->fields[1];
                $data[$i]['date'] = $res->fields[2];
                $data[$i]['format'] = $res->fields[3];
                $data[$i]['format_str'] = $lang["newsletters"][$res->fields[3]];
                $data[$i]['priority'] = $res->fields[4];
                $data[$i]['is_attach'] = $res->fields[5];

                $lists = isset($res->fields[6]) ? $res->fields[6] : '0';
                $strSQL = "SELECT lt.name FROM " . LISTS_TABLE . " lt WHERE lt.id IN ({$lists}) ";

                $res2 = $dbconn->Execute($strSQL);
                $lists = '';
                if ($res2)
                    while (!$res2->EOF) {
                        $lists .= $lists ? ', ' . $res2->fields[0] : $res2->fields[0];
                        $res2->MoveNext();
                    }

                $data[$i]['mailing_list'] = $lists != '' ? $lists : $lang["archive"]["not_set"];
                $data[$i]['sent_times'] = $res->fields[7];

                $data[$i]['recipients'] = 0;
                $data[$i]['unsubscribe'] = 0;

                if ($data[$i]['sent_times'] > 0) {
                    $strSQL = "SELECT id, SUM(count_all) FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_newsletter='" . $data[$i]['id'] . "' GROUP BY id";
                    $rs = $dbconn->Execute($strSQL);
                    $id_sent = array();
                    while (!$rs->EOF) {
                        $data[$i]['recipients'] += $rs->fields[1];
                        array_push($id_sent, $rs->fields[0]);
                        $rs->MoveNext();
                    }
                    $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . SEND_USERS_TABLE . "
                                                        WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id IN (" . implode(',', $id_sent) . ") AND url='uns' AND link_type='unsubscribe')";

                    $rs = $dbconn->Execute($strSQL);
                    $data[$i]['unsubscribe'] = $rs->fields[0];
                }
                if (!$data[$i]['subject']) {
                    unset($data[$i]);
                }
                $i++;
                $res->MoveNext();
            }

        ArrStripSlashes($data);
    }

    get_smarty_array_list("archive_page", $config["archive_page"]);
    $smarty->assign("data", $data);
    $smarty->assign("amount", $amount);

    $smarty->display($config["admin_nl_gentemplates"] . "/archive_email_campaigns_statistics.tpl");
}

function EmailCampaignView() {
    global $smarty, $dbconn, $lang, $auth, $config, $file_name;

    AdminMainMenu("archive");

    $id_campaign = isset($_REQUEST['id_campaign']) ? intval($_REQUEST['id_campaign']) : 0;

    if ($id_campaign > 0) {

        $strSQL = "SELECT id FROM " . CRELEASES_TABLE . " WHERE id='" . $id_campaign . "'";
        $rs = $dbconn->Execute($strSQL);
        if ($rs->fields[0] == $id_campaign) {
            $data['campaign_id'] = $id_campaign;

            $section = isset($_REQUEST['id_section']) ? $_REQUEST['id_section'] : 'menu_btn_1';

            $data['section_id'] = $section;

            if (isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 1) {

                switch ($section) {
                    case 'menu_btn_1' :
                        GetStatisticsShotData($id_campaign, $data);
                        $tpl_name = 'archive_email_campaign_statistics_shot';
                        break;
                    case 'menu_btn_2' :
                        GetOpenStatsData($id_campaign, $data);
                        $tpl_name = 'archive_email_campaign_open_stat';
                        break;
                    case 'menu_btn_3' :
                        GetUnsubscribedStatsData($id_campaign, $data);
                        $tpl_name = 'archive_email_campaign_unsubscribed_stat';
                        break;
                }
                $smarty->assign('data', $data);
                $smarty->display($config["admin_nl_gentemplates"] . "/" . $tpl_name . ".tpl");
                exit;
            } else {
                //first menu display
                GetStatisticsShotData($id_campaign, $data);
            }
        } else {
            header('Location: ' . $file_name . "?sel=email_campaigns");
        }
    } else {
        header('Location: ' . $file_name . "?sel=email_campaigns");
    }
    $smarty->assign('data', $data);
    $smarty->display($config["admin_nl_gentemplates"] . "/archive_email_campaign_detailed.tpl");
}

function GetOpenStatsData($id_campaign, $data) {
    global $smarty, $dbconn, $lang, $auth, $config;

    $strSQL = "SELECT id, SUM(count_all) FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_newsletter='" . $id_campaign . "' GROUP BY id";
    $rs = $dbconn->Execute($strSQL);
    $id_sent = array();
    while (!$rs->EOF) {
        $data['recipients'] += $rs->fields[1];
        array_push($id_sent, $rs->fields[0]);
        $rs->MoveNext();
    }
    $strSQL = "SELECT COUNT(DISTINCT(id_subscr)) FROM " . CRELEASES_STAT_TABLE . " WHERE id_release IN (" . implode(',', $id_sent) . ")";
    $rs = $dbconn->Execute($strSQL);
    $data['viewed'] = intval($rs->fields[0]);

    if ($data['recipients'] > 0) {
        $data['av_opens'] = round($data['viewed'] / $data['recipients'], 2);
        $data['open_rate'] = $data['av_opens'] * 100;
    } else {
        $data['av_opens'] = 0;
        $data['open_rate'] = 0;
    }

    $strSQL = "SELECT id, UNIX_TIMESTAMP(visit_date) FROM " . CRELEASES_STATS_ALL_TABLE . " WHERE id_release IN (" . implode(',', $id_sent) . ")";
    $rs = $dbconn->Execute($strSQL);
    $arr_to_plot = array();
    $arr_months = array();
    for ($i = 0; $i < 12; $i++) {
        $key = date('n_Y', mktime(1, 1, 1, date('n') - 11 + $i, 1, date('y')));
        $name = date('M', mktime(1, 1, 1, date('n') - 11 + $i, 1, date('y')));

        $arr_to_plot[$key] = 0;
        $arr_months[$key] = "'" . $name . "'";
    }
    if ($rs) {
        while (!$rs->EOF) {
            $month = date('n_Y', $rs->fields[1]);
            if (array_key_exists($month, $arr_to_plot)) {
                $arr_to_plot[$month]++;
            }
            $rs->MoveNext();
        }
    }
    $data['months_str'] = implode(',', $arr_months);
    $data['values_str'] = implode(',', $arr_to_plot);

    array_multisort($arr_to_plot);
    $keys = array_keys($arr_to_plot);
    $most_month = $keys[sizeof($arr_to_plot) - 1];

    $most_arr = explode('_', $most_month);
    $data['most_month'] = $lang["month_arr"][$most_arr[0] - 1];
    $data['most_year'] = $most_arr[1];

    $data['sent_ids'] = implode('_', $id_sent);
}

function GetUnsubscribedStatsData($id_campaign, $data) {
    global $smarty, $dbconn, $lang, $auth, $config;

    $data['unsubscribe'] = 0;

    $strSQL = "SELECT id, SUM(count_all) FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_newsletter='" . $id_campaign . "' GROUP BY id";
    $rs = $dbconn->Execute($strSQL);
    $id_sent = array();
    while (!$rs->EOF) {
        $data['recipients'] += $rs->fields[1];
        array_push($id_sent, $rs->fields[0]);
        $rs->MoveNext();
    }

    $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . SEND_USERS_TABLE . "
    WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id IN (" . implode(',', $id_sent) . ") AND url='uns' AND link_type='unsubscribe')";
    $rs = $dbconn->Execute($strSQL);
    $data['unsubscribe'] = $rs->fields[0];
    if ($data['unsubscribe'] > 0) {
        $data['unsubscribe_rate'] = round(100 * ($data['unsubscribe'] / $data['recipients']), 2);
    }
    $data['sent_ids'] = implode('_', $id_sent);
}

function GetStatisticsShotData($id_campaign, $data) {
    global $smarty, $dbconn, $lang, $auth, $config;
    $strSQL = "SELECT ct.id, ct.subject, DATE_FORMAT(sn.date_send,'{$config["date_format"]}'), ct.id_user, u.fname, u.sname, u.login, u.root_user, sn.lists as lists
    FROM " . CRELEASES_TABLE . " ct
    LEFT JOIN " . SEND_NEWSLETTERS_TABLE . " sn ON sn.id_newsletter=ct.id
    LEFT JOIN " . USERS_TABLE . " u ON u.id=ct.id_user
    WHERE ct.id='" . $id_campaign . "'";
    $rs = $dbconn->Execute($strSQL);
    $data['campaign_name'] = $rs->fields[1];
    $data['start_sending'] = ($rs->fields[2] != NULL) ? $rs->fields[2] : $lang["archive"]["not_sent"];

    $data['id_user'] = $rs->fields[3];
    $data['fname'] = $rs->fields[4];
    $data['sname'] = $rs->fields[5];
    $data['login'] = $rs->fields[6];
    $data['is_admin'] = $rs->fields[7];

    $lists = isset($rs->fields[8]) ? $rs->fields[8] : 0;
    $strSQL = "SELECT lt.name FROM " . LISTS_TABLE . " lt WHERE lt.id IN ({$lists}) ";

    $res2 = $dbconn->Execute($strSQL);
    $lists = '';
    if ($res2)
        while (!$res2->EOF) {
            $lists .= $lists ? ', ' . $res2->fields[0] : $res2->fields[0];
            $res2->MoveNext();
        }

    $mailing_lists = $lists != '' ? $lists : $lang["archive"]["not_set"];

    $strSQL = "SELECT l.name FROM " . CRELEASES_LISTS_TABLE . " AS cl LEFT JOIN " . LISTS_TABLE . " AS l ON l.id=cl.list_id WHERE cl.crelease_id='" . $id_campaign . "'";
    $rs_lists = $dbconn->Execute($strSQL);

    $data['mailing_lists'] = $mailing_lists;

    $data['recipients'] = 0;
    $data['unsubscribe'] = 0;

    $strSQL = "SELECT id, SUM(count_all) FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_newsletter='" . $id_campaign . "' GROUP BY id";
    $rs = $dbconn->Execute($strSQL);
    $id_sent = array();
    while (!$rs->EOF) {
        $data['recipients'] += $rs->fields[1];
        array_push($id_sent, $rs->fields[0]);
        $rs->MoveNext();
    }
    $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . SEND_USERS_TABLE . "
                            WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id IN (" . implode(',', $id_sent) . ") AND url='uns' AND link_type='unsubscribe')";
    $rs = $dbconn->Execute($strSQL);
    $data['unsubscribe'] = $rs->fields[0];

    $strSQL = "SELECT COUNT(DISTINCT(id_subscr)) FROM " . CRELEASES_STAT_TABLE . " WHERE id_release IN (" . implode(',', $id_sent) . ")";
    $rs = $dbconn->Execute($strSQL);
    $data['viewed'] = intval($rs->fields[0]);

    $data['not_viewed'] = $data['recipients'] - $data['viewed'];
}

function EmailCampaignExport() {
    global $smarty, $dbconn, $lang, $auth, $config;

    AdminMainMenu("archive");
    $smarty->display($config["admin_nl_gentemplates"] . "/archive_email_campaign_statistics.tpl");
}

function EmailCampaignPrint() {
    global $smarty, $dbconn, $lang, $auth, $config;

    AdminMainMenu("archive");


    $id_campaign = isset($_REQUEST['id_campaign']) ? intval($_REQUEST['id_campaign']) : 0;

    if ($id_campaign > 0) {

        $strSQL = "SELECT id FROM " . CRELEASES_TABLE . " WHERE id='" . $id_campaign . "'";
        $rs = $dbconn->Execute($strSQL);
        if ($rs->fields[0] == $id_campaign) {
            $data['campaign_id'] = $id_campaign;

            $section = isset($_REQUEST['id_section']) ? $_REQUEST['id_section'] : 'menu_btn_1';

            $data['section_id'] = $section;

            if (isset($_REQUEST['ajax']) && $_REQUEST['ajax'] == 1) {

                switch ($section) {
                    case 'menu_btn_1' :
                        GetStatisticsShotData($id_campaign, $data);
                        $tpl_name = 'archive_email_campaign_statistics_shot';
                        break;
                    case 'menu_btn_2' :
                        GetOpenStatsData($id_campaign, $data);
                        $tpl_name = 'archive_email_campaign_open_stat';
                        break;
                    case 'menu_btn_3' :
                        GetUnsubscribedStatsData($id_campaign, $data);
                        $tpl_name = 'archive_email_campaign_unsubscribed_stat';
                        break;
                }
                $smarty->assign('data', $data);
                $smarty->display($config["admin_nl_gentemplates"] . "/" . $tpl_name . ".tpl");
                exit;
            } else {
                //first menu display
                GetStatisticsShotData($id_campaign, $data);
            }
        } else {
            header('Location: ' . $file_name . "?sel=email_campaigns");
        }
    } else {
        header('Location: ' . $file_name . "?sel=email_campaigns");
    }
    $smarty->assign('data', $data);


    $strSQL = "SELECT id, SUM(count_all) FROM " . SEND_NEWSLETTERS_TABLE . " WHERE id_newsletter='" . $id_campaign . "' GROUP BY id";
    $rs = $dbconn->Execute($strSQL);
    $id_sent = array();
    if ($rs->RowCount() > 0) {
        while (!$rs->EOF) {
            $data['recipients'] += $rs->fields[1];
            array_push($id_sent, $rs->fields[0]);
            $rs->MoveNext();
        }
        $strSQL = "SELECT COUNT(DISTINCT(id_subscr)) FROM " . CRELEASES_STAT_TABLE . " WHERE id_release IN (" . implode(',', $id_sent) . ")";
        $rs = $dbconn->Execute($strSQL);
        $data['viewed'] = intval($rs->fields[0]);

        if ($data['recipients'] > 0) {
            $data['av_opens'] = round($data['viewed'] / $data['recipients'], 2);
            $data['open_rate'] = $data['av_opens'] * 100;
        } else {
            $data['av_opens'] = 0;
            $data['open_rate'] = 0;
        }

        $strSQL = "SELECT id, UNIX_TIMESTAMP(visit_date) FROM " . CRELEASES_STATS_ALL_TABLE . " WHERE id_release IN (" . implode(',', $id_sent) . ")";
        $rs = $dbconn->Execute($strSQL);
        $arr_to_plot = array();
        $arr_months = array();
        for ($i = 0; $i < 12; $i++) {
            $key = date('n_Y', mktime(1, 1, 1, date('n') - 11 + $i, 1, date('y')));
            $name = date('M', mktime(1, 1, 1, date('n') - 11 + $i, 1, date('y')));

            $arr_to_plot[$key] = 0;
            $arr_months[$key] = "'" . $name . "'";
        }
        if ($rs) {
            while (!$rs->EOF) {
                $month = date('n_Y', $rs->fields[1]);
                if (array_key_exists($month, $arr_to_plot)) {
                    $arr_to_plot[$month]++;
                }
                $rs->MoveNext();
            }
        }
        $data['months_str'] = implode(',', $arr_months);
        $data['values_str'] = implode(',', $arr_to_plot);

        array_multisort($arr_to_plot);
        $keys = array_keys($arr_to_plot);
        $most_month = $keys[sizeof($arr_to_plot) - 1];

        $most_arr = explode('_', $most_month);
        $data['most_month'] = $lang["month_arr"][$most_arr[0] - 1];
        $data['most_year'] = $most_arr[1];

        $data['sent_ids'] = implode('_', $id_sent);


        if (strval(intval($data['sent_ids'])) != $data['sent_ids']) {
            $arr = explode("_", $data['sent_ids']);
            if (sizeof($arr) > 0) {
                $str_add = " IN (" . implode(",", $arr) . ")";
            }
        } else {
            $id = intval($data['sent_ids']);
            $str_add = "='" . $id . "'";
        }

        $strSQL = "SELECT * FROM " . SENT_USERS_TABLE . " WHERE id_newsletter" . $str_add . " AND status=" . SEND;
        $rs = $dbconn->Execute($strSQL);
        $sent_users = array();
        $ids = array();
        $id_in = '';
        $newsletters = array();
        $newsletters_date = array();
        while (!$rs->EOF) {
            $sent_users[] = $rs->fields;
            if (!in_array($rs->fields[1], $ids))
                $ids[] = $rs->fields[1];
            if (!in_array($rs->fields[2], $newsletters))
                $newsletters[] = $rs->fields[2];
            $rs->MoveNext();
        }
        $strSQL = "SELECT id, date_send FROM " . SEND_NEWSLETTERS_TABLE . "
							WHERE id IN (" . implode(',', $newsletters) . ")";

        $rs = $dbconn->Execute($strSQL);

        while (!$rs->EOF) {
            $newsletters_date[$rs->fields[0]] = $rs->fields[1];
            $rs->MoveNext();
        }

        $strSQL = "SELECT id,date,firstname,secondname,company,email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (" . implode(',', $ids) . ") AND id_user={$auth["id"]}";

        $rs = $dbconn->Execute($strSQL);
        $users = array();
        $data3 = array(
            0 => array(
                'id',
                'date',
                'firstname',
                'secondname',
                'company',
                'email1',
            ),
        );
        while (!$rs->EOF) {
            $users[$rs->fields[0]] = $rs->fields;
            $rs->MoveNext();
        }

        foreach ($sent_users as $id => $value) {
            $data3[$value[0]] = $users[$value[1]];
            $data3[$value[0]][1] = $newsletters_date[$value[2]];
        }

        $smarty->assign("data3", $data3);
    }

    $smarty->display($config["admin_nl_gentemplates"] . "/archive_email_campaign_statistics_print.tpl");
}

function ResponderStatOne($action = null) {
    global $smarty, $dbconn, $lang, $auth, $config;

    $id = isset($_REQUEST['id']) ? intval($_REQUEST['id']) : 0;

    $data = array();
    $data2 = array();
    $strSQL = "SELECT sn.*, DATE_FORMAT(sn.date_send,'{$config["date_format"]} {$config["time_format"]}') as date_send, at.name, at.subject
					FROM " . SEND_NEWSLETTERS_TABLE . " sn
                                        LEFT JOIN " . AUTORESPONDER_TABLE . " at ON at.id=sn.id_newsletter
					WHERE sn.id='" . $id . "' AND sn.id_user={$auth["id"]} AND sn.is_responder=1 ";
    $res = $dbconn->Execute($strSQL);
    $row = $res->GetRowAssoc(false);
    $data["id"] = $row["id"];
    $data["id_newsletter"] = $row["id_newsletter"];
    $data["date"] = $row["date_send"];
    $data["subject"] = stripslashes($row["subject"]);
    $data["name"] = stripslashes($row["name"]);
    $data["count_all"] = $row["count_all"];
    $data["count_sent"] = $row["count_sent"];
    $data["count_error"] = $row["count_error"];
    $data["status"] = $row["status"];
    $data["status_str"] = $lang["archive"]["status"][$data["status"]];

    $strSQL = "SELECT id_subscriber FROM " . WAITING_SEND_TABLE . " WHERE id_newsletter={$data["id"]} AND id_user={$auth["id"]}";
    $rs1 = $dbconn->Execute($strSQL);
    if ($rs1->RowCount() > 0) {
        $wer = array();
        while (!$rs1->EOF) {
            $wer[] = $rs1->fields[0];
            $rs1->MoveNext();
        }
        $wer_str = implode(",", $wer);
        $strSQL = "SELECT id,date,firstname,secondname,company,email1 FROM " . SENT_USERS_TABLE . " WHERE id IN ({$wer_str}) AND id_user={$auth["id"]}";
        $rs = $dbconn->Execute($strSQL);

        $failed = array();
        $failed[] = array(
            'id',
            'date',
            'firstname',
            'secondname',
            'company',
            'email1',
        );
        while (!$rs->EOF) {
            $failed[] = $rs->fields;
            $rs->MoveNext();
        }
        $data2['failed_stat'] = $failed;
        /*
          if ($rs && $rs->RowCount() > 0) {
          $data['undelivered'] = $rs->fields[0] ? $rs->RowCount() : 0;
          } else {
          $data['undelivered'] = 0;
          } */
        $data['undelivered'] = count($data['send_users']);
    } else {
        $data['undelivered'] = 0;
    }

    $strSQL = "SELECT COUNT(id) FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data["id"]} AND link_type='other' AND url !='uns'";
    $rs = $dbconn->Execute($strSQL);
    $data['link'] = $rs->fields[0];

    $strSQL = "SELECT * FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data["id"]} AND link_type='other' AND url !='uns'";
    $rs = $dbconn->Execute($strSQL);
    $clicks = array();
    $clicks[] = array(
        'id',
        'client_id',
        'release_id',
        'list_id',
        'url',
        'time',
        'link_type',
        'id_user',
    );
    while (!$rs->EOF) {
        $clicks[] = $rs->fields;
        $rs->MoveNext();
    }
    $data2['clicks_stat'] = $clicks;

    $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data["id"]} AND url='uns' AND link_type='unsubscribe' AND id_user={$auth["id"]}) AND id_user={$auth["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $data['unsubscribe'] = $rs->fields[0];

    $strSQL = "SELECT id,date,firstname,secondname,company,email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (SELECT client_id FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data["id"]} AND url='uns' AND link_type='unsubscribe' AND id_user={$auth["id"]}) AND id_user={$auth["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $unsubscribed = array();
    $unsubscribed[] = array(
        'id',
        'date',
        'firstname',
        'secondname',
        'company',
        'email1',
    );
    while (!$rs->EOF) {
        $unsubscribed[] = $rs->fields;
        $rs->MoveNext();
    }
    $data2['unsubscribed_stat'] = $unsubscribed;

    $strSQL = "SELECT COUNT(DISTINCT(id)) FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data["id"]} AND link_type='forward'";
    $rs = $dbconn->Execute($strSQL);
    $data['forward'] = $rs->fields[0];

    $strSQL = "SELECT * FROM " . CLICK_COUNTER_TABLE . " WHERE release_id={$data["id"]} AND link_type='forward'";
    $rs = $dbconn->Execute($strSQL);
    $forward = array();
    $forward[] = array(
        'id',
        'client_id',
        'release_id',
        'list_id',
        'url',
        'time',
        'link_type',
        'id_user',
    );
    while (!$rs->EOF) {
        $forward[] = $rs->fields;
        $rs->MoveNext();
    }
    $data2['forward_stat'] = $forward;

    $strSQL = "SELECT COUNT(DISTINCT(id_subscr)) FROM " . CRELEASES_STAT_TABLE . " WHERE id_release={$data["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $data['viewed'] = $rs->fields[0];

    $strSQL = "SELECT * FROM " . CRELEASES_STAT_TABLE . " WHERE id_release={$data["id"]}";
    $rs = $dbconn->Execute($strSQL);
    $viewed = array();
    $viewed[] = array(
        'id',
        'id_release',
        'id_subscr',
        'id_user',
        'viewed_count',
    );
    while (!$rs->EOF) {
        $viewed[] = $rs->fields;
        $rs->MoveNext();
    }
    $data2['viewed_stat'] = $viewed;

    $smarty->assign('data', $data);
    $smarty->assign('data2', $data2);
    AdminMainMenu("archive");


    $strSQL = "SELECT * FROM " . SENT_USERS_TABLE . " WHERE id_newsletter = " . $id . " AND status=" . SEND;
    $rs = $dbconn->Execute($strSQL);
    $sent_users = array();
    $ids = array();
    $id_in = '';
    $newsletters = array();
    $newsletters_date = array();
    while (!$rs->EOF) {
        $sent_users[] = $rs->fields;
        if (!in_array($rs->fields[1], $ids))
            $ids[] = $rs->fields[1];
        if (!in_array($rs->fields[2], $newsletters))
            $newsletters[] = $rs->fields[2];
        $rs->MoveNext();
    }
    $strSQL = "SELECT id, date_send FROM " . SEND_NEWSLETTERS_TABLE . "
							WHERE id IN (" . implode(',', $newsletters) . ")";

    $rs = $dbconn->Execute($strSQL);

    while (!$rs->EOF) {
        $newsletters_date[$rs->fields[0]] = $rs->fields[1];
        $rs->MoveNext();
    }

    $strSQL = "SELECT id,date,firstname,secondname,company,email1 FROM " . SEND_USERS_TABLE . "
							WHERE id IN (" . implode(',', $ids) . ") AND id_user={$auth["id"]}";

    $rs = $dbconn->Execute($strSQL);
    $users = array();
    $data3 = array(
        0 => array(
            'id',
            'date',
            'firstname',
            'secondname',
            'company',
            'email1',
        ),
    );
    while (!$rs->EOF) {
        $users[$rs->fields[0]] = $rs->fields;
        $rs->MoveNext();
    }

    foreach ($sent_users as $id => $value) {
        $data3[$value[0]] = $users[$value[1]];
        $data3[$value[0]][1] = $newsletters_date[$value[2]];
    }

    $smarty->assign("data3", $data3);

    switch ($action) {
        case 'export':
            break;
        case 'print':
            $smarty->display($config["admin_nl_gentemplates"] . "/archive_responder_statistics_print.tpl");
            break;
        default:
            $smarty->display($config["admin_nl_gentemplates"] . "/archive_responder_statistics.tpl");
    }
}

function SetObjectPlot($type="bounce", $value=7) {
    global $smarty, $dbconn, $lang, $auth, $config;

    AdminMainMenu("archive");

    $type = ($_REQUEST["type"]) ? $_REQUEST["type"] : $type;
    $value = ($_REQUEST["value"]) ? intval($_REQUEST["value"]) : $value;
    $period = ($_REQUEST["period"]) ? intval($_REQUEST["period"]) : $value;

    $data = array();
    $i = 0;
    switch ($type) {
        case "bounce":
            $date = ($value != 1) ? "(UNIX_TIMESTAMP(NOW()-INTERVAL {$value} day) <= UNIX_TIMESTAMP(date)) AND " : "";
            $strSQL = "SELECT DATE_FORMAT(date,'%d.%m.%Y'), COUNT(id)
								FROM " . BOUNCE_EMAIL_TABLE . "
								WHERE {$date} id_user={$auth["id"]} AND view=1 GROUP BY date";
            $rs = $dbconn->Execute($strSQL);
            while (!$rs->EOF) {
                $data["x"][$i] = $rs->fields[0];
                $data["y"][$i] = $rs->fields[1];
                $i++;
                $rs->MoveNext();
            }
            break;
        case "list":
            switch ($period) {
                case "1": $period1 = "";
                    $period2 = "";
                    break;
                case "7":
                case "30": $period1 = " AND date_status >= DATE_FORMAT((NOW() - INTERVAL {$period} DAY),'%Y-%m-%d') AND date_status <= DATE_FORMAT(NOW(),'%Y-%m-%d') ";
                    $period2 = " AND time >= DATE_FORMAT((NOW() - INTERVAL {$period} DAY),'%Y-%m-%d') AND time <= DATE_FORMAT(NOW(),'%Y-%m-%d') ";
                    break;
                default: $period1 = "";
                    $period2 = "";
                    $period = 1;
            }

            $strSQL = "SELECT COUNT(DISTINCT client_id),DATE_FORMAT(date_status,'%Y-%m-%d') FROM " . CLIENTS_LISTS_TABLE . " WHERE id_user={$auth["id"]} {$period1} AND status_subscribe=" . SUBSCRIBE . " AND list_id={$value} GROUP BY date_status";
            $rs = $dbconn->Execute($strSQL);
            $data["line"][1] = array();
            $i = 0;
            while (!$rs->EOF) {
                $data["line"][1]["x"][$i] = $rs->fields[1];
                $data["line"][1]["y"][$i] = $rs->fields[0];
                $i++;
                $rs->MoveNext();
            }

            $strSQL = "SELECT COUNT(DISTINCT client_id),DATE_FORMAT(time,'%Y-%m-%d') FROM " . CLICK_COUNTER_TABLE . " WHERE url='uns' {$period2} AND link_type='unsubscribe' AND id_user={$auth["id"]} AND list_id={$value} GROUP BY time";
            $rs = $dbconn->Execute($strSQL);
            $data["line"][2] = array();
            $i = 0;
            while (!$rs->EOF) {
                $data["line"][2]["x"][$i] = $rs->fields[1];
                $data["line"][2]["y"][$i] = $rs->fields[0];
                $i++;
                $rs->MoveNext();
            }

            $strSQL = "SELECT COUNT(DISTINCT client_id),DATE_FORMAT(date_status,'%Y-%m-%d') FROM " . CLIENTS_LISTS_TABLE . " WHERE id_user={$auth["id"]} {$period1} AND status_subscribe=" . UNCONF_SUB . " AND list_id={$value} GROUP BY date_status";
            $rs = $dbconn->Execute($strSQL);
            $data["line"][3] = array();
            $i = 0;
            while (!$rs->EOF) {
                $data["line"][1]["x"][$i] = $rs->fields[1];
                $data["line"][1]["y"][$i] = $rs->fields[0];
                $i++;
                $rs->MoveNext();
            }

            break;
        default:
            $date = ($value != 0) ? "(UNIX_TIMESTAMP(NOW()-INTERVAL {$value} day) <= UNIX_TIMESTAMP(date)) AND " : "";
            $strSQL = "SELECT DATE_FORMAT(date,'%Y-%m-%d'), COUNT(id)
								FROM " . BOUNCE_EMAIL_TABLE . "
								WHERE {$date} id_user={$auth["id"]} AND view=1 GROUP BY date";
            $rs = $dbconn->Execute($strSQL);
            while (!$rs->EOF) {
                $data["x"][$i] = $rs->fields[0];
                $data["y"][$i] = $rs->fields[1];
                $i++;
                $rs->MoveNext();
            }
            break;
    }

    $line1 = array();
    foreach ($data["line"] as $key => $value) {
        $line1[$key] = array();
        foreach ($value["y"] as $key1 => $value1) {
            $line1[$key][] = "['{$value["x"][$key1]}',{$value1}]";
        }
        //break;
    }
    foreach ($line1 as $key => $value) {
        if (count($value) == 0)
            continue;
        if (count($value) == 1) {
            $data1["line{$key}"] = $value[0];
            continue;
        }
        $data1["line{$key}"] = "[" . implode(",", $value) . "]";
    }


    /* $obj = "{
      title: \"{$lang["archive"]["bounce_graf_title"]}\",
      series: [{ color:'#4bb2c5',label:'123' }],
      legend: { show: true,location: 'ne',xoffset: 12,yoffset: 12 }
      }"; */

    if ($config["phpversion"] == 4) {
        include "./include/class.json.php";
        $json = new Services_JSON();
    }
    //$data1["line"] = $line;
    //header("Content-type:  charset=utf-8");
    if ($config["phpversion"] == 4) {
        echo $json->encode($data1);
    } else {
        echo json_encode($data1);
    }
}

