<?php

include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";


login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$this_page = "templates";
$smarty->assign("this_page", $this_page);

if ($mode == 1) {
    @$sel = $_POST["sel"] ? $_POST["sel"] : $_GET["sel"];
    @$id = isset($_POST["id"]) ? intval($_POST["id"]) : intval($_GET["id"]);
    $file_name = $config["server"] . "/templates.php";
    $smarty->assign("form_action", $file_name);
    switch ($sel) {
        case "delete" : if (IsFunctionAllowed($auth["id"], 10)) {
                DeleteTemplate();
            } else {
                ListTemplate();
            } break;
        case "view" : ViewTemplate();
            break;
        case "change" : Save($id);
            break;
        case "edit" : if (IsFunctionAllowed($auth["id"], 9)) {
                Edit($id);
            } else {
                ListTemplate();
            } break;
        case "upload_file_ajax" : ImportFromFile();
            break;
        case "import_from_site_ajax": ImportFromSite();
            break;
        case "set_global_ajax" : SetGlobal();
            break;
        case "get_upload_form" : GetUploadForm();
            break;
        case "get_custom_fields" : GetCustomFields();
            break;
        default: ListTemplate();
    }
}

function ListTemplate() {
    global $config, $smarty, $dbconn, $auth, $file_name;

    AdminMainMenu("templates");

    if (IsFunctionAllowed($auth["id"], 10)) {
        $smarty->assign("delete_template", 1);
    }
    if (IsFunctionAllowed($auth["id"], 9)) {
        $smarty->assign("create_template", 1);
    }

    $strSQL = "SELECT COUNT(id) FROM " . TEMPLATES_TABLE . " WHERE id_user={$auth["id"]}";
    $res = $dbconn->Execute($strSQL);
    $amount = $res->fields[0];

    $strSQL = "SELECT id,name,date,format,id_user,type FROM " . TEMPLATES_TABLE . " WHERE id_user={$auth["id"]} ORDER BY date";
    $res = $dbconn->Execute($strSQL);

    $data = array();
    $i = 0;
    while (!$res->EOF) {
        $data[$i]['id'] = $res->fields[0];
        $data[$i]['name'] = $res->fields[1];
        $data[$i]['date'] = $res->fields[2];
        $data[$i]['format'] = $res->fields[3];
        $data[$i]['is_delete'] = ($res->fields[4] == $auth["id"]) ? 1 : 0;
        $data[$i]['global'] = ($res->fields[5] == "d") ? "global" : "";
        $i++;
        $res->MoveNext();
    }
    ArrStripSlashes($data);

    get_smarty_array_list("template_page", $config["template_page"]);
    $smarty->assign("amount", $amount);
    $smarty->assign("form_action", $file_name);
    $smarty->assign("data", $data);

    $smarty->display($config["admin_nl_gentemplates"] . "/templates.tpl");
}

function Edit($id, $body='') {
    global $dbconn, $smarty, $config, $file_name, $auth;

    AdminMainMenu("templates");

    if ($id == 0) {
        $data["is_save"] = 1;
        $data["format"] = 'htmltext';
        if ($body) {
            $data["body_html"] = $body;
        } else {
            $data["body_html"] = "";
        }
    } else {
        $data = array();
        $strSQL = "SELECT name,body,body_text,format,id_user FROM " . TEMPLATES_TABLE . " WHERE id={$id}";
        $res = $dbconn->Execute($strSQL);
        $data["id"] = $id;
        $data["subject"] = $res->fields[0];
        $data["body_html"] = $res->fields[1];
        $data["body_text"] = $res->fields[2];
        $data["format"] = $res->fields[3];
        $data["is_save"] = ($res->fields[4] == $auth["id"]) ? 1 : 0;

        ArrStripSlashes($body);
    }


    //Initialize FCKEditor
    include_once "./fckeditor/fckeditor.php";

    $editor = new FCKeditor('body_html');
    $editor->Value = stripslashes(token2brr($data["body_html"]));
    $editor->Width = '100%';
    $editor->Height = '500';
    $editor->BasePath = $config["server"] . '/fckeditor/';
    $editor->Config['AutoDetectLanguage'] = false;
    $fck_lang = file_exists($config["site_path"] . '/fckeditor/editor/lang/' . $config["lang_code"] . ".js") ? $config["lang_code"] : "en";
    $editor->Config['DefaultLanguage'] = $fck_lang;
    $smarty->assign("body_html", $editor->CreateHtml());
    //Initialize FCKEditor

    $smarty->assign("form_action", $file_name);
    $smarty->assign("data", $data);

    $settings = GetUserSettings(array('is_tips'));
    $smarty->assign("is_tips", $settings['is_tips']);

    $smarty->display($config["admin_nl_gentemplates"] . "/templates_change.tpl");
    exit;
}

function Save($id) {
    global $dbconn, $auth, $file_name;

    AdminMainMenu("templates");

    ArrAddSlashes($_POST);

    if ($_POST["id"] == "" || !isset($_POST["id"])) {
        $strSQL = "INSERT INTO " . TEMPLATES_TABLE . " (name,body,body_text,date,format,id_user)
					VALUES ('{$_POST["name"]}','{$_POST["body_html"]}','{$_POST["body_text"]}',NOW(),'{$_POST["format"]}',{$auth["id"]})";
    } else {
        $_POST["id"] = intval($_POST["id"]);
        $strSQL = "UPDATE " . TEMPLATES_TABLE . " SET name='{$_POST["name"]}', body='{$_POST["body_html"]}',
						body_text='{$_POST["body_text"]}',format='{$_POST["format"]}'
					WHERE id_user={$auth["id"]} AND id={$_POST["id"]}";
    }
    $dbconn->Execute($strSQL);

    //ListTemplate();
    header("Location: {$file_name}");
    exit;
}

function ViewTemplate() {
    global $config, $smarty, $file_name, $lang;
    AdminMainMenu("templates");

    $format = ($_GET["format"] == "html" || $_GET["format"] == "") ? "body" : "body_text";
    $format = ($_GET["format"] == "htmltext") ? "body" : $format;
    $data = getContent(intval($_GET['id']), $format);

    $smarty->assign("data", $data);
    $smarty->assign("selected", $_GET["format"]);
    $smarty->assign("form_action", $file_name . "?sel=view&id={$_GET['id']}");
    $smarty->assign("html", $lang["common"]["html"]);
    $smarty->assign("text", $lang["common"]["text"]);
    $smarty->display($config["admin_nl_gentemplates"] . "/templates_view.tpl");
    exit;
}

function DeleteTemplate() {
    if (isset($_POST["del"])) {
        foreach ($_POST["del"] as $val) {
            delReleaseT(intval($val));
        }
    } elseif (isset($_GET['did']) && !empty($_GET['did'])) {
        delReleaseT(intval($_GET['did']));
    }
    ListTemplate();
    exit;
}

function SetGlobal() {
    global $lang, $config, $dbconn, $auth;

    if ($config["phpversion"] == 4 && strpos($sel, "ajax") !== false) {
        include "./include/class.json.php";
        $json = new Services_JSON();
    }
    $status = "d";
    $data = array();

    if ($_GET["par"] == "cros") {
        $status = "d";
        $data["class"] = "global";
    } else {
        $status = "n";
        $data["class"] = "";
    }
    $id = intval($_GET["id"]);
    $data["id"] = $id;
    $strSQL = "UPDATE " . TEMPLATES_TABLE . " SET type='{$status}' WHERE id={$id} AND id_user={$auth["id"]}";
    $dbconn->Execute($strSQL);

    //change customers templates
    if ($auth['root'] == 1) {
        $strSQL = "SELECT name, body, body_text, format FROM " . TEMPLATES_TABLE . " WHERE id='" . $id . "'";
        $rs = $dbconn->Execute($strSQL);
        $template_name = $rs->fields[0];
        $template_body = $rs->fields[1];
        $template_body_text = $rs->fields[2];
        $template_format = $rs->fields[3];

        if ($_GET["par"] == "cros") {
            $strSQL = "SELECT id FROM " . USERS_TABLE . " WHERE root_user<>'1' AND guest_user<>'1' ";
            $rs = $dbconn->Execute($strSQL);

            $strSQL = "INSERT INTO " . TEMPLATES_TABLE . " (name, body, body_text, format, id_user, type, date) VALUES ";
            while (!$rs->EOF) {
                $strSQL .= "('" . $template_name . "', '" . $template_body . "', '" . $template_body_text . "', '" . $template_format . "', '" . $rs->fields[0] . "', 'n', now()),";
                $rs->MoveNext();
            }
            $strSQL = substr($strSQL, 0, strlen($strSQL) - 1);
        } else {
            $strSQL = "DELETE FROM " . TEMPLATES_TABLE . " WHERE name='" . $template_name . "' AND id<>'" . $id . "'";
        }
        $dbconn->Execute($strSQL);
    }
    //header("Content-type:  charset=utf-8");
    if ($config["phpversion"] == 4) {
        echo $json->encode($data);
    } else {
        echo json_encode($data);
    }
    exit;
}

function GetUploadForm() {
    global $config, $smarty;
    AdminMainMenu("templates");
    $_REQUEST["type"] = strip_tags($_REQUEST["type"]);
    $smarty->assign("type", $_REQUEST["type"]);
    $smarty->display($config["admin_nl_gentemplates"] . "/templates_import.tpl");
}

function GetCustomFields() {
    global $config, $smarty, $dbconn;
    $_REQUEST["type"] = strip_tags($_REQUEST["type"]);
    AdminMainMenu("templates");
    include "./include/class.form.php";
    $form_class = new Form($dbconn, $config);
    $fields = array();
    $total = 0;
    $fields = $form_class->getAllAttributes($total);
    $smarty->assign('data', $fields);
    $smarty->assign("type", $_REQUEST["type"]);
    $smarty->display($config["admin_nl_gentemplates"] . "/templates_custom.tpl");
}

function ImportFromFile() {
    global $lang, $config, $config_index, $smarty, $dbconn, $auth;
    $_REQUEST["type"] = strip_tags($_REQUEST["type"]);
    if (is_uploaded_file($_FILES['newsletterfile']['tmp_name'])) {
        $content = file_get_contents($_FILES["newsletterfile"]["tmp_name"]);
        $content1 = ScrubPage($content);
        if ($_REQUEST["type"] == "text")
            $content1 = strip_tags($content1);
        header('Content-type: text/html;');
        echo "<script>
					parent.ajaxData = '" . addcslashes($content1, "'\\\n\r") . "';
					parent.DoImport('file', '{$_REQUEST["type"]}');
				</script>";
    }

    GetUploadForm();
    exit;
}

function ImportFromSite() {
    global $lang, $config, $auth;

    $url = addslashes($_REQUEST["url"]);
    $url = str_ireplace('http://', "", $url);
    $url = str_ireplace('www.', "", $url);
    $url = 'http://www.' . $url;
    $data["into"] = $_GET["into"];
    $page = GetPageContents($url);
    if ($data["into"] == "html") {
        if ($page) {
            $page = str_replace("’", "'", $page);
            $page = str_replace('"', "'", $page);
            $page = str_replace("“", "'", $page);
            $page = str_replace("”", "'", $page);

            if (preg_match('%base href=%is', $page)) {
                echo $page;
                break;
            }
            $page = ScrubPage($page);

            $urlparts = parse_url($url);
            $baseurl = $urlparts['scheme'] . '://';
            $baseurl .= $urlparts['host'];

            if (isset($urlparts['path'])) {
                $path_parts = pathinfo($urlparts['path']);
                $baseurl .= $path_parts['dirname'];

                if (!isset($path_parts['extension'])) {
                    $baseurl .= $path_parts['basename'];
                }
            }

            $baseurl = preg_replace('/(%5c|\\\\)$/i', '', $baseurl);
            if (substr($baseurl, -1) != '/') {
                $baseurl .= '/';
            }

            // Convert it into an absolute resource link
            $pattern = '~(?<=src=["\']|href=["\']|link=["\']|background=["\']|url\()(?![a-z0-9]*?\://|\%\%|mailto\:|#|javascript\:|news\:)(.*?)(?=["\'])~i';
            $page = preg_replace($pattern, "{$baseurl}\$1", $page);
            if (isset($path_parts['dirname'])) {
                $path = $path_parts['dirname'];
                if (strlen($path) > 1) {
                    $page = str_replace($path . '/' . $path, $path, $page);
                }
            }
            $page = str_replace(array('/./', '//'), '/', $page);
            $data["content"] = str_replace(array('http:/', 'https:/'), array('http://', 'https://'), $page);
        } else {
            $data["content"] = "";
            $data["error"] = $lang["err"]["no_import"];
        }
    } else {
        $data["content"] = strip_tags($page);
    }
    header("Content-type:  text/html;");
    echo$data["content"] = $data["content"];
    exit;
}

function GetPageContents($url='') {
    if (!$url || $url == "") {
        return 0;
    }

    $url = str_replace(' ', '%20', $url);

    if (CURL_EXIST) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FAILONERROR, true);
        if (!SENDSTUDIO_SAFE_MODE && ini_get('open_basedir') == '') {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        }
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);

        // Set up headers to "masquarade" as Firefox
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.12) Gecko/20080201 Firefox/2.0.0.12",
            "Accept: text/xml,application/xml,application/xhtml+xml, text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5",
            "Cache-Control: max-age=0",
            "Connection: keep-alive",
            "Keep-Alive: 300",
            "Accept-Charset: ISO-8859-1,utf-8,windows-1251;q=0.7,*;q=0.7",
            "Accept-Language: en-us,en;q=0.5"
        ));

        $pageData = curl_exec($ch);

        if (!$pageData) {
            $error = curl_error($ch);
        }
        curl_close($ch);

        if (!$pageData) {
            return 0;
        }

        return $pageData;
    } else {
        if (!@$fp = fopen($url, "rb")) {
            return 0;
        }
        // Grab the files content
        $pageData = "";
        while (!feof($fp)) {
            $pageData .= fgets($fp, 4096);
        }
        fclose($fp);
        return $pageData;
        /* include_once("./include/Snoopy.class.php");
          $snoopy = new Snoopy;
          $snoopy->fetch($url);
          $snoopy->response_code;
          $pageData = $snoopy->results;
          if (!$pageData) {
          return 0;
          }
          return $pageData; */
    }
}

function ScrubPage($page) {
    return preg_replace('%<script[^>]*>.*?</script>%is', '', $page);
}

function getContent($id, $format="body") {
    global $dbconn, $auth;

    if ($_GET["format"] == "") {
        echo$strSQL = "SELECT format,body,body_text  FROM " . TEMPLATES_TABLE . " WHERE id={$id}";
        $res = $dbconn->Execute($strSQL);
        $data = array();
        $data["format"] = $res->fields[0];
        if ($res->fields[0] == "text") {
            $data["content"] = $res->fields[2];
        } else {
            $data["content"] = $res->fields[1];
        }
    } else {
        $strSQL = "SELECT {$format}, format FROM " . TEMPLATES_TABLE . " WHERE id={$id}";
        $res = $dbconn->Execute($strSQL);
        $data["content"] = $res->fields[0];
        $data["format"] = $res->fields[1];
    }
    ArrStripSlashes($data);
    return $data;
}

function delReleaseT($id) {
    global $dbconn, $auth;
    $dbconn->Execute("DELETE FROM " . TEMPLATES_TABLE . " WHERE id={$id} AND id_user={$auth["id"]}");
}

function token2brr($text) {
    $text = preg_replace("/\n/i", "", $text);
    $text = preg_replace("/\r/i", "", $text);
    return $text;
}

