<?php

include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));

if($mode == 1){
	AdminMainMenu("alert");
	$file_name = $config["server"]."/alerts.php";
	$smarty->assign("file_name",$file_name);
	@$current_lang_id = $_REQUEST["lang_id"] ? $_REQUEST["lang_id"] : $config["default_lang"];
	@$sel = $_REQUEST["sel"];
	switch ($sel){
		case "change_status"	:	ChangeStatus();break;
		case "edit"				:	EditAlerts();break;
		case "save"				:	SaveAlerts();break;
		default: ListAlerts(); break;
	}
}

function ListAlerts(){
	global $config, $dbconn, $lang, $smarty;

	$mails = array();
	$strSQL = "SELECT name, unsubscribe_possible FROM ".SYSTEM_LETTERS_TABLE." WHERE 1";
	$rs = $dbconn->Execute($strSQL);
	while (!$rs->EOF) {
		$mail = $rs->GetRowAssoc(false);
		$mail["descr"] = $lang["alert"][$mail["name"]];
		$mail["unsubscribe_possible"] = ($mail["unsubscribe_possible"]=='1') ? "global" : "";
		$mails[] = $mail;
		$rs->MoveNext();
	}
	
	$smarty->assign("mails", $mails);
	$smarty->display($config["admin_nl_gentemplates"]."/alerts.tpl");
}

function EditAlerts(){
	global $config, $dbconn, $lang, $smarty, $current_lang_id;
	
	ArrAddSlashes($_GET);
	
	///// settings
	$settings_manager = new SettingsManager();
	$active_lang = $settings_manager->GetActiveLanguages();
	$lang_file = $settings_manager->LangFileById($current_lang_id);
	
	//Lang load
	include $config["path_lang"]."mail/".basename($lang_file, ".lang")."/".$_GET["name"].".lang";
	
	$smarty->assign("mail_content", $mail_content);
	$smarty->assign("edit", 1);
	$smarty->assign("active_lang", $active_lang);
	$smarty->assign("alert_name", $_GET["name"]);
	$smarty->assign("current_lang_id", $current_lang_id);
	$smarty->display($config["admin_nl_gentemplates"]."/alerts.tpl");
}

function SaveAlerts(){
	global $config, $dbconn, $lang, $auth, $smarty, $current_lang_id;
	
	///// settings
	$settings_manager = new SettingsManager();
	$lang_file = $settings_manager->LangFileById($current_lang_id);
	
	//Lang load
	$mail_content = $config["path_lang"]."mail/".basename($lang_file, ".lang")."/".$_POST["name"].".lang";

	$lang_text="<?php\n";
	$lang_text .= '$mail_content["subject"] = "'.Rep_Slashes($_POST["mail_subject"]).'";'."\n";
	$lang_text .= '$mail_content["content"] = "'.Rep_Slashes($_POST["mail_content"]).'";'."\n";
	$lang_text.="?>";
	$fp = fopen ($mail_content, "w");
	fputs($fp,$lang_text);
	fclose($fp);
	
	ListAlerts();
}

function Rep_Slashes($str){
	$str = addslashes(strip_tags($str));
	$str = str_replace("\"", "&quot;", $str);
	$str = str_replace("'", "&#039;", $str);
	return  $str;
}

function ChangeStatus(){
	global $dbconn,$config;

	ArrAddSlashes($_GET);
	
	$strSQL = "UPDATE ".SYSTEM_LETTERS_TABLE." SET unsubscribe_possible=IF (unsubscribe_possible,0,1) WHERE name='{$_GET["name"]}'";
	$dbconn->Execute($strSQL);
	
	$data = array();
	$data["name"] = $_GET["name"];
	$data["classname"] = ($_GET["classname"]=='global') ? "" : "global";
	
	if($config["phpversion"]==4){
		include "include/class.json.php";
		$json = new Services_JSON();
		echo $json->encode($data);
	}else{
		echo json_encode($data);
	}
	exit;
}

?>