<?php
/**
*
*
*
*   @author Yan Abdullaev<yan@pilotgroup.net>, Pilot Group <http://www.pilotgroup.net/>
*   @date   12.04.2007
*
*
**/
//CONST FIELDS KEYS
define('FIELD_COMPANY', 1);
define('FIELD_MAILLIST', 3);
define('ERR_INVALID_ATTR_ID', 'Invalid attribute id');

//REFERENCE KEYS
define('VALUES_KEY', 1);


class Form{
	var $dbconn;
	var $config;
	var $ds;
	var $lang;
	/**
	 * Class Constructor
	 *
	 * @param object $dbconn - ADODB connection
	 * @param array $config - config array
	 * @return class object
	 */
	function Form($dbconn, $config){
		global $lang;
		$this->dbconn=$dbconn;
		$this->config=$config;
		$this->lang=&$lang;

		//Mailing lists
		$this->ds[0]['name']=$this->lang['common']['ds_mail_lists'];
		$this->ds[0]['table']='list';
		$this->ds[0]['col_id']='id';
		$this->ds[0]['col_name']='name';
	}
	
	function getAllDataSources(){
		return $this->ds;
	}
	
	function getDataSourceValues($ds_id){
		global $auth;
		if($auth["id"]){
			$datasource=$this->ds[$ds_id];
			$strSQL="SELECT ".$datasource['col_id'].", ".$datasource['col_name']." FROM {$this->config["table_prefix"]}".$datasource['table']." WHERE id_user=".$auth["id"];
			$rs=$this->dbconn->Execute($strSQL);
			$values=array();
			$i=0;
			while (!$rs->EOF) {
				$values[$i]['id']=$rs->fields[0];
				$values[$i]['name']=stripslashes($rs->fields[1]);
				$rs->MoveNext();
				$i++;
			}
			return $values;
		}else{
			return 0;
		}
		
	}
	/**
	 * Gets all specified form attributes
	 *
	 * @param int $id_form - Form ID
	 * @return attributes array
	 */
	function getFormAttributes($id_form){
		$strSQL="SELECT b.id_block, b.id_attribute, b.attr_order FROM ".FORMS_TABLE." b
					WHERE b.id_block=".$id_form." AND ISNULL(b.id_attribute)=0 ORDER BY attr_order";
		$rs=$this->dbconn->Execute($strSQL);
		$attrs=array();
		$i=0;
		while (!$rs->EOF) {
			$row=$rs->GetRowAssoc(false);
			
			$attrs[$i]['id_block']=$row['id_block'];
			$attrs[$i]['attr_order']=$row['attr_order'];
			$attr_temp=$this->getSectionAttribute($row['id_attribute']);
			$attrs[$i]=array_merge($attrs[$i], $attr_temp);
			$i++;
			$rs->MoveNext();
		}
		return $attrs;
	}

	/**
	 * Updates form block
	 *
	 * @param int $id_block - Block ID
	 * @param array $attrs - New Block Attributes
	 */
	function updateForm($id_form, $attrs){
		$strSQL="DELETE FROM ".FORMS_TABLE." WHERE id_block=".$id_form;
		$this->dbconn->Execute($strSQL);
		foreach ($attrs as $order=>$id_attr){
			$strSQL="INSERT INTO ".FORMS_TABLE."(id_block, id_attribute, attr_order) VALUES(".$id_form.", ".$id_attr.", ".$order.")";
			$this->dbconn->Execute($strSQL);
		}
	}
	
	function deleteForm($id_form){
		$strSQL="DELETE FROM ".FORMS_TABLE." WHERE id_block=".$id_form;
		$this->dbconn->Execute($strSQL);
	}
	/**
	 * Gets specified section data
	 *
	 * @param int $id_section - Section ID
	 * @return section data
	 */
	function getSection($id_section){
		global $auth;
		$strSQL="SELECT id, name, is_const FROM ".SECTIONS_TABLE." WHERE id=".$id_section;
		$rs=$this->dbconn->Execute($strSQL);
		
		$section=array();
		$row=$rs->GetRowAssoc(false);
		$section['id']=$row['id'];
		$section['name']=$row['name'];
		$section['is_const']=$row['is_const'];
			
		return $section;
	}
	
	/**
	 * Gets all sections
	 *
	 * @return all section data
	 */
	function getSections(){
		global $auth;
		$strSQL="SELECT id FROM ".SECTIONS_TABLE." WHERE id_user=".$auth["id"]." or is_const ='Y' ORDER BY id";
		$rs=$this->dbconn->Execute($strSQL);
		$sections=array();
		$i=0;
		while (!$rs->EOF){
			$sections[$i]=$this->getSection($rs->fields[0]);
			$i++;
			$rs->MoveNext();
		}
		return $sections;
	}
	
	/**
	 * Gets specified section attribute
	 *
	 * @param int $id_attr - Attribute ID
	 * @return attribute data
	 */
	function getSectionAttribute($id_attr){
		global $auth;
		if (is_array($id_attr)){
			if (count($id_attr)==0) return array();
			$attr_str=' AND a.id IN ('.implode(', ', $id_attr).')';
		}else {
			if (intval($id_attr)==0) return ERR_INVALID_ATTR_ID;
			$attr_str=' AND a.id='.$id_attr;
		}
		
		$strSQL="SELECT a.id, a.name, a.id_section, a.mandatory, a.control_type, a.control_setup, a.is_const 
				FROM ".SECTION_ATTRS_TABLE." a
				WHERE a.id_user={$auth["id"]}".$attr_str;
		$rs=$this->dbconn->Execute($strSQL);

		$sec_attrs=array();
		while (!$rs->EOF){
			$attr=array();
			$row=$rs->GetRowAssoc(false);
			$id=intval($row['id']);
			$attr['id']=$id;
			$attr['id_section']=$row['id_section'];
			$attr['mandatory']=$row['mandatory'];
			$attr['control_type']=$row['control_type'];
			$attr['is_const']=$row['is_const'];
			$attr['setup']=unserialize(stripslashes($row['control_setup']));
			$attr['field_name']=$row['name'];
			$attr['type_text']=$this->getControlType($row['control_type']);

			switch ($attr['control_type']){
				case 'text':
				case 'textarea':
					//Table key = VALUES_KEY, id_reference = new attribute id
					$strSQL="SELECT name FROM ".REFERENCE_SPR." WHERE table_key=".VALUES_KEY." AND id_reference=".$attr['id'];
					$res=$this->dbconn->Execute($strSQL);
					$attr['setup']['def_value']=$res->fields[0];
					break;
				case 'select':
				//Table key = attribute id, id_reference = select id
				if ($attr['setup']['datasource']==-1) {
					$strSQL="SELECT id, id_reference as id_ref, name FROM ".REFERENCE_SPR." WHERE table_key=".($attr['id']+1)." ORDER BY id";
					$res=$this->dbconn->Execute($strSQL);
					$i=0;
					while (!$res->EOF) {
						$row=$res->GetRowAssoc(false);
						$attr['setup']['values'][$i]['id']=$row['id_ref'];
						$attr['setup']['values'][$i]['name']=stripslashes($row['name']);
						$i++;
						$res->MoveNext();
					}
				}elseif ($attr['setup']['datasource']=="0"){
					$strSQL="SELECT id, name FROM ".LISTS_TABLE;
					$res=$this->dbconn->Execute($strSQL);
					$i=0;
					while (!$res->EOF) {
						$row=$res->GetRowAssoc(false);
						$attr['setup']['values'][$i]['id']=$row['id'];
						$attr['setup']['values'][$i]['name']=stripslashes($row['name']);
						$i++;
						$res->MoveNext();
					}
				}else{
					$ds_id=$attr['setup']['datasource'];
					$attr['setup']['values']=$this->getDataSourceValues($ds_id);
				}
				break;
			}
			$sec_attrs[$attr['id']]=$attr;
			$rs->MoveNext();
		}
		if (is_array($id_attr)==false) return $attr; else return $sec_attrs;
	}
	
	function getControlType($control_type){
		switch ($control_type){
			case 'checkbox': $type='Checkbox';break;
			case 'text': $type='Text';break;
			case 'select': $type='Select';break;
			case 'textarea': $type='Textarea';break;
			case 'date': $type='Date';break;
		}
		return $type;
	}
	
	/**
	 * Gets all specified section attributes
	 *
	 * @param int $id_section - Section ID
	 * @param int $total_count - Total count of returned attributes
	 * @param int $id_form - If specified will be used to filter attributes
	 * @return all section attributes
	 */
	function getSectionAttributes($id_section, &$total_count, $id_form=''){
		global $auth;
		$filter_str='';
		
		//Set id_form to form identifier to exclude section attributes, which already specified form has
		if ($id_form!='') {
			$form_attrs=$this->getFormAttributes($id_form);
			if (count($form_attrs)>0) {
				$filter_str=' AND ( ';
				$len=count($form_attrs);
				for ($i=0; $i<$len;$i++){
					$filter_str.='a.id!='.$form_attrs[$i]['id'];
					if ($i!=($len-1)) $filter_str.=" AND ";
				}
				$filter_str.=')';				
			}
		}
		//Get total attibute count
		$strSQL="SELECT COUNT(*) as count FROM ".SECTION_ATTRS_TABLE." a
				WHERE a.id_user={$auth["id"]} AND a.id_section=".$id_section;
		$rs=$this->dbconn->Execute($strSQL);
		$total_count=$rs->fields[0];

		//Get section attribute
		$strSQL="SELECT a.id FROM ".SECTION_ATTRS_TABLE." a
				WHERE a.id_user={$auth["id"]} AND a.id_section=".$id_section.$filter_str;
		$rs=$this->dbconn->Execute($strSQL);
		$attrs=array();
		$i=0;
		while (!$rs->EOF) {
			$row=$rs->GetRowAssoc(false);
			
			$attrs[$i]=$this->getSectionAttribute($row['id']);
			
			$i++;
			$rs->MoveNext();
		}
		return $attrs;
	}
	
	/**
	 * Gets all existing attributes using filter and order
	 *
	 * @param int &$total_count - total returned attributes count
	 * @param str $filter_str - SQL query filter
	 * @param str $order_by - SQL query order
	 * @return unknown
	 */
	function getAllAttributes(&$total_count, $filter_str='', $order_by='', $ids_only=false, $id_user=1){
		global $auth;
		$strSQL="";

		if ($filter_str!='') $filter_str=" and ".$filter_str;
		if ($order_by=='') $order_by="ORDER BY a.id";
		//Get total attibute count
		$strSQL="SELECT COUNT(*) as count FROM ".SECTION_ATTRS_TABLE." a WHERE a.id_user={$auth["id"]} AND 1=a.id_section ".$filter_str.$order_by;
		$rs=$this->dbconn->Execute($strSQL);
		$total_count=$rs->fields[0];

		//Get section attribute
		$strSQL="SELECT a.id FROM ".SECTION_ATTRS_TABLE." a WHERE a.id_user={$auth["id"]} AND 1=a.id_section ".$filter_str.$order_by;
		$rs=$this->dbconn->Execute($strSQL);
		$attrs=array();
		while (!$rs->EOF) {
			$attrs[]=intval($rs->fields[0]);
			$rs->MoveNext();
		}
		
		//If only attribute IDs needed
		if ($ids_only) return $attrs;

		//Otherwise retrieve data
		$attrs_data=$this->getSectionAttribute($attrs);
		foreach ($attrs as $index=>$id_attr){
			$attrs[$index]=$attrs_data[$id_attr];
		}

		return $attrs;
	}
	
	/**
	 * Adds new section
	 *
	 * @param array $section_data - New section data
	 * @return new section id
	 */
	function addNewSection($section_data){
		global $auth;
		$new_sec_id=0;

		$strSQL="INSERT INTO ".SECTIONS_TABLE."(name, id_user) VALUES('".addslashes($section_data['name'])."',".$auth["id"].")";
		$this->dbconn->Execute($strSQL);
		$new_sec_id=$this->dbconn->Insert_ID();
		return $new_sec_id;
	}
	
	/**
	 * Deletes specified section
	 *
	 * @param int $id_section - Section ID
	 * @return if success returns true, otherwise false
	 */
	function delSection($id_section){
		if ($this->checkIfSectionIsConst($id_section)) return false;

		$total_count=0;
		$attrs=$this->getSectionAttributes($id_section, $total_count);
		foreach ($attrs as $attr) $this->delSectionAttribute($attr['id']);
		$strSQL="DELETE FROM ".SECTIONS_TABLE." WHERE id=".$id_section;
		$this->dbconn->Execute($strSQL);
		
		return true;
	}
	
	function addSectionAttribute($id_section, $attr_data){
		global $auth;
		//Add attribute
		$strSQL="INSERT INTO ".SECTION_ATTRS_TABLE."(name, id_section, mandatory, control_type,id_user) VALUES('".addslashes($attr_data['field_name'])."', ".$id_section.", '".$attr_data['mandatory']."', '".$attr_data['control_type']."',{$auth["id"]})";
		$this->dbconn->Execute($strSQL);
		$new_id=$this->dbconn->Insert_ID();

		switch ($attr_data['control_type']){
			case 'text':
			case 'textarea':
							//Table key = VALUES_KEY, id_reference = new attribute id
							$def_value=$attr_data['setup']['def_value'];
							$strSQL="INSERT INTO ".REFERENCE_SPR."(table_key, id_reference, name) VALUES(".VALUES_KEY.", ".$new_id.", '".addslashes($def_value)."')";
							$this->dbconn->Execute($strSQL);
							$attr_data['setup']['def_value']=$new_id;
							break;
			case 'select':	
							//Table key = attribute id, id_reference = select id
							if ($attr_data['setup']['datasource']==-1) {
								$values=$attr_data['setup']['values'];
								$temp=array();
								foreach ($values as $value){
									$strSQL="INSERT INTO ".REFERENCE_SPR."(table_key, id_reference, name) VALUES(".($new_id+1).", ".$value['id'].", '".addslashes($value['name'])."')";
									$this->dbconn->Execute($strSQL);
								}								
							}
							unset($attr_data['setup']['values']);
							break;
		}
		$strSQL="UPDATE ".SECTION_ATTRS_TABLE." SET control_setup='".addslashes(serialize($attr_data['setup']))."' WHERE id=".$new_id;
		$this->dbconn->Execute($strSQL);
		return $new_id;
	}
	
	function updateSectionAttribute($id_attr, $attr_data){
		//Get previous setup
		$strSQL="SELECT control_type FROM ".SECTION_ATTRS_TABLE." WHERE id=".$id_attr;
		$rs=$this->dbconn->Execute($strSQL);
		$last_type=$rs->fields[0];
		
		//Add attribute
		$strSQL="UPDATE ".SECTION_ATTRS_TABLE." SET name='".addslashes($attr_data['field_name'])."', mandatory='".$attr_data['mandatory']."', control_type='".$attr_data['control_type']."' WHERE id=".$id_attr;
		$this->dbconn->Execute($strSQL);
		
		switch ($attr_data['control_type']){
			case 'text':	
			case 'textarea':
							//id_reference = new attribute id
							$def_value=$attr_data['setup']['def_value'];
							if ($last_type=='select'){
								$strSQL="DELETE FROM ".REFERENCE_SPR." WHERE table_key=".($id_attr+1);
								$this->dbconn->Execute($strSQL);
								$strSQL="INSERT INTO ".REFERENCE_SPR."(table_key, id_reference, name) VALUES(".VALUES_KEY.", ".$id_attr.", '".addslashes($def_value)."')";
							}
							else $strSQL="UPDATE ".REFERENCE_SPR." SET name='".addslashes($def_value)."' WHERE table_key=".VALUES_KEY." AND id_reference=".$id_attr;
							$this->dbconn->Execute($strSQL);
							break;
			case 'select':	
							//Table key = new attribute id+18, id_reference = select id
							if ($last_type!='select') {
								$strSQL="DELETE FROM ".REFERENCE_SPR." WHERE table_key=".VALUES_KEY." AND id_reference=".$id_attr;
								$this->dbconn->Execute($strSQL);
							}else {
								$strSQL="DELETE FROM ".REFERENCE_SPR." WHERE table_key=".($id_attr+1);
								$this->dbconn->Execute($strSQL);
							}
							if ($attr_data['setup']['datasource']==-1) {
								$values=$attr_data['setup']['values'];
								$temp=array();
								foreach ($values as $value){
									$strSQL="INSERT INTO ".REFERENCE_SPR."(table_key, id_reference, name) VALUES(".($id_attr+1).", ".$value['id'].", '".addslashes($value['name'])."')";
									$this->dbconn->Execute($strSQL);
								}
							}
							unset($attr_data['setup']['values']);
							break;
		}
		$strSQL="UPDATE ".SECTION_ATTRS_TABLE." SET control_setup='".addslashes(serialize($attr_data['setup']))."' WHERE id=".$id_attr;
		$this->dbconn->Execute($strSQL);
		return true;		
	}
	
	function delSectionAttribute($id_attr){
		if ($this->checkIfAttrIsConst($id_attr)) return false;
		
		$attr_data=$this->getSectionAttribute($id_attr);
		switch ($attr_data['control_type']){
			case 'text':
			case 'textarea':
							$strSQL="DELETE FROM ".REFERENCE_SPR." WHERE table_key=".VALUES_KEY." AND id_reference=".$id_attr;
							break;
			case 'select':
							$strSQL="DELETE FROM ".REFERENCE_SPR." WHERE table_key=".($id_attr+1);
							break;
		}
		$this->dbconn->Execute($strSQL);
		$strSQL="DELETE FROM ".SECTION_ATTRS_TABLE." WHERE id=".$id_attr;
		$this->dbconn->Execute($strSQL);
		$strSQL="DELETE FROM ".FORMS_TABLE." WHERE id_attribute=".$id_attr;
		$this->dbconn->Execute($strSQL);
		
		return true;
	}
	
	function getRegExps(){
		$strSQL="SELECT id, name, reg_exp FROM ".REG_EXPS_TABLE;
		$rs=$this->dbconn->Execute($strSQL);
		
		$regs=array();
		$i=0;
		
		while (!$rs->EOF) {
			$row=$rs->GetRowAssoc(false);
			
			$id_reg=$row['id'];
			$regs[$id_reg]['id']=$row['id'];
			$regs[$id_reg]['name']=$row['name'];
			$regs[$id_reg]['reg_exp']=$row['reg_exp'];
			
			$i++;
			$rs->MoveNext();
		}
		return $regs;
	}
	
	function addNewRegExp($regexp_data){
		$strSQL="INSERT INTO ".REG_EXPS_TABLE."(name, reg_exp) VALUES('".addslashes($regexp_data['name'])."', '".addslashes($regexp_data['reg_exp'])."')";
		$this->dbconn->Execute($strSQL);
		$new_id=$this->dbconn->Insert_ID();
		return $new_id;
	}
	
	function delRegExp($regexp_id){
		$strSQL="DELETE FROM ".REG_EXPS_TABLE." WHERE id=".$regexp_id;
		$this->dbconn->Execute($strSQL);
	}
	
	function updateRegExps($regs){
		foreach ($regs as $reg_exp){
			$strSQL="UPDATE ".REG_EXPS_TABLE." SET reg_exp='".addslashes($reg_exp['reg_exp'])."' WHERE id=".$reg_exp['id'];
			$this->dbconn->Execute($strSQL);
		}
	}
	
	function checkIfSectionIsConst($id_section){
		$strSQL="SELECT is_const FROM ".SECTIONS_TABLE." WHERE id=".$id_section;
		$rs=$this->dbconn->Execute($strSQL);
		$is_const=($rs->fields[0]=='Y')?true:false;
		
		return $is_const;
	}
	
	function checkIfAttrIsConst($id_attr){
		$strSQL="SELECT is_const FROM ".SECTION_ATTRS_TABLE." WHERE id=".$id_attr;
		$rs=$this->dbconn->Execute($strSQL);
		$is_const=($rs->fields[0]=='Y')?true:false;
		
		return $is_const;
	}
	
	function getUserSectionData($id_user, $id_section, $convert_to_str=false){
		$strSQL="SELECT a.id, b.value FROM ".SECTION_ATTRS_TABLE." a
			LEFT JOIN ".USER_ATTR_TABLE." b ON a.id=b.id_attr
			WHERE a.id_section=".$id_section." AND b.id_user=".$id_user;
		$rs=$this->dbconn->Execute($strSQL);
		$user_attrs=array();
		while (!$rs->EOF) {
			$row=$rs->GetRowAssoc(false);
			
			$id_attr=$row['id'];
			$user_attrs[$id_attr]['id_attr']=$row['id'];
			$user_attrs[$id_attr]['value']=$this->getUserAttribute($id_user, $id_attr, $convert_to_str);
			
			$rs->MoveNext();
		}
		return $user_attrs;
	}
	
	/**
	 * Gets user attribute value in various formats (view/edit), depending on last parametr
	 *
	 * @param int $id_user - User ID
	 * @param int $id_attr - Attribute ID
	 * @param bool $convert_to_str - Determines is data for display, or data for edit
	 * @return user attribute value
	 */
	function getUserAttribute($id_user, $id_attr, $convert_to_str=false){
		global $auth;
		$attr_str=(is_array($id_attr))?'a.id IN ('.implode(', ', $id_attr).')': "a.id=".$id_attr;
		$strSQL="SELECT a.id, a.control_type, a.control_setup, b.value 
						FROM ".SECTION_ATTRS_TABLE." a
						LEFT JOIN ".USER_ATTR_TABLE." b ON a.id=b.id_attr
					WHERE ".$attr_str." AND b.id_user=".$id_user;
		$rs=$this->dbconn->Execute($strSQL);
		if ($rs->RowCount()==0) return false;
		$user_attr=array();
		$row=$rs->GetRowAssoc(false);
		$setup=unserialize($row['control_setup']);
		
		switch ($row['control_type']){
			case 'checkbox':
			case 'text':
			case 'textarea':
							$temp=$row['value'];
							break;
			case 'select':	
							if (strpos($row['value'], ',')) $temp=explode(',', $row['value']);
							if (!is_array($temp)) {
								$temp=array();
								$temp[0]=$row['value'];
							}
							if (is_array($temp)){
								foreach ($temp as $index=>$id_ref){
									if ($convert_to_str) {
										if ($setup['datasource']==-1) $strSQL="SELECT name FROM ".REFERENCE_SPR." WHERE table_key=".($id_attr+1)." AND id_reference=".$id_ref;
										else {
											$datasource=$this->ds[$setup['datasource']];
											$strSQL="SELECT ".$datasource['col_name']." as name FROM {$this->config["table_prefix"]}".$datasource['table']." WHERE ".$datasource['col_id']."=".$id_ref;
										}
										$rs=$this->dbconn->Execute($strSQL);
										
										if(!$rs){
											$res[$id_ref]=$id_ref;
										}else{
											$res[$id_ref]=$rs->fields[0];
										}
									}else{
										$res[$id_ref]=$id_ref;
									}
									
								}
								if ($convert_to_str) $res=implode(', ', $res);
								$temp=$res;
							}
							break;
			case 'date':
							$temp=unserialize($row['value']);
							if ($convert_to_str) {
								$temp=$temp['month'].'-'.$temp['day'].'-'.$temp['year'];
							}
							break;
		}
		$value=$temp;
		return $value;
	}
	
	function getIdAttributeByName($attr_name){
		global $auth;
		
		if($attr_name=='') return 0;
		$strSQL="SELECT id FROM ".SECTION_ATTRS_TABLE." WHERE name='{$attr_name}' AND id_user={$auth["id"]}";
		$rs=$this->dbconn->Execute($strSQL);
		if ($rs->RowCount()==0) return 0;
		return $rs->fields[0];
	}
	
	function getNameAttributeById($id_attr){
		global $auth;
		
		$id_attr = intval($id_attr);
		if($id_attr==0) return 0;
		$strSQL="SELECT name FROM ".SECTION_ATTRS_TABLE." WHERE id='{$id_attr}'";
		$rs=$this->dbconn->Execute($strSQL);
		if ($rs->RowCount()=='') return 0;
		return $rs->fields[0];
	}
	
	function getIdModeratorByIdAttr($id_attr){
		global $auth;
		
		$id_attr = intval($id_attr);
		if($id_attr==0) return 0;
		$strSQL="SELECT id_user FROM ".SECTION_ATTRS_TABLE." WHERE id='{$id_attr}'";
		$rs=$this->dbconn->Execute($strSQL);
		if ($rs->RowCount()==0) return 0;
		return $rs->fields[0];
	}
	
	function getAllUserData($id_user, $convert_to_str=false){
		$strSQL="SELECT id_attr FROM ".USER_ATTR_TABLE." WHERE id_user=".$id_user;
		$rs=$this->dbconn->Execute($strSQL);
		while (!$rs->EOF) {
			$row=$rs->GetRowAssoc(false);
			
			$id_attr=$row['id_attr'];
			$user_attrs[$id_attr]['id_attr']=$id_attr;
			$user_attrs[$id_attr]['value']=$this->getUserAttribute($id_user, $id_attr, $convert_to_str);
			
			$rs->MoveNext();
		}
		return $user_attrs;
	}
	
	/**
	 * Saves user attibute (inserts new if not exists, or updates existing)
	 *
	 * @param int $id_user - User ID
	 * @param int $id_attr - Attribute ID
	 * @param array $new_value - New attribue data
	 */
	function saveUserAttribute($id_user, $id_attr, $new_value){
		$attr=$this->getSectionAttribute($id_attr);

		$exist=false;
		//Check if attribute already exist in user data
		$strSQL="SELECT value FROM ".USER_ATTR_TABLE." WHERE id_user=".$id_user." AND id_attr=".$id_attr;
		$rs=$this->dbconn->Execute($strSQL);
		if ($rs->RowCount()>0) $exist=true;

		switch ($attr['control_type']){
			case 'checkbox':
			case 'text':
			case 'textarea':
							if ($exist) $strSQL="UPDATE ".USER_ATTR_TABLE." SET value='".addslashes($new_value)."' WHERE id_user=".$id_user." AND id_attr=".$id_attr;
								else $strSQL="INSERT INTO ".USER_ATTR_TABLE."(id_user, id_attr, value) VALUES(".$id_user.", ".$id_attr.", '".addslashes($new_value)."')";
							break;
			case 'select':	
							if (is_array($new_value)) $new_value=implode(',', $new_value);
							if ($exist) $strSQL="UPDATE ".USER_ATTR_TABLE." SET value='".addslashes($new_value)."' WHERE id_user=".$id_user." AND id_attr=".$id_attr;
								else $strSQL="INSERT INTO ".USER_ATTR_TABLE."(id_user, id_attr, value) VALUES(".$id_user.", ".$id_attr.", '".addslashes($new_value)."')";
							break;
			case 'date':
							$str_arr=serialize($new_value);
							if ($exist) $strSQL="UPDATE ".USER_ATTR_TABLE." SET value='".addslashes($str_arr)."' WHERE id_user=".$id_user." AND id_attr=".$id_attr;
								else $strSQL="INSERT INTO ".USER_ATTR_TABLE."(id_user, id_attr, value) VALUES(".$id_user.", ".$id_attr.", '".addslashes($str_arr)."')";
							break;
		}
		$this->dbconn->Execute($strSQL);
	}
	
	function saveUserAttributes($id_user, $attrs){
		foreach ($attrs as $id_attr=>$value){
			$this->saveUserAttribute($id_user, $id_attr, $value);
		}
		return '';
	}

	function delUserAttributes($id_user){
		//Delete all user attributes
		$strSQL="DELETE FROM ".USER_ATTR_TABLE." WHERE id_user=".$id_user;
		$this->dbconn->Execute($strSQL);
	}
	
	function attrSearch($id_attr, $value, $id_user=0){
		$strSQL="SELECT a.id_user FROM ".USER_ATTR_TABLE." a WHERE a.id_attr=".$id_attr." AND a.value='".$value."'";
		if ($id_user) $strSQL.=" AND IF((SELECT su.id FROM ".SEND_USERS_TABLE." su WHERE id_user={$id_user} AND id=a.id_user),1,0)=1";
		$rs=$this->dbconn->Execute($strSQL);
		if ($rs->RowCount()==0) return false;
		$users=array();
		$i=0;
		while (!$rs->EOF) {
			$users[]=$rs->fields[0];
			$rs->MoveNext();
		}
		return $users;
	}
	
	function toDate($id_user, $id_date_attr){
		$value=$this->getUserAttribute($id_user);
		$date=$value['year'].'-'.$value['month'].'-'.$value['day'];
		return $date;
	}
}	
?>
