<?php
include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$this_page="mailing_lists";
if($mode == 1){
	@$sel =$_POST["sel"]?$_POST["sel"]:$_GET["sel"];
	$file_name = ($_SERVER["PHP_SELF"]) ? AfterLastSlash($_SERVER["PHP_SELF"]) : "mailing_list.php";
	
	switch($sel){
		case "delete": if(IsFunctionAllowed($auth["id"],20)){DeleteLists();}else{ViewLists();} break;
		case "clear": ClearLists(); break;
		case "merge": if(IsFunctionAllowed($auth["id"],21)){MergeLists();}else{ViewLists();} break;
		case "add": if(IsFunctionAllowed($auth["id"],19)){AddLists();}else{ViewLists();} break;
		case "save": SaveLists(); break;
		case "target_add": if(IsFunctionAllowed($auth["id"],19)){AddTargetLists();}else{ViewLists(1);} break;
		case "target_save": SaveTargetLists(); break;
		case "target_list": ViewLists(1); break;
		default: ViewLists();
	}
}

function ViewLists($target=0){
	global $config, $smarty, $dbconn, $auth, $file_name,$lang;
	
	AdminMainMenu("lists");
	
	if(IsFunctionAllowed($auth["id"],19)){$smarty->assign("create_list",1);}
	if(IsFunctionAllowed($auth["id"],20)){$smarty->assign("delete_list",1);}
	if(IsFunctionAllowed($auth["id"],21)){$smarty->assign("merge_list",1);}
	if(IsFunctionAllowed($auth["id"],22)){$smarty->assign("view_subscribers",1);}
	
	$strSQL = "SELECT COUNT(id) FROM ".LISTS_TABLE." WHERE id_user={$auth["id"]} AND target={$target}";
	$res=$dbconn->Execute($strSQL);
	$amount = $res->fields[0];

	$strSQL = "SELECT id, name, DATE_FORMAT(date,'{$config["date_format"]}') as date, target FROM ".LISTS_TABLE." WHERE id_user={$auth["id"]} AND target={$target}";
	$res=$dbconn->Execute($strSQL);

	$data=array();
	$c=0;
	while(!$res->EOF){
		$data[$c]['id'] = $res->fields[0];
		$data[$c]['name'] = $res->fields[1];
		$data[$c]['date'] = $res->fields[2];
		$strSQL = "SELECT COUNT(id) FROM ".CLIENTS_LISTS_TABLE." WHERE id_user={$auth["id"]} AND list_id={$data[$c]['id']} AND status_subscribe=".SUBSCRIBE;
		$res2 = $dbconn->Execute($strSQL);
		$data[$c]['count'] = $res2->fields[0];
		$c++;
		$res->MoveNext();
	}
	ArrStripSlashes($data);
	
	get_smarty_array_list("list_page", $config["list_page"]);
	$smarty->assign("amount",$amount);
	$smarty->assign("target",$target);
	$smarty->assign("file_name",$file_name);
	$smarty->assign("data", $data);
	$smarty->display($config["admin_nl_gentemplates"]."/mailing_lists.tpl");
}

function AddLists(){
	global $config, $smarty, $dbconn, $auth, $file_name;
	
	AdminMainMenu("lists");
	
	$strSQL = "SELECT id, subject, DATE_FORMAT(date,'{$config["date_format"]}') as date, format FROM ".CRELEASES_TABLE." WHERE id_user={$auth["id"]}";
	$res=$dbconn->Execute($strSQL);
	while (!$res->EOF) {
		$values[] = stripslashes($res->fields[0]);
		$output[] = stripslashes($res->fields[1])." (".$res->fields[3]." - ".$res->fields[2].")";
		$res->MoveNext();
	}
	$smarty->assign(array("newsletters_values"	=> $values,
						  "newsletters_output"	=> $output));

	$data = array();	
	if (isset($_GET["id"]) && $_GET["id"]){
		$id = intval($_GET["id"]);
		$strSQL = "SELECT id,name,release_sub_id, release_unsub_id FROM ".LISTS_TABLE." WHERE id={$id} AND id_user={$auth["id"]} AND target=0";
		$res=$dbconn->Execute($strSQL);
		$data['id']=$res->fields[0];
		$data['name']=$res->fields[1];
		$data['release_sub_id']=$res->fields[2];
		$data['release_unsub_id']=$res->fields[3];
	}
	ArrStripSlashes($data);
	$smarty->assign("data", $data);
	$smarty->assign("file_name",$file_name);
	$smarty->display($config["admin_nl_gentemplates"]."/mailing_lists_add.tpl");
}

function SaveLists(){
	global $dbconn, $auth;
	
	AdminMainMenu("lists");
	
	ArrAddSlashes($_POST);
	@$id =$_POST["id"]?intval($_POST["id"]):intval($_GET["id"]);
	$newsletter_subscribe_id = intval($_POST["newsletter_subscribe_id"]);
	$newsletter_unsubscribe_id = intval($_POST["newsletter_unsubscribe_id"]);
	
	if ($id==0) {
		$strSQL = "INSERT INTO ".LISTS_TABLE." (name,date,release_sub_id,release_unsub_id, id_user)
  	  					VALUES ('{$_POST["name"]}',NOW(), '{$newsletter_subscribe_id}','{$newsletter_unsubscribe_id}',{$auth["id"]})";
	}else{
		$strSQL = "UPDATE ".LISTS_TABLE." set name='{$_POST["name"]}',
						release_sub_id='{$newsletter_subscribe_id}',
						release_unsub_id='{$newsletter_unsubscribe_id}'
					WHERE id={$id} AND id_user={$auth["id"]}";
	}
	$dbconn->Execute($strSQL);
	//ViewLists();
	header("Location: mailing_list.php");
	exit;
}

function DeleteLists(){
	if (isset($_POST["del"])) {
		$target = intval($_POST["target"]);
		foreach ($_POST["del"] as $val) {
			delList(intval($val));
		}
	}elseif ( isset($_GET['id']) && !empty($_GET['id'])){
		$target = intval($_GET["target"]);
		delList(intval($_GET['id']));
	}
	ViewLists($target);
	exit;
}

function delList($id){
	global $dbconn, $auth;
	$id = intval($id);
	$dbconn->Execute("DELETE FROM ".LISTS_TABLE." WHERE id={$id} AND id_user={$auth["id"]}");
	$dbconn->Execute("DELETE FROM ".CLIENTS_LISTS_TABLE." WHERE list_id={$id} AND id_user={$auth["id"]}");
}

function ClearLists(){
	global  $dbconn, $auth;
	if (isset($_GET["id"])) {
		$strSQL = "DELETE FROM ".CLIENTS_LISTS_TABLE." WHERE list_id=".intval($_GET["id"])." AND id_user={$auth["id"]}";
		$dbconn->Execute($strSQL);
	}
	$target = intval($_GET["target"]);
	ViewLists($target);
	exit;
}

function MergeLists(){
	global $config, $smarty, $dbconn, $auth, $file_name;
	
	AdminMainMenu("lists");
	
	if (isset($_POST['action']) && $_POST['action'] == "change"){
		mergeList($_POST);
		ViewLists();
		exit;
	}
	$strSQL = "SELECT id, subject, DATE_FORMAT(date,'{$config["date_format"]}') as date, format FROM ".CRELEASES_TABLE." WHERE id_user={$auth["id"]}";
	$res=$dbconn->Execute($strSQL);

	while (!$res->EOF) {
		$values[] = stripslashes($res->fields[0]);
		$output[] = stripslashes($res->fields[1])." (".$res->fields[3]." - ".$res->fields[2].")";
		$res->MoveNext();
	}
	$smarty->assign(array(
		"newsletters_values"	=> $values,
		"newsletters_output"	=> $output
	));

	$strSQL = "SELECT id, name FROM ".LISTS_TABLE." WHERE id_user={$auth["id"]} AND target=0";
	$res=$dbconn->Execute($strSQL);

	$data=array();
	$c=0;
	while ( !$res->EOF ) {
		$data[$c]['id'] = $res->fields[0];
		$data[$c]['name'] = $res->fields[1];
		$c++;
		$res->MoveNext();
	}
	ArrStripSlashes($data);

	$smarty->assign("data", $data);
	$smarty->assign("file_name",$file_name);
	$smarty->display($config["admin_nl_gentemplates"]."/mailing_lists_merge.tpl");
	exit;
}

function mergeList($merge){
	global $dbconn, $auth;

	ArrAddSlashes($merge);
	
	$mas_user = array();
	for ($i=0;$i<count($merge["merge"]);$i++){
		$mas_user_1 = array();
		$mas_user_1 = getUsersforMerge($merge["merge"][$i]);
		$mas_user = array_unique(array_merge($mas_user,$mas_user_1));
	}

	$newsletter_subscribe_id = intval($_POST["newsletter_subscribe_id"]);
	$newsletter_unsubscribe_id = intval($_POST["newsletter_unsubscribe_id"]);
	$strSQL = "INSERT INTO ".LISTS_TABLE." (name,date,release_sub_id,release_unsub_id,id_user)
  	  				VALUES ('{$merge["name"]}',NOW(),'{$newsletter_subscribe_id}','{$newsletter_unsubscribe_id}',{$auth["id"]})";
	$dbconn->Execute($strSQL);
	$rid=$dbconn->insert_id();
	for ($i=0;$i<count($mas_user);$i++){
		$dbconn->Execute("INSERT INTO ".CLIENTS_LISTS_TABLE." (client_id,list_id,status_subscribe,date_status, id_user) VALUES ({$mas_user[$i]},{$rid},".SUBSCRIBE.",NOW(),{$auth["id"]})");
	}
}

function getUsersforMerge($a=""){
	global $dbconn, $auth;
	$res=$dbconn->Execute("SELECT client_id FROM ".CLIENTS_LISTS_TABLE." WHERE id_user={$auth["id"]} AND list_id={$a} ORDER BY client_id");
	$users=array();
	$c=0;
	while(!$res->EOF){
		$users[$c] = $res->fields[0];
		$c++;
		$res->MoveNext();
	}
	return $users;
}

function AddTargetLists(){
	global $config, $smarty, $dbconn, $auth, $file_name, $lang;
	
	include "include/class.form.php";
	
	AdminMainMenu("lists");
	
	$strSQL = "SELECT id, name FROM ".LISTS_TABLE." WHERE id_user={$auth["id"]} AND target=0";
	$res=$dbconn->Execute($strSQL);

	$mlist=array();
	$mlist[0]['id'] = 0;
	$mlist[0]['name'] = $lang["common"]["all_subscrs"];
	$c=1;
	while(!$res->EOF){
		$mlist[$c]['id'] = $res->fields[0];
		$mlist[$c]['name'] = $res->fields[1];
		$c++;
		$res->MoveNext();
	}
	ArrStripSlashes($mlist);
	
	$form=new Form($dbconn, $config);
	$attrs=$form->getSectionAttributes(1, $total_count);
	foreach ($attrs as $key=>$val){
		if($val["id"]==FIELD_MAILLIST) {unset($attrs[$key]); break;}
	}
	
	$smarty->assign('attrs', $attrs);
	$smarty->assign("mlist", $mlist);
	$smarty->assign("file_name",$file_name);
	$smarty->display($config["admin_nl_gentemplates"]."/target_list_add.tpl");
}

function SaveTargetLists(){
	global $dbconn, $auth, $config;
	
	include "include/class.form.php";
	
	AdminMainMenu("lists");
	
	ArrAddSlashes($_REQUEST);
	$list_id =isset($_REQUEST["list"]) ? intval($_REQUEST["list"]) : AddTargetLists("Error");;
	
	$form_class=new Form($dbconn, $config);
	$attrs=array();
	$data=$_POST;
	foreach ($data as $key=>$value){
		$arr=array();
		if (preg_match('/^attr_(\d*)/', $key, $arr)==0) continue;
		$id_attr=$arr[1];
		$sec_attrs[$id_attr]=$form_class->getSectionAttribute($id_attr);
		unset($data[$key]);
		if (is_array($value) && $sec_attrs[$id_attr]['control_type']=='select'){
			$temp=array();
			foreach ($value as $i=>$v) {
				$temp[$v]=$v;
			}
			$data[$id_attr]=$temp;
		}
		else $data[$id_attr]=$value;
		$attrs[$id_attr]=$value;
	}

	foreach ($attrs as $key=>$val){
		if(!array_key_exists($key,$_REQUEST["select_attr"])){
			unset($attrs[$key]);
		}
	}
	//add subcribers
	$users = array();
	if($list_id){
		$strSQL = "SELECT client_id FROM ".CLIENTS_LISTS_TABLE." WHERE list_id={$list_id} AND id_user={$auth["id"]}";
	}else{
		$strSQL = "SELECT id FROM ".SEND_USERS_TABLE." WHERE id_user={$auth["id"]}";
	}
	$rs = $dbconn->Execute($strSQL);
	while(!$rs->EOF){
		$users[] = $rs->fields[0];
		$rs->MoveNext();
	}
	
	$array_all = array();
	$array_all["list"] = $list_id;
	$array_all["attr"] = array();
	
	foreach ($attrs as $id_attr=>$value){
		$attr=$form_class->getSectionAttribute($id_attr);
		
		switch ($attr['control_type']){
			case 'checkbox':
			case 'text':
			case 'textarea':
				break;
			case 'select':
				if (is_array($value)) $value=implode(',', $value);
				break;
			case 'date':
				$value=serialize($value);
				break;
		}
		$array_all["attr"][$id_attr] = $value;
		$id_subscr[$id_attr]=$form_class->attrSearch($id_attr,$value,$auth["id"]);
	}
	
	$all_str = addslashes(serialize($array_all));

	foreach($id_subscr as $key=>$val){
		$users = @array_intersect($users,$val);
	}

	$strSQL = "INSERT INTO ".LISTS_TABLE." (name,date,release_sub_id,release_unsub_id, id_user,target,target_data)
  	  					VALUES ('{$_POST["name"]}',NOW(), 0,0,{$auth["id"]},1,'{$all_str}')";
	
	$rs = $dbconn->Execute($strSQL);
	$target_id = $dbconn->_insertid();
	if(count($users)>0)
		foreach ($users as $key=>$user_id){
			$rs = $dbconn->Execute("SELECT * FROM ".CLIENTS_LISTS_TABLE." WHERE client_id={$user_id} AND list_id={$target_id} AND id_user={$auth["id"]}");
			if ($rs->RowCount() > 0) {
				$strSQL="UPDATE ".CLIENTS_LISTS_TABLE." SET status_subscribe=".SUBSCRIBE.", date_status=now() WHERE client_id={$user_id} AND list_id={$target_id} AND id_user={$auth["id"]}";
				$rs = $dbconn->Execute($strSQL);
			}else {
				$strSQL="INSERT INTO ".CLIENTS_LISTS_TABLE." (client_id, list_id, status_subscribe, date_status, id_user) VALUES ({$user_id},{$target_id}, ".SUBSCRIBE.", NOW(),{$auth["id"]} )";
				$res = $dbconn->Execute($strSQL);
			}
		}
	ViewLists(1);
	exit;
}

?>