//Make global variables for selected image for further usage
var selectImgWidth,selectImgHeight,jcrop_api;
function initGrop(w,h){
	    document.getElementById('interface').innerHTML ='<img id="preview" />';
		document.getElementById('error').style.display = 'none';
		document.getElementById('image_div').style.display = 'none';
		var previewId = document.getElementById('preview');
	    previewId.src = '';
		clearInfo();
	    // Get selected file parameters
	    var selectedImg = $('#image_file')[0].files[0];
	    // Preview the selected image with object of HTML5 FileReader class
	    // Make the HTML5 FileReader Object
	    var oReader = new FileReader();
	        oReader.onload = function(e) {
	            // e.target.result is the DataURL (temporary source of the image)

	        	previewId.src=e.target.result;
	        	// FileReader onload event handler
	        	previewId.onload = function () {
	            // display the image with fading effect
	            $('#image_div').fadeIn(500);
	            selectImgWidth = previewId.naturalWidth; //set the global image width
	        	selectImgHeight = previewId.naturalHeight;//set the global image height
				if(selectImgWidth < w || selectImgHeight < h){
					  document.getElementById('error').style.display = 'block';
					  document.getElementById('error').innerHTML = 'أبعاد الصورة يجب أن تكون أكبر من [' + h + ' * ' + w +']';
					  document.getElementById('image_div').style.display = 'none';
					  document.getElementById('interface').innerHTML = '<img id="preview" />';
					  $('#image_file').parent().parent().removeClass('has-success');
					  $('#image_file').parent().parent().addClass('has-error');
					  $('#submitBtn').attr('disabled','disabled');
				}else{
					// destroy Jcrop if it is already existed
					if (typeof jcrop_api != 'undefined')
						jcrop_api.destroy();

					// initialize Jcrop Plugin on the selected image
					$('#preview').Jcrop({
						minSize: [w, h], // min crop size
						boxWidth: 500,
						setSelect: [0,0,w, h],
						aspectRatio : w/h,
						bgFade: true,
						bgOpacity: .3,
						onChange: updateInfo,
						onSelect: updateInfo,
						onRelease: clearInfo,
						//bgColor: '#fff'// you can use bgColor:'' to transparent
					}, function(){
						// Store the Jcrop API in the jcrop_api variable
						jcrop_api = this;
					});
				}
	        };
	    };

	    // read selected file as DataURL
	    oReader.readAsDataURL(selectedImg);

}
/*function checkForm() {
    if (parseInt($('#w').val())) return true;
    $('.error').html(' الرجاء أختيار منطقة للقطع بعدها تستطيع الرفع').show();
    return false;
};*/

function updateInfo(e) {
    $('#x1').val(e.x);
    $('#y1').val(e.y);
    $('#x2').val(e.x2);
    $('#y2').val(e.y2);
    $('#w').val(e.w);
    $('#h').val(e.h);
};

function clearInfo() {
	$('#x1').val('');
    $('#y1').val('');
    $('#x2').val('');
    $('#y2').val('');
    $('.info #w').val('');
    $('.info #h').val('');
};
