<?php

include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";

login_cheeck($auth);
$mode = IsFileAllowed($auth["id"], GetRightModulePath(__FILE__));
$this_page = "attachments";
$smarty->assign("this_page", $this_page);

if ($mode == 1) {
    @$sel = $_POST["sel"] ? $_POST["sel"] : $_GET["sel"];
    $smarty->assign("get_js", "attach");
    switch ($sel) {
        case "delete": if (IsFunctionAllowed($auth["id"], 8)) {
                DeleteAttach();
            } else {
                ListAttach();
            } break;
        case "upload_ajax": if (IsFunctionAllowed($auth["id"], 7)) {
                AddAttach();
            } else {
                ListAttach();
            } break;
        default: ListAttach();
    }
}

function ListAttach() {
    global $config, $smarty, $auth, $lang;

    AdminMainMenu("attaches");

    if (IsFunctionAllowed($auth["id"], 8)) {
        $smarty->assign("delete_attach", 1);
    }
    if (IsFunctionAllowed($auth["id"], 7)) {
        $smarty->assign("create_attach", 1);
    }


    $smarty->assign("rel", getAttach());
    get_smarty_array_list("attach_page", $config["attach_page"]);
    $lang["attaches"]["max_allow_size"] = str_replace("[size]", ini_get("upload_max_filesize"), $lang["attaches"]["max_allow_size"]);
    $smarty->assign("max_file_size", $lang["attaches"]["max_allow_size"]);
    $smarty->display($config["admin_nl_gentemplates"] . "/attach.tpl");
    exit;
}

function AddAttach() {
    global $dbconn, $config, $auth, $lang, $sel;
    if ($config["phpversion"] == 4 && strpos($sel, "ajax") !== false) {
        include_once "./include/class.json.php";
        $json = new Services_JSON();
    }

    if (!$auth["root"]) {
        $res = $dbconn->Execute("SELECT file_name FROM " . ATTACH_TABLE . " WHERE id_user={$auth["id"]}");
        $all_size = 0;
        while (!$res->EOF) {
            $all_size += filesize($config["files_path"] . $auth["id"] . "/" . $res->fields[0]);
            $res->MoveNext();
        }
        $all_size += $_FILES["file"]["size"];
        $size_limit = GetValuePermUser($auth["id"], 1) * 1024;
        $upload_denide = ($size_limit < $all_size) ? 1 : 0;
    } else {
        $upload_denide = 0;
    }
    if (!$upload_denide) {
        if (!file_exists($config["files_path"] . $auth["id"])) {
            mkdir($config["files_path"] . $auth["id"]);
        }
        chmod($config["files_path"] . $auth["id"], 0777);
        if (CheckUpload($_FILES["file"], "attach", $config["files_path"] . $auth["id"] . "/")) {
            $strSQL = "INSERT INTO " . ATTACH_TABLE . " SET id_user={$auth["id"]} , file_name='{$_FILES["file"]["name"]}'";
            $res = $dbconn->Execute($strSQL);
            $rid = $dbconn->_insertid();
            if (IsFunctionAllowed($auth["id"], 8)) {
                $data["delete"] = 1;
            }
            $data["rid"] = $rid;
            $data["size"] = file_size($config["files_path"] . $auth["id"] . "/{$_FILES["file"]['name']}");
            $data["file_name"] = $_FILES["file"]["name"];
            $data["message"] = $_FILES["file"]["name"] . " " . $lang["users"]["send_end"];
        } else {
            $data["file_name"] = $_FILES["file"]["name"];
            $data["message"] = $_FILES["file"]["name"] . " " . $lang["users"]["send_err"];
        }
    } else {
        $data["file_name"] = $_FILES["file"]["name"];
        $data["message"] = str_replace("[file]", $_FILES["file"]["name"], $lang["users"]["upload_size_err"]);
    }
    //header("Content-type:  charset=utf-8");
    if ($config["phpversion"] == 4) {
        echo $json->encode($data);
    } else {
        echo json_encode($data);
    }
    exit;
}

function DeleteAttach() {
    if (isset($_POST["del"])) {
        foreach ($_POST["del"] as $val) {
            delAttach(intval($val));
        }
    } elseif (isset($_GET['id']) && !empty($_GET['id'])) {
        delAttach(intval($_GET['id']));
    }
}

function DelAttach($id) {
    global $dbconn, $config, $auth;
    $res = $dbconn->Execute("SELECT file_name FROM " . ATTACH_TABLE . " WHERE id={$id}");
    $row = $res->GetRowAssoc(false);
    unlink($config["files_path"] . $auth["id"] . "/" . $row["file_name"]);
    $dbconn->Execute("DELETE FROM " . ATTACH_TABLE . " WHERE id={$id}");
}

function getAttach() {
    global $dbconn, $smarty, $config, $auth;

    $res = $dbconn->Execute("SELECT COUNT(id) FROM " . ATTACH_TABLE . " WHERE id_user={$auth["id"]}");
    $amount = $res->fields[0];
    get_smarty_array_list("attach_page", $config["attach_page"]);

    $res = $dbconn->Execute("SELECT * FROM " . ATTACH_TABLE . " WHERE id_user={$auth["id"]}");

    $releases = array();
    $i = 0;
    $all_size = 0;
    while (!$res->EOF) {
        $row = $res->GetRowAssoc(false);
        $releases[$i]['id'] = $row["id"];
        $releases[$i]['file_name'] = $row["file_name"];
        $releases[$i]['size'] = file_size($config["files_path"] . $auth["id"] . "/" . $row["file_name"]);
        if (!$auth["root"])
            $all_size += filesize($config["files_path"] . $auth["id"] . "/" . $row["file_name"]);
        $releases[$i]['file_path'] = $config["files_web"] . $auth["id"] . "/" . $row["file_name"];
        $i++;
        $res->MoveNext();
    }

    if (!$auth["root"]) {
        $size_limit = GetValuePermUser($auth["id"], 1) * 1024;
        if ($size_limit <= $all_size) {
            $smarty->assign("upload_denide", 1);
        }
    }

    ArrStripSlashes($releases);
    $smarty->assign("amount", $amount);
    return $releases;
}

?>