<?php

/**
 * Class for check of mails-addresses under the returned letters
 */
class email_checker {

    var $__connection;
    var $__server = '';
    var $__login = '';
    var $__password = '';
    var $__use_imap = 0;
    var $__port = '110';
    var $__protocol = 'pop3';
    var $__mailbox = 'INBOX';
    var $__logs = array();
    var $__errors = array();
    var $__dbconn;
    var $__config;
    var $__peek = 10240;

    function email_checker($server, $login, $password, $use_imap, $port="110", $protocol="pop3", $mailbox="INBOX", $dbconn, $config) {

        ini_set("display_errors", "1");
        error_reporting(E_ALL);

        $this->__connection = 0;
        $this->__server = $server;
        $this->__login = $login;
        $this->__password = $password;
        $this->__use_imap = $use_imap;
        $this->__port = $port;
        $this->__protocol = $protocol;
        $this->__mailbox = $mailbox;

        $this->__dbconn = $dbconn;
        $this->__config = $config;

        $this->__logs[] = "Connecting to server: " . $server;
        $this->__errors = array();
    }

    /**
     * Возвращает true, если коннект с сервером осуществился иначе false
     * @return bool
     */
    function connect() {

        //if(!$this->connected()) {
        if ($this->__use_imap) {
            if (strpos($this->__server, ':') === false) {
                $connection = '{' . $this->__server . ':143';
            } else {
                $connection = '{' . $this->__server;
            }
        } else {
            if (strpos($this->__server, ':') === false) {
                $connection = '{' . $this->__server . ':' . $this->__port . '/' . $this->__protocol;
            } else {
                $connection = '{' . $this->__server . ':' . $this->__port . '/' . $this->__protocol;
            }
        }

        $connection .= '}' . $this->__mailbox;
        
       // echo $connection; exit;
        //$connection = '{mail.gtsa-ebulletin.com:993/imap/ssl/novalidate-cert}INBOX';
        $password = $this->__password;//@base64_decode($this->__password);
		//echo $password; exit;
        //$this->errors["connected"] = "Already connected to a server";
        $this->__connection = imap_open($connection, $this->__login, $this->__password);
        //}
        if (!$this->__connection) {
            echo$this->errors["connect"] = "Can't open an IMAP stream to a mailbox! Can't read letters with lights on mailbox!";
            return false;
        }
        return true;
    }

    /**
     * Возвращает true, если коннект с сервером существует иначе false
     * @return bool
     */
    function connected() {
        /* $imap_status = imap_ping($this->__connection);
          if(!$imap_status) {
          return false;
          } */
        return true;
    }

    /**
     * Закрывает текущее IMAP соединение
     * @return bool
     */
    function close() {
        if ($this->__connection) {
            imap_close($this->__connection);
        }
    }

    /**
     * получение header'a письма
     * @return mixed
     */
    function GetHeader($messageid=0) {
        $messageid = (int) $messageid;
        $header = imap_header($this->__connection, $messageid);

        if (isset($header->to))
            return $header;

        $body = imap_body($this->__connection, $messageid);

        // in some bizarre cases, hotmail returns an email with utf-8 BOM (byte-order-mark) at the start of their bounces.
        // so, in that case we have to do something a little different.
        $headers = preg_match("%^(.*?)\r\n\r\n%s", $body, $matches);

        unset($body);

        if (empty($matches) || !isset($matches[1])) {
            return false;
        }

        $header = $matches[1];
        $imap_headers = imap_rfc822_parse_headers(str_replace('﻿', '', $header));

        if (empty($imap_headers))
            return false;

        return $imap_headers;
    }

    /**
     * Get bounce subject
     *
     */
    function GetBounceSubject($header=false) {
        if (!is_object($header))
            return false;

        if (!isset($header->subject))
            return false;

        return strtolower(imap_utf8($header->subject));
    }

    function GetMessage($messageid=0) {
        $messageid = (int) $messageid;
        if ($messageid <= 0)
            return false;

        if (is_null($this->__connection))
            return false;

        return imap_body($this->__connection, $messageid);
    }

    function GetBounceList($body=false) {
        if (!$body)
            return false;

        $bounce_listids = Array();

        $body = preg_replace('%\s+%', ' ', $body);

        if (preg_match('%x-mailer-lid: ([\d,]+)%i', $body, $match)) {
            $bounce_listids = trim($match[1]);
            if (strpos($bounce_listids, ',') !== false) {
                $bounce_listids = explode(',', str_replace(' ', '', $bounce_listids));
            } else {
                $bounce_listids = Array($bounce_listids);
            }
        }

        if (empty($bounce_listids)) {
            if (preg_match('%x-mailer-listid: ([\d+,]*)%i', $body, $match)) {
                $bounce_listid = trim($match[1]);
                $bounce_listids = array($bounce_listid);
            }
        }
        unset($body);

        return $bounce_listids;
    }

    function ParseBody($body, $to) {

        $body = preg_replace('%--- Below this line is a copy of the message.(.*)%is', '', $body);
        $body = preg_replace('%------ This is a copy (.*)%is', '', $body);
        $body = preg_replace('%Content-Type: message/rfc822.*%is', '', $body);
        $body = preg_replace('%Content-Description: Delivery report.*\s*?%i', '', $body);
        $body = str_replace("\r", "", $body);

        $body = str_replace(array("\n", "\r"), " ", $body);
        $body = preg_replace('%\s+%', ' ', $body);

        preg_match_all("%\b([^@^;\s]+@[a-zA-Z0-9\-][a-zA-Z0-9\-\.]{0,254})\b%is", $body, $email_matches);
        $emails_to_return = Array();
        foreach ($email_matches[1] as $p => $emailaddress) {
            if (strpos($emailaddress, 'postmaster') !== false) {
                continue;
            }
            if (!in_array($emailaddress, $emails_to_return) && ($emailaddress != $to)) {
                $emails_to_return[] = $emailaddress;
            }
        }

        if (count($emails_to_return) == 0) {
            return array(false, false, false);
        }

        $status = array();

        // Get delivery status notification
        if (preg_match('/(--[^\s]*?)\sContent-Type\s*?\:\s*?message\/delivery-status\s(.*?)\1/is', substr($body, 0, $this->__peek), $matches)) {
            if (count($matches) == 3) {
                preg_match('/Status\s*?\:\s*?([2|4|5]+)\.(\d{1,3}).(\d{1,3})/is', $matches[2], $status);
            }
            unset($matches);
        }

        // Process delivery status notification
        if (count($status) == 4) {
            $bounce_type = false;
            $bounce_group = false;

            switch ($status[1]) {
                // Delete successful delivery status
                case 2:
                    $bounce_type = 'delete';
                    $bounce_group = 'delete';
                    return array($bounce_type, $bounce_group, $emails_to_return);
                    break;
                // Trasient delivery failure
                case 4:
                    list ($matched, $bounce_type, $bounce_group) = $this->_ProcessRFC3463Transient($status[2], $status[3]);
                    if ($matched) {
                        return array($bounce_type, $bounce_group, $emails_to_return);
                    }
                    break;
                // Permanent delivery failure
                case 5:
                    list ($matched, $bounce_type, $bounce_group) = $this->_ProcessRFC3463Permanent($status[2], $status[3]);
                    if ($matched) {
                        return array($bounce_type, $bounce_group, $emails_to_return);
                    }
                    break;
            }
        }

        foreach ($GLOBALS['BOUNCE_RULES'] as $bounce_type => $bounce_rule) {
            foreach ($bounce_rule as $bounce_group => $rules) {
                foreach ($rules as $p => $target_string) {
                    if (preg_match('%' . preg_quote($target_string) . '%is', $body)) {
                        if (!empty($email_matches))
                            return array($bounce_type, $bounce_group, $emails_to_return);
                    }
                }
            }
        }
        return array(false, false, false);
    }

    function _ProcessRFC3463Transient($statusCode, $statusSubCode) {
        switch ($statusCode) {
            case 5:
                // 4.5.3 Too many recipients
                if ($statusSubCode == 3) {
                    return array(true, 'soft', 'localconfigerror');
                }
                break;
        }
        return array(true, 'delete', 'delete');
    }

    function _ProcessRFC3463Permanent($statusCode, $statusSubCode) {
        $bounce_type = false;
        $bounce_group = false;
        switch ($statusCode) {
            case '1': // Addressing status
                if (in_array($statusSubCode, array('0', '1', '2', '3', '4', '5', '6'))) {
                    $bounce_type = 'hard';
                    $bounce_group = 'emaildoesntexist';
                }
                return array(true, $bounce_type, $bounce_group);
                break;
            case '2': // Mailbox status
                $bounce_type = 'soft';
                // '1' is also inactive, so it can go through to the default case.
                switch ($statusSubCode) {
                    case '2':
                        $bounce_group = 'overquota';
                        break;
                    case '3':
                        $bounce_group = 'blockedcontent';
                        break;
                    case '4':
                        $bounce_group = 'remoteconfigerror';
                        break;
                    default:
                        $bounce_group = 'inactive';
                }
                return array(true, $bounce_type, $bounce_group);
                break;
            case '3': // Mail system status
                $bounce_type = 'soft';
                // 2, 3 and 5 are all 'remoteconfigerror' so just send 'em to the default case.
                switch ($statusSubCode) {
                    case '1':
                        $bounce_group = 'overquota';
                        break;
                    case '4':
                        $bounce_group = 'overquota';
                        break;
                    default:
                        $bounce_group = 'remoteconfigerror';
                }
                return array(true, $bounce_type, $bounce_group);
                break;
            case '4': // Network and routing status
                $bounce_type = 'soft';
                $bounce_group = 'remoteconfigerror';
                return array(true, $bounce_type, $bounce_group);
                break;
            case '5': // Mail delivery protocol status
                if (in_array($statusSubCode, array('0'))) {
                    $bounce_type = 'hard';
                    $bounce_group = 'relayerror';
                } else {
                    $bounce_type = 'soft';
                    $bounce_group = 'localconfigerror';
                }
                return array(true, $bounce_type, $bounce_group);
                break;
            case '6': // Message contents status
                $bounce_type = 'soft';
                $bounce_group = 'localconfigerror';
                return array(true, $bounce_type, $bounce_group);
                break;
            case '7': // Security status
                switch ($statusSubCode) {
                    case '1':
                        $bounce_group = 'blockedcontent';
                        break;

                    default:
                        $bounce_group = 'localconfigerror';
                        break;
                }

                $bounce_type = 'soft';
                return array(true, $bounce_type, $bounce_group);
                break;
        }
        return array(false, false, false);
    }

    function SetBounce($arr, $id_user) {
        /*
          1. проверка на существование мыла в таблицах(bounce_email, snd_users) это делается в цикле
          2. взависимости от того есть мыло или нет инсертим или апдейтим поле в таблице bounce_email
         */

        foreach ($arr[2] as $key => $val) {
            $strSQL = "SELECT
						(SELECT id FROM " . SEND_USERS_TABLE . " WHERE email1='{$val}') AS is_subcriber,
						(SELECT id FROM " . BOUNCE_EMAIL_TABLE . " WHERE email='{$val}') AS is_bounce";
            $rs = $this->__dbconn->Execute($strSQL);
            $id_subcriber = $rs->fields[0];
            $id_bounce = $rs->fields[1];
            if (!is_null($id_subcriber)) {
                if (is_null($id_bounce)) {
                    $strSQL = "INSERT INTO " . BOUNCE_EMAIL_TABLE . " (id_subscriber,email,status,substatus,date,id_user,count)
									VALUES({$id_subcriber},'{$val}','{$arr[0]}','{$arr[1]}',NOW(),{$id_user},1)";
                } else {
                    $strSQL = "SELECT count FROM " . BOUNCE_EMAIL_TABLE . " WHERE id={$id_bounce}";
                    $rs = $this->__dbconn->Execute($strSQL);
                    $count = $rs->fields[0];
                    if ($count >= 5) {
                        $status = 'hard';
                        $substatus = 'emaildoesntexist';
                    } else {
                        $status = $arr[0];
                        $substatus = $arr[1];
                    }
                    $strSQL = "UPDATE " . BOUNCE_EMAIL_TABLE . " SET status='{$status}',substatus='{$substatus}',count=count+1 WHERE id={$id_bounce} AND email='{$val}'";
                }
                $this->__dbconn->Execute($strSQL);
            }
        }
    }

    /**
     * Проверка мыл на ящике
     * @return bool
     */
    function FindAndCheckMail($id_user=1) {
        include_once "bounce_rules.php";

        $numMessage = @imap_num_msg($this->__connection);
        $numMsgForDelete = 0;
        $this->__logs[] = "Letters number: " . $numMessage;
        $this->__logs[] = "Please, wait. Processing is being done...";
        $bounce_arr = array();
        //перебор писем
        for ($num_msg = 1; $num_msg <= $numMessage; $num_msg++) {
            $header = $this->GetHeader($num_msg);
            $subject = $this->GetBounceSubject($header);

            foreach ($GLOBALS['BOUNCE_RULES_SUBJECT'] as $key => $value) {
                if (strstr($subject, strtolower($value))) {
                    array_push($bounce_arr, $num_msg);
                    imap_delete($this->__connection, $num_msg);
                    break;
                }
            }
        }
        
        //imap_delete($this->__connection, $num_msg);

        if (count($bounce_arr) > 0)
            foreach ($bounce_arr as $value) {
                $header = $this->GetHeader($value);
                $body = $this->GetMessage($value);
                $to = $header->to[0]->mailbox . "@" . $header->to[0]->host;
                $arr = $this->ParseBody($body, $to);
                $this->SetBounce($arr, $id_user);
            }

        @imap_expunge($this->__connection);
        $this->__logs[] = "Deleted Letters Number: " . $numMsgForDelete;
    }

}

?>