<?php

class FtpClient {
	var $__server;
	var $__user;
	var $__pass;
	var $__connection_id = false;
	var $__current_dir = '';
	function FtpClient( $server, $user, $pass ) {
		$this->__server = $server;
		$this->__user = $user;
		$this->__pass = $pass;
	}
	function Connect() {
		$this->__connection_id = ftp_connect( $this->__server );
		return !$this->__connection_id ? false : true;
	}
	function Login() {
		return @ftp_login( $this->__connection_id, $this->__user, $this->__pass );
	}
	function ChangeDir( $dir_name ) {
		$result = @ftp_chdir( $this->__connection_id, $dir_name );
		if ( $result ) {
			$this->__current_dir = $dir_name;
		}
		return $result;
	}
	function Close() {
		return ftp_close( $this->__connection_id );
	}
	function Upload( $destination_file, $source_file, $mode ) {
		return ftp_put( $this->__connection_id, $destination_file, $source_file, $mode );
	}
	function Delete( $file) {
		return ftp_delete( $this->__connection_id, $file );
	}
	function GetFileSize( $file) {
		return ftp_size( $this->__connection_id, $file );
	}
	function MakeDir( $new_dir_name ) {
		return ftp_mkdir( $this->__connection_id, $new_dir_name );
	}
	function GetDirContent( $dir ) {
		return ftp_nlist( $this->__connection_id ,$dir);
	}
	function DeleteDir($dir) {
		return ftp_rmdir( $this->__connection_id, $dir );
	}
	function CdUp() {
		return ftp_cdup( $this->__connection_id );
	}
	function FtpLogin( $user, $password ) {
		$errors = array();
		if (!$this->Login()) {
			$errors[] = "Can't login to the server ".$this->__server.' for user '.$this->__user.'!<br>';
		}else {
			if (DEBUG) {
				echo 'Successfull logged in!<br>';
				ob_flush();
				flush();
			}
		}
		return $errors;
	}
	function LoginChDir( $user, $password, $subfolder) {
		$errors = array();
		if (!$this->Login()) {
			$errors[] = "Can't login to the server ".$this->__server.' for user '.$this->__user.'!<br>';
		}else {
			if (DEBUG) {
				echo 'Successfull logged in!<br>';
				ob_flush();
				flush();
			}
			if (!$subfolder=='') {
				if (!$this->ChangeDir($subfolder)) {
					$errors[] = "Can't change dir to ".$subfolder.'!<br>';
				}else {
					if (DEBUG) {
						echo 'Successfull changing dir to '.$this->__current_dir.'<br>';
						ob_flush();
						flush();
					}
				}
			}
		}
		return $errors;
	}
	function UploadFile( $destination_file , $source_file, $overwrite=false) {
		$success = false;
		$is_exist = false;
		$equal_size = true;
		$dest_file_parts = pathinfo($destination_file);
		$dir = ($dest_file_parts['dirname'] != '') ? $dest_file_parts['dirname'] : '.';
		$dir_content = $this->GetDirContent($dir);
		foreach ($dir_content as $filename) {
			if ($filename == $dest_file_parts['basename']) {
				$is_exist = true;
			}
		}
		if ($is_exist) {
			if ($overwrite && $this->Delete($destination_file)) {
				$is_exist = false;
			}else {
				if (DEBUG) {
					echo 'File '.$destination_file.' is already exists on the server!<br>';
					ob_flush();
					flush();
				}
				if ( filesize($source_file) != $this->GetFileSize( $destination_file )) {
					if (DEBUG) {
						echo 'Filesize of '.$source_file.' and '.$destination_file.' are not equal, so it will be uploaded again!<br>';
						ob_flush();
						flush();
					}
					$equal_size = false;
				}else {
					if (DEBUG) {
						echo 'Filesize of '.$source_file.' and '.$destination_file.' are equal!<br>';
						ob_flush();
						flush();
					}
					$success = true;
				}
			}

		}
		if ($is_exist && !$equal_size && $dest_file_parts['basename'] == '.htaccess') {
			if (DEBUG) {
				echo 'File .htaccess not need to be uploaded again, go to another file!<br>';
				ob_flush();
				flush();
			}
			$success = true;
		}
		if (!$is_exist) {
			if (!file_exists($source_file)) {
				if (DEBUG) {
					echo "<font color=\"red\">File $source_file isn't exists!</font><br>";
					ob_flush();
					flush();
				}
				$success = true;
			}else {
				if (!$this->Upload( $destination_file , $source_file , FTP_BINARY )) {
					if (DEBUG) {
						echo "<font color=\"red\">Upload of ".$source_file.' failed!</font> Please, wait for '.SLEEP_SECONDS.' seconds!<br>';
						ob_flush();
						flush();
					}
					sleep(SLEEP_SECONDS);
				}else {
					if (DEBUG) {
						echo 'Successfull Upload of '.$source_file.'<br>';
						ob_flush();
						flush();
					}
					if ( filesize($source_file) != $this->GetFileSize( $destination_file )) {
						if (DEBUG) {
							echo "<font color=\"red\">Filesize of ".$source_file.' and '.$destination_file.' are not equal!</font><br>';
							ob_flush();
							flush();
						}
						if (!$this->Delete( $destination_file )) {
							if (DEBUG) {
								echo "<font color=\"red\">Can't delete '".$destination_file."'!</font><br>";
								ob_flush();
								flush();
							}
						}else {
							if (DEBUG) {
								echo "Successfull deleting of '".$destination_file."'!<br>";
								ob_flush();
								flush();
							}
						}
					}else {
						if (DEBUG) {
							echo 'Filesize of '.$source_file.' and '.$destination_file.' are equal!<br>';
							ob_flush();
							flush();
						}
						$success = true;
					}
				}
			}
		}
		return $success;
	}
	function IsDirExists($dir) {
		$dir_content = $this->GetDirContent('.');
		foreach ($dir_content as $filename) {
			if ($filename == $dir) {
				return true;
			}
		}
		return false;
	}
	function ChangeMod($file_name, $permissions=0755) {
		return ftp_chmod( $this->__connection_id, $permissions, $file_name );
	}
	function PrintWD() {
		return ftp_pwd( $this->__connection_id );
	}
	function CopyDir($path_from, $path_to, $max_time, $server, $user, $password, $subfolder, $archives_arr, $overwrite_files=true) {

		$this->CheckTimeLocate($max_time, $server, $user, $password, $subfolder, $archives_arr);
		if ($path_to != '') {
			$path_to .= '/';
		}
		if ($handle = opendir($path_from)) {
			while (false !== ($file = readdir($handle))) {
				if ($file != '.' && $file != '..') {
					if (is_file($path_from.$file)) {
						$success = false;
						while (!$success) {
							$this->CheckTimeLocate($max_time, $server, $user, $password, $subfolder, $archives_arr);
							$success = $this->UploadFile($path_to.$file, $path_from.$file, $overwrite_files);
								$this->ChangeMod($path_to.$file,0644);
							if ($success) {
								if (!unlink($path_from.$file)) {
									if (DEBUG) {
										echo "Can't delete file '".$path_from.$file."'<br>";
										ob_flush();
										flush();
									}
								}
							}
						}
					}elseif (is_dir($path_from.$file)) {
						$success = false;
						$was_changed = false;
						$dir_exists = false;
						while (!$success) {
							$this->CheckTimeLocate($max_time, $server, $user, $password, $subfolder, $archives_arr);
							if ($path_to!='' && !$was_changed) {
								if (!$this->ChangeDir($path_to)) {
									if (DEBUG) {
										echo "Can't change dir to '".$path_to."'<br>";
										ob_flush();
										flush();
									}
								}else {
									if (DEBUG) {
										echo "Change dir to '".$path_to."'<br>";
										ob_flush();
										flush();
									}
									$was_changed = true;
								}
							}
							if (!$this->IsDirExists($file)) {
								$success = $this->MakeDir($file);
								$this->ChangeMod($file,0755);
								if (!$success) {
									if (DEBUG) {
										echo "<font color='red'>Failed to create directory '".$file."'! Please, wait for ".SLEEP_SECONDS.'</font><br>';
										ob_flush();
										flush();
									}
									sleep(SLEEP_SECONDS);
								}
							}else {
								$success = true;
								if (DEBUG) {
									echo "Directory '".$file."' is already exists, so content of the directory from archive will be added to it!<br>";
									ob_flush();
									flush();
								}
							}
						}
						$this->CopyDir($path_from.$file.'/', $file, $max_time, $server, $user, $password, $subfolder, $archives_arr);
						if (DEBUG) {
							echo 'Working dir '.$this->PrintWD().'<br>';
							ob_flush();
							flush();
						}
						if ($path_to != '') {
							$this->CdUp();
						}
						if (!rmdir($path_from.$file)) {
							if (DEBUG) {
								echo "Can't delete directory '".$path_from.$file."'<br>";
								ob_flush();
								flush();
							}
						}
					}
				}
			}
			closedir($handle);
		}
	}
	function CheckTimeLocate($max_time, $server, $user, $password, $subfolder, $archives_arr) {
		list($usec, $sec) = explode(' ', microtime());
		$cur_time = $usec + $sec;
		$add_sec = 10;
		if ($cur_time+$add_sec >= $max_time) {
			$arch_str = '';
			foreach ($archives_arr as $key=>$value) {
				$arch_str .= '&extr_'.$value['key'].'='.$value['name'];
			}
			if (!headers_sent()) {
				header('Location: extr_targz.php?submit=submit&upload=true'.$arch_str."&server=$server&user=$user&password=$password&subfolder=$subfolder");
			}else {
				echo '<br><b>Time of the script executing is more, than max execution time! Please, click on to the link to continue executing!<b><br><br>';
				echo "<a href='extr_targz.php?submit=submit&upload=true".$arch_str."&server=$server&user=$user&password=$password&subfolder=$subfolder'>extr_targz.php?submit=submit&upload=true&server=$server&user=$user&password=$password&subfolder=$subfolder</a>";
				die();
			}
		}
	}
	function DeleteDirNoFTP($path) {
		if ($handle = opendir($path)) {
			while (false !== ($file = readdir($handle))) {
				if ($file != '.' && $file != '..') {
					if (is_file($path.$file)) {
						if (!unlink($path.$file)) {
							if (DEBUG) {
								echo "<font color='red'>Failed to delete file '".$path.$file."'</font>!<br>";
								ob_flush();
								flush();
							}
						}
					}elseif (is_dir($path.$file)) {
						delete_dir($path.$file.'/');
					}
				}
			}
			closedir($handle);
			if (!rmdir($path)) {
				if (DEBUG) {
					echo "<font color='red'>Failed to delete directory '".$path."'</font>!<br>";
					ob_flush();
					flush();
				}
			}
		}
	}
}
?>