<?php

/**
 * Authorizenet payment system functions
 *
 * @package DatingPro
 * @subpackage Payment systems files
 * */
//redirect on this place after user click button "Pay". use in payment.php
function MakePayment($billing_system, $amount, $currency, $id_trunzaction, $product_name, $product_id) {
    global $dbconn, $config;

    $settings_manager = new SettingsManager();
    $currency = $settings_manager->GetSiteSettings("site_unit_costunit");

    $rs_sys = $dbconn->Execute("SELECT products_settings FROM " . BILLING_SYS_ . $billing_system);
    $payGear = new Payment_Engine(PAYMENT_ENGINE_SEND, false, false);
    $PaySystem = $payGear->factory($billing_system);
    $time = time();
    $products_settings = unserialize($rs_sys->fields[0]);
    $pay_data = array(
        'PRODS' => isset($products_settings[$product_id]) ? $products_settings[$product_id] : '',
        'REF' => $id_trunzaction,
        'REFNOEXT' => $id_trunzaction,
        'SHOPURL' => urlencode($config["server"] . "/payment.php"),
        'CURRENCY' => $currency,
        'DCURRENCY' => $currency,
        'QTY' => 1,
        'LANG' => $config['lang_code'],
        'CLEAN_CART' => 1,
        'CART' => 1,
        'pay_form' => "PAYMENT_FORM"
    );
    $PaySystem->setFrom($pay_data);
    $PaySystem->doPayment();
}

//get paysystem request values. use in include/payment_request.php
function RequestPayment($billing_system, $__REQUEST) {
    $payGear = new Payment_Engine(PAYMENT_ENGINE_RECEIVE, false, false);
    $PaySystem = $payGear->factory($billing_system);
    $pay_data = array(
        'count' => $__REQUEST[$PaySystem->_arrayField['QTY']],
        'currency' => $__REQUEST[$PaySystem->_arrayField['CURRENCY']],
        'date' => date("Y-m-d H:i:s"),
        'status' => ($PaySystem->checkPayment()) ? 1 : 0,
        'id_req' => $__REQUEST[$PaySystem->_arrayField['REFNOEXT']],
        'quantity' => 1
    );
	if ($pay_data['count'] > 0) {
		return $pay_data;
	} else {
		$pay_data['count'] = 1;
		return $pay_data;
	}
}

//get paysystem settings. use in admin/admin_payment.php
function getBillingData($billing_system) {
    global $dbconn, $smarty, $lang;
    $rs = $dbconn->Execute("Select p.used, bs.products_settings FROM " . BILLING_PAYSYSTEMS_TABLE . " p, " . BILLING_SYS_ . $billing_system . " bs where p.template_name='" . $billing_system . "'");
    $data["use"] = $rs->fields[0];
    $data["products_settings"] = unserialize($rs->fields[1]);
    $smarty->assign("header", $lang["pays"]);
    $smarty->assign("data", $data);
    $data["table_options"] = $smarty->fetch(SYSTEMS_DIR . "templates/" . $billing_system . ".tpl");
    return $data;
}

//set(change) paysystem settings. use in admin/admin_payment.php
function setBillingData($billing_system, $__POST) {
    global $dbconn, $lang;
    $products = isset($__POST['avangate_products']) ? serialize($__POST['avangate_products']) : '';

    //$value = strval($__POST["value"]);
    //$trans_key = strval($__POST["trans_key"]);
    $use = intval($__POST["use"]);
    $err = 0;
    if ($use == 1 && (!$products)) {
        $err = $lang["err"]["invalid_feilds"];
        //if(!$value) $err .= "<br>".$lang["pays"]["authorizenet_seller_id"];
        //if(!$trans_key) $err .= "<br>".$lang["pays"]["authorizenet_key"];
    } else {
        $strSQL = "Update " . BILLING_SYS_ . $billing_system . " set products_settings='" . $products . "'";
        $dbconn->Execute($strSQL);
    }

    $strSQL = "Update " . BILLING_PAYSYSTEMS_TABLE . " set used='" . $use . "' where template_name='" . $billing_system . "'";
    $dbconn->Execute($strSQL);

    return $err;
}

function hmac($key, $data) {
    $b = 64; // byte length for md5
    if (strlen($key) > $b) {
        $key = pack("H*", md5($key));
    }
    $key = str_pad($key, $b, chr(0x00));
    $ipad = str_pad('', $b, chr(0x36));
    $opad = str_pad('', $b, chr(0x5c));
    $k_ipad = $key ^ $ipad;
    $k_opad = $key ^ $opad;
    return md5($k_opad . pack("H*", md5($k_ipad . $data)));
}

?>