<?php

/**
 * User payment page (groups selection, groups descriptions, sends payment data to a payment system)
 *
 * @package Newsletter
 * */
include "./include/config.php";
include "./include/common_functions.php";
include "./include/functions_auth.php";
include "./common.php";
include "./include/config.inc.php";

login_cheeck($auth);

$file_name = $config["server"] . "/payment.php";
@$sel = $_POST["sel"] ? $_POST["sel"] : $_GET["sel"];
switch ($sel) {
    case "save_1": SavePage1();
        break;
    case "save_2": SavePage2();
        break;
    case "viewrate": ViewRate($sel);
        break;
    default: ViewRate();
}

function ViewRate($par = "") {
	global $lang, $config, $smarty, $dbconn, $file_name;

	AdminMainMenu("payment");

	///// settings
	$settings_manager = new SettingsManager();
	$form["currency"] = $settings_manager->GetSiteSettings("site_unit_costunit");

	$strSQL = "SELECT a.*, b.name AS group_name FROM " . GROUP_PERIOD_TABLE . " AS a, " . GROUPS_TABLE . " AS b WHERE a.status=1 AND b.id=a.id_group AND b.type='f' ORDER BY a.date";
	$rs = $dbconn->Execute($strSQL);
	while (!$rs->EOF) {
		$row = $rs->GetRowAssoc(false);
		$i = $row["id"];
		$data[$i]["id"] = $row["id"];
		$data[$i]["type"] = $row["type"];
		if ($data[$i]["type"] == "3") {
			$tmp_amount = explode("|", $row["amount"]);
			$tmp_period = explode("|", $row["period"]);
			$data[$i]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
			$data[$i]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
		} else {
			$data[$i]["period"] = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]];
		}
		$data[$i]["cost"] = $row["cost"] . " " . $form["currency"];
		$data[$i]["group_name"] = $row["group_name"];
		$data[$i]["pay_link"] = $file_name . "?sel=save_1&period_id=" . $data[$i]["id"];

		$rs->MoveNext();
	}
	if ($par)
		$smarty->assign("view", 1);
	$smarty->assign("data", $data);

	// Compare

	$strSQL = " SELECT id, name, type FROM " . GROUPS_TABLE . " WHERE id NOT IN (1,2) ORDER BY name";

	$rs = $dbconn->Execute($strSQL);
	$i = 0;

	$group_arr = array();
	$modules_arr = array();
	$functions_arr = array();
	$functions_checked = array();
	$checkboxes = array();

	$amount = $rs->RowCount();

	if ($amount > 0) {
		while (!$rs->EOF) {
			$group_arr[$rs->fields[0]]["id"] = $rs->fields[0];
			$group_arr[$rs->fields[0]]["type"] = $rs->fields[2];
			$group_arr[$rs->fields[0]]["name"] = strval($rs->fields[1]);
			$checkboxes[$rs->fields[0]] = $rs->fields[0];
			$rs->MoveNext();
		}
		ArrStripSlashes($group_arr);
		get_smarty_array_list("group_page", $config["group_page"]);
		$smarty->assign("amount", $amount);
	} else {
		$smarty->assign("empty_row", "1");
		$smarty->assign("amount", 0);
	}

	$smarty->assign("column_width", 100 / ($amount + 1));
	$periods = array();
	foreach ($group_arr as $group_id => $group) {
		$id = $group['id'];
		$group_arr[$id]['modules'] = array();
		$group_arr[$id]['functions'] = array();
		if ($id) {
			// Modules
			$rs = $dbconn->Execute("SELECT gm.id_module, m.name FROM " . GROUP_MODULE_TABLE . " as gm LEFT JOIN " . MODULES_TABLE . " as m ON m.id=gm.id_module WHERE gm.id_group={$id}");
			while (!$rs->EOF) {
				$module_id = $rs->fields[0];
				$modules_arr[$module_id] = $rs->fields[1];
				$group_arr[$id]['modules'][$module_id] = $rs->fields[1];
				$checkboxes[$id] = isset($checkboxes[$id]) ? $checkboxes[$id] + 1 : 1;
				// Functions
				$functions_arr[$module_id] = !isset($functions_arr[$module_id]) ? array() : $functions_arr[$module_id];
				$strSQL = "SELECT DISTINCT f.id, f.name FROM " . GROUP_FUNCTION_TABLE . " as gf LEFT JOIN " . FUNCTIONS_TABLE . " as f ON f.id=gf.id_function WHERE gf.id_group={$id} AND f.id_module={$module_id} ORDER BY f.id";
				$func_rs = $dbconn->Execute($strSQL);
				while (!$func_rs->EOF) {
					$func_id = $func_rs->fields[0];
					$func_name = $func_rs->fields[1];
					$group_arr[$id]['functions'][$module_id][$func_id] = $func_name;
					$functions_arr[$module_id][$func_id] = $func_name;
					$functions_checked[$func_id] = isset($functions_checked[$func_id]) ? $functions_checked[$func_id] + 1 : 1;
					$checkboxes[$id] = isset($checkboxes[$id]) ? $checkboxes[$id] + 1 : 1;
					$func_rs->MoveNext();
				}
				$rs->MoveNext();
			}

			// Periods
			$data = array();
			$settings_manager = new SettingsManager();
			$form["currency"] = $settings_manager->GetSiteSettings("site_unit_costunit");

			$strSQL = "SELECT a.*, b.name AS group_name FROM " . GROUP_PERIOD_TABLE . " AS a, " . GROUPS_TABLE . " AS b WHERE a.status=1 AND b.id=a.id_group AND b.type='f' AND b.id = {$group_id} ORDER BY a.date";
			$rs = $dbconn->Execute($strSQL);
			while (!$rs->EOF) {
				$row = $rs->GetRowAssoc(false);
				$i = $row["id"];
				$data[$i]["id"] = $row["id"];
				$data[$i]["type"] = $row["type"];
				if ($data[$i]["type"] == "3") {
					$tmp_amount = explode("|", $row["amount"]);
					$tmp_period = explode("|", $row["period"]);
					$data[$i]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
					$data[$i]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
				} else {
					$data[$i]["period"] = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]];
				}
				$data[$i]["cost"] = $row["cost"] . " " . $form["currency"];
				$data[$i]["group_name"] = $row["group_name"];
				$data[$i]["pay_link"] = $file_name . "?sel=save_1&period_id=" . $data[$i]["id"];

				$rs->MoveNext();
			}
			$periods[$id] = $data;
		}
	}

	$smarty->assign("periods", $periods);

	$module_functions_show = array();
	foreach ($group_arr as $group_id => $group) {
		foreach ($group_arr[$group_id]['functions'] as $module_id => $functions)
			if (count($functions) != count($functions_arr[$module_id]) && count($functions) != 0)
				$module_functions_show[$module_id] = $module_id;
	}

	ksort($modules_arr);
	asort($checkboxes);

	$new_group_arr = array();
	foreach ($checkboxes as $checkbox_id => $checkbox_value)
		$new_group_arr[$checkbox_id] = $group_arr[$checkbox_id];
	$group_arr = $new_group_arr;

	$smarty->assign("group_arr", $group_arr);
	$smarty->assign("modules_arr", $modules_arr);
	$smarty->assign("functions_arr", $functions_arr);
	$smarty->assign("functions_checked", $functions_checked);
	$smarty->assign("module_functions_show", $module_functions_show);

	$smarty->display($config["admin_nl_gentemplates"] . "/payment_view_rate.tpl");
	exit;
}

function PaymentPage1($err = "") {
    global $lang, $config, $smarty, $dbconn, $auth, $file_name;

    if ($err)
        $form["err"] = $err;

    AdminMainMenu("payment");

    ///// settings
    $settings_manager = new SettingsManager();
    $settings = $settings_manager->GetSiteSettings(array("site_unit_costunit"));

    $data["account_currency"] = $settings["site_unit_costunit"];

    if (isset($_POST["group"])) {
        $id_group = intval($_POST["group"]);
        $strSQL = "SELECT id, name FROM " . GROUPS_TABLE . " WHERE id={$id_group}";
        $rs = $dbconn->Execute($strSQL);
        $user_group = $rs->fields[0];
        $data["present_group"] = $rs->fields[1];
        $data["selected_name"] = $rs->fields[1];
        $data["speed"] = $rs->fields[2] ? $rs->fields[2] : $lang["payment"]["free"];
    } else {
        //// user group
        $strSQL = "SELECT id, name FROM " . GROUPS_TABLE . " WHERE type='f'";
        $rs = $dbconn->Execute($strSQL);
        $user_group = $rs->fields[0];
        $data["present_group"] = $rs->fields[1];
        $data["selected_name"] = $rs->fields[1];
        $data["speed"] = $rs->fields[2] ? $rs->fields[2] : $lang["payment"]["free"];
    }
    $selected_group = !$id_group ? $user_group : $id_group;
    ///// group select

    $strSQL = "SELECT a.id, a.name FROM " . GROUPS_TABLE . " a, " . GROUP_PERIOD_TABLE . " b WHERE a.type='f' AND b.id_group=a.id AND b.status='1' GROUP BY a.id";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $row = $rs->GetRowAssoc(false);
        $groups[$i]["name"] = $row["name"];
        $groups[$i]["id"] = $row["id"];
        $groups[$i]["sel"] = $row["id"] == $selected_group ? "1" : "";
        if ($row["id"] == $selected_group) {
            $data["selected_name"] = $row["name"];
        }
        $rs->MoveNext();
        $i++;
    }
    $smarty->assign("groups", $groups);

    if ($selected_group) {
        $strSQL = "SELECT a.id, a.name FROM " . MODULES_TABLE . " a, " . GROUP_MODULE_TABLE . " b WHERE b.id_group={$selected_group} AND b.id_module=a.id ORDER BY name";
        $rs = $dbconn->Execute($strSQL);
        $i = 0;
        while (!$rs->EOF) {
            $row = $rs->GetRowAssoc(false);
            $description[$i]["name"] = $lang["modules"][$row["name"]]["name"];
            $description[$i]["descr"] = $lang["modules"][$row["name"]]["comment"];
            /////// Functions modules
            $strSQL = "SELECT id, name FROM " . FUNCTIONS_TABLE . " WHERE id_module={$row["id"]} ORDER BY id";
            $func = $dbconn->Execute($strSQL);
            $j = 0;
            while (!$func->EOF) {
                $description[$i]["functions"][$j]["id"] = $func->fields[0];
                $description[$i]["functions"][$j]["name"] = $lang["functions"][$func->fields[1]]["name"];
                $description[$i]["functions"][$j]["comment"] = $lang["functions"][$func->fields[1]]["comment"];
                $func->MoveNext();
                $j++;
            }
            /////////////////////////
            $rs->MoveNext();
            $i++;
        }
        $smarty->assign("description", $description);
        $j = 0;
        $rs = $dbconn->Execute("SELECT b.period FROM " . BILLING_USER_PERIOD_TABLE . " a LEFT JOIN " . GROUP_PERIOD_TABLE . " b ON  b.id=a.id_group_period WHERE a.id_user={$auth["id"]}");
        if ($rs->fields[0] == "emails") {
            $where = " AND period = 'emails'";
        } elseif (in_array($rs->fields[0], array('day', 'week', 'month', 'year'))) {
            $where = " AND period IN ('day','week','month','year')";
        } elseif (!isset($rs->fields[0]) || empty($rs->fields[0])) {
            $where = "";
        }
        $strSQL = "SELECT id, cost, period, amount, type FROM " . GROUP_PERIOD_TABLE . " WHERE id_group={$selected_group} AND status='1' {$where} ORDER BY id";
        $rs_p = $dbconn->Execute($strSQL);
        while (!$rs_p->EOF) {
            $row_p = $rs_p->GetRowAssoc(false);
            $cost_group[$j]["id"] = $row_p["id"];
            $cost_group[$j]["amount"] = $row_p["amount"];
            $cost_group[$j]["type"] = $row["type"];
            if ($cost_group[$j]["type"] == "3") {
                $tmp_amount = explode("|", $row_p["amount"]);
                $tmp_period = explode("|", $row_p["period"]);
                $cost_group[$j]["period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
                $cost_group[$j]["period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
            } else {
                $cost_group[$j]["period"] = $row_p["amount"] . " " . $lang["pays"]["periods"][$row_p["period"]];
            }
            //$cost_group[$j]["period"] = $lang["pays"]["periods"][$row_p["period"]];
            $cost_group[$j]["cost"] = $row_p["cost"];
            $rs_p->MoveNext();
            $j++;
        }
        $smarty->assign("cost_group", $cost_group);

        /* 		$strSQL = " SELECT DISTINCT p.id, p.permission_name, gp.id, gp.permission_count
          FROM ".PERMISSIONS_TABLE." p
          INNER JOIN ".GROUPS_PERMISSIONS_TABLE." gp ON (gp.id_permission=p.id AND gp.id_group={$selected_group})
          WHERE 1
          GROUP BY p.id ORDER BY p.id";
          $rs = $dbconn->Execute($strSQL);
          $i = 0;
          while(!$rs->EOF){
          $add_descr[$i]["name"] = $lang["permission"][$rs->fields[1]]["name"];
          $add_descr[$i]["descr"] = $lang["permission"][$rs->fields[1]]["comment"];
          $add_descr[$i]["count"] = $rs->fields[3];
          $rs->MoveNext();
          $i++;
          }
          $smarty->assign("add_descr", $add_descr); */
    }

    $form["action"] = $file_name;
    $form["hiddens"] = "<input type='hidden' name='sel' value='save_1'>";
    $form["hiddens"] .= "<input type='hidden' name='period_id' value=\"\">";
    $form["err"] = $err;
    $smarty->assign("form", $form);
    $smarty->assign("data", $data);
    $smarty->display($config["admin_nl_gentemplates"] . "/payment_page_1.tpl");
    exit;
}

function PaymentPage2($err = "") {
    global $lang, $config, $smarty, $dbconn, $auth, $file_name;

    if ($err)
        $form["err"] = $err;

    AdminMainMenu("payment");

    ///// settings
    $settings_manager = new SettingsManager();
    $settings = $settings_manager->GetSiteSettings(array("site_unit_costunit"));
    $data["account_currency"] = $settings["site_unit_costunit"];

    ///// chosen group
    if (!$_POST["period_id"]) {
        PaymentPage1();
        return;
    }

    $strSQL = "SELECT a.name, a.id, b.cost, b.amount, b.period, b.type FROM " . GROUP_PERIOD_TABLE . " AS b
						LEFT JOIN " . GROUPS_TABLE . " AS a ON a.id=b.id_group
					WHERE b.id=" . intval($_POST["period_id"]);
    $rs = $dbconn->Execute($strSQL);
    $data["chosen_group"] = $rs->fields[0] ? $rs->fields[0] : "";
    $group = $rs->fields[1];
    if (!$group)
        header("Location: error.php?code=404");
    if ($rs->fields[5] == "3") {
        $tmp_amount = explode("|", $rs->fields[3]);
        $tmp_period = explode("|", $rs->fields[4]);
        $data["chosen_period"] = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
        $data["chosen_period"] .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]];
    } else {
        $data["chosen_period"] = $rs->fields[3] . " " . $lang["pays"]["periods"][$rs->fields[4]];
    }
    //$data["chosen_period"] = $rs->fields[3]." ".$lang["pays"]["periods"][$rs->fields[4]];
    $data["chosen_cost"] = $rs->fields[2];
    $data["chosen_forpay"] = $rs->fields[2];
    if ($data["chosen_forpay"] <= 0)
        $data["chosen_forpay"] = 0;     // if old account more then new then change group only without payment process

    $form["hiddens"] = "<input type=hidden name='sel' value='save_2'>";
    $form["hiddens"] .= "<input type=hidden name='group' value='{$group}'>";
    $form["hiddens"] .= "<input type=hidden name='currency' value='{$data["chosen_forpay"]}'>";
    $form["hiddens"] .= "<input type=hidden name='period_id' value='" . intval($_POST["period_id"]) . "'>";
    $form["hiddens"] .= "<input type=hidden name='pay' value=''>";
    $form["hiddens"] .= "<input type=hidden name='paysys' id='paysys' value=''>";

    $form["action"] = $file_name;
    $form["costunits"] = $settings["site_unit_costunit"];
    $form["err"] = $err;

    $strSQL = "SELECT name, template_name FROM " . BILLING_PAYSYSTEMS_TABLE . " WHERE used='1'";
    $rs = $dbconn->Execute($strSQL);
    $i = 0;
    while (!$rs->EOF) {
        $paysys[$i]["name"] = $rs->fields[0];
        $paysys[$i]["template_name"] = $rs->fields[1];
        $rs->MoveNext();
        $i++;
    }

    $current_lang_id = $config["default_lang"];
    $strSQL = "SELECT information FROM " . BILLING_SYS_ . "manual WHERE name='manual' AND lang_id = {$current_lang_id}";
    $rs = $dbconn->Execute($strSQL);
    $smarty->assign("payment_information", $rs->fields[0]);

    $smarty->assign("paysys", $paysys);
    $smarty->assign("form", $form);
    $smarty->assign("jquery", 1);
    $smarty->assign("data", $data);
    $smarty->display($config["admin_nl_gentemplates"] . "/payment_page_2.tpl");
    exit;
}

function SavePage1() {
    global $lang, $config, $smarty, $dbconn, $auth;

    $id = intval($auth["id"]);
    $period_id = isset($_POST["period_id"]) ? intval($_POST["period_id"]) : intval($_GET["period_id"]);
    if (!isset($_POST["group"])) {
        $_POST["group"] = @$_GET["group"];
    }
    if (!isset($_POST["period_id"])) {
        $_POST["period_id"] = $period_id;
    }

    if ($id == 2) {
        echo "<script>location.href='{$config["server"]}/registration.php?period_id={$period_id}'</script>";
        exit;
    } elseif (!in_array($id, array(1, 2)) && $period_id != 0) {
        PaymentPage2();
        exit;
    } elseif (!in_array($id, array(1, 2)) && $period_id == 0) {
        PaymentPage1();
        exit;
    } elseif ($id == 1 && $period_id != 0) {
        PaymentPage2();
        exit;
    }
}

function SavePage2() {
    global $lang, $config, $smarty, $dbconn, $auth;

    ArrAddSlashes($_POST);
    $group = intval($_POST["group"]);
    $amount = FormFilter($_POST["currency"]);
    $period_id = intval($_POST["period_id"]);
	
    $settings_manager = new SettingsManager();
    $settings = $settings_manager->GetSiteSettings(array("site_unit_costunit", "from_email"));
    $from_email = GetUserSettings(array("from_email"), 1);
    $strSQL = "SELECT b.fractional_unit, b.abbr FROM " . SETTINGS_TABLE . " a, " . UNITS_TABLE . " b  WHERE a.name='site_unit_costunit' AND a.value=b.abbr";
    $rs = $dbconn->Execute($strSQL);
    $currency_settings["fractional_unit"] = $rs->fields[0];
    $currency_settings["abbr"] = $rs->fields[1];
    $id = intval($auth["id"]);

    $paysys = $_POST["paysys"];

    $strSQL = "SELECT a.id, a.cost, a.period, a.amount, a.type, b.name AS groupname FROM " . GROUP_PERIOD_TABLE . " AS a LEFT JOIN " . GROUPS_TABLE . " AS b ON a.id_group=b.id WHERE a.id={$period_id} ORDER BY b.name";
    $rs = $dbconn->Execute($strSQL);
    $row = $rs->GetRowAssoc(false);
    if ($row["type"] == "3") {
        $tmp_amount = explode("|", $row["amount"]);
        $tmp_period = explode("|", $row["period"]);
        $product_name = $tmp_amount[0] . " " . $lang["pays"]["periods"][$tmp_period[0]] . ", ";
        $product_name .= $tmp_amount[1] . " " . $lang["pays"]["periods"][$tmp_period[1]] . " ({$row["groupname"]})";
    } else {
        $product_name = $row["amount"] . " " . $lang["pays"]["periods"][$row["period"]] . " ({$row["groupname"]})";
    }

    if ($paysys == 'ccbill') {
        $strSQL = " SELECT cost FROM " . GROUP_PERIOD_TABLE . " WHERE id={$period_id}";
        $rs = $dbconn->Execute($strSQL);
        $dbconn->Execute("INSERT INTO " . BILLING_REQUESTS_TABLE . " (id_user, id_product, count_curr,currency, date_send, status, paysystem,user_info) VALUES ({$id}, {$rs->fields[0]}, {$amount}, '{$currency_settings["abbr"]}','" . date('Y-m-d H:i:s', time()) . "','send','{$paysys}','')");
    } else {
        $details = '';
        if ($paysys == 'manual') {
            $details = strip_tags($_POST["pay_data"]);
        }
        $dbconn->Execute("INSERT INTO " . BILLING_REQUESTS_TABLE . " (id_user, id_product, count_curr,currency, date_send, status, paysystem,user_info) VALUES ({$id}, {$period_id}, {$amount}, '{$currency_settings["abbr"]}','" . date('Y-m-d H:i:s', time()) . "','send','{$paysys}','{$details}')");
    }

    $rs = $dbconn->Execute("SELECT MAX(id) FROM " . BILLING_REQUESTS_TABLE . " WHERE id_user={$id}");
    $id_trunzaction = $rs->fields[0];

    switch ($paysys) {
        case "allopass":
            include_once "./include/systems/functions/allopass.php";

            $file_name = (isset($_SERVER["PHP_SELF"])) ? AfterLastSlash($_SERVER["PHP_SELF"]) : "payment.php";
            ShowCodePage($id_trunzaction, $period_id);
            if (GetAlertStatus("mail_payment_by_admin")) {
                // Alert adminu o platezhe
                $data_ = array();
                $data_["site_name"] = $config["server"];
                $data_["name"] = GetUserName(1);
                $data_["customer_name"] = GetUserName($id);
                $data_["service_name"] = GetServiceName($period_id);
                SendAlert("mail_payment_by_admin", $data_, $from_email["from_email"], $data_["name"], $id);
            }
            break;
        case "manual":
            // send mail
            $strSQL = " SELECT fname, sname,email FROM " . USERS_TABLE . " WHERE id={$id}";
            $rs = $dbconn->Execute($strSQL);
            if (GetAlertStatus("mail_manualpayment_by_admin")) {
                // Alert adminu o platezhe
                $data_ = array();
                $data_["name"] = GetUserName(1);
                $data_["payment_details"] = $details;
                SendAlert("mail_manualpayment_by_admin", $data_, $from_email["from_email"], $data_["name"], $id);
            }
            $smarty->assign("data", $lang["alert"]["manual_pays"]);
            $smarty->display($config["admin_nl_gentemplates"] . "/alert.tpl");
            exit;
        default:
            include_once "./include/systems/functions/" . $paysys . ".php";

            MakePayment($paysys, $amount, $currency_settings["abbr"], $id_trunzaction, $product_name, $period_id);
            if (GetAlertStatus("mail_payment_by_admin")) {
                // Alert adminu o platezhe
                $data_ = array();
                $data_["site_name"] = $config["server"];
                $data_["name"] = GetUserName(1);
                $data_["customer_name"] = GetUserName($id);
                $data_["service_name"] = GetServiceName($period_id);
                SendAlert("mail_payment_by_admin", $data_, $from_email["from_email"], $data_["name"], $id);
            }
            break;
    }
    return;
}

?>