<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\BookCategoryRequest;
use App\Models\BookCategory;
use Illuminate\Http\Request;

class BookCategoryController extends AdminController
{
    public function __construct(BookCategory $model)
    {
        parent::__construct();
        $this->model = $model;

        view()->share([

        ]);

    }
    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)
                ->editColumn('title', function ($data) {
                    return $data->title ? '<a href="' . route($this->module_name . '.show', $data->id) . '">' . $data->title . '</a>' : '';
                })
                ->addColumn('add_book',function ($data){
                    return view($this->components_view. '.Books.add_counts_books',compact('data')) ;
                })
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['title','add_book','actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }

    public function store(BookCategoryRequest $request)
    {
        $data = $request->all();
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }
    public function update(BookCategoryRequest $request, BookCategory $book_cat)
    {
        $data = $request->all();
        $data['updated_by'] = 1;
        $update = $book_cat->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
