<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\EditionRequest;
use App\Models\Edition;
use App\Models\EditionCategory;
use Illuminate\Http\Request;

class EditionController extends AdminController
{
    public function __construct(Edition $model)
    {
        parent::__construct();
        $this->model = $model;
        $this->model = $model;
        $this->image_width = 300;
        $this->image_height = 400;
        $this->image_ratio = '3/4';
        $this->module_actions = ['delete','create','active','edit','is_new'];


        $edition_categories = EditionCategory::all();
        $edition_category = request()->has('edition_category_id') ? EditionCategory::find(request('edition_category_id')) : false;
        view()->share([

            'uploads_folder' => $this->uploads_folder,
            'image_width' => $this->image_width,
            'image_height' => $this->image_height,
            'image_ratio' => $this->image_ratio,
            'edition_categories' => $edition_categories,
            'edition_category' => $edition_category,

        ]);

    }
    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }]) ;
        $all_items = $this->model->orderByRaw('-item_order DESC')->with('createdBy');

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)
                ->editColumn('title', function ($data) {
                    return $data->title ? '<a href="' . route($this->module_name . '.show', $data->id) . '">' . $data->title . '</a>' : '';
                })
                ->editColumn('image', function ($data) {
                    return $data->image ? '<img src="' . $data->image_thumb_path . '" class="img-thumbnail" style="width: 50px">' : '<i class="fa fa-image no-img" >';
                })
                ->editColumn('edition_category_id', function ($data) {
                    return  $data->editionCategory ? $data->editionCategory->title :' - ' ;
                })
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->filterColumn('title', function($query, $keyword) {
                    $query->whereHas('translations', function($query) use ($keyword) {
                        $sql = "edition_translations.title  like ?";
                        $query->whereRaw($sql, ["%{$keyword}%"]);
                    });})
                ->filterColumn('edition_category_id', function($query, $keyword) {
                    $query->whereHas('editionCategory.translations', function($query) use ($keyword) {
                        $sql = "edition_category_translations.title  like ?";
                        $query->whereRaw($sql, ["%{$keyword}%"]);
                    });})
                ->rawColumns(['title','image','edition_category_id','actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }
    public function create()
    {
        $this->method_view = $this->admin_view.'.'.$this->module_name.'.form';

        if(\Request::has('edition_category_id'))
        {
            $edition_category_id = Request('edition_category_id');
            $edition_category = EditionCategory::find($edition_category_id);
            return view($this->method_view , compact('edition_category'));
        }
        else{
            $edition_categories = EditionCategory::all();
            return view($this->method_view , compact('edition_categories'));
        }
    }
    public function store(EditionRequest $request)
    {
        $image = $request['image'] ?? null;
        $data = $request->all();
        $img_name = $this->upload_crop_image(null, $request->image);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }

    public function update(EditionRequest $request, Edition $edition)
    {
        $data = $request->all();
        $img_name = $this->upload_crop_image($edition);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['updated_by'] = 1;
        $update = $edition->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
