<?php

namespace App\Http\Controllers\Admin;


use App\Http\Requests\NavMenuRequest;
use App\Models\NavMenu;
use Illuminate\Http\Request;

class NavMenuController extends AdminController
{
    public function __construct(NavMenu $model)
    {
        parent::__construct();
        $this->model = $model;

        $this->image_width = 1500;
        $this->image_height = 250;
        $this->image_ratio = '6/1';
        $this->module_actions= ['edit','active'];
        view()->share([

            'uploads_folder' => $this->uploads_folder,
            'image_width' => $this->image_width,
            'image_height' => $this->image_height,
            'image_ratio' => $this->image_ratio,

        ]);
    }

    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();
        $items = request()->has('trashed') ? $deleted_items : $all_items;
        if (request()->ajax()) {
            return datatables()->of($items)
                ->addColumn('image', function ($data) {
                    return $data->image ? '<img src="' . $data->image_thumb_path . '" class="img-thumbnail" style="width: 50px">' : '<i class="fa fa-image no-img" >';
                })
                ->addColumn('order_form', $this->components_view . '.order_form')
                ->addColumn('items_num',function ($data){
                    return count($data->navMenuItems) ;
                } )
                ->addColumn('add_item',function ($data){
                  return view($this->components_view. '.NavMenus.add_nav_menu_item',compact('data')) ;
                })
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['image','items_num','add_item','order_form', 'actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }



    public function update(NavMenuRequest $request, NavMenu $nav_menu)
    {
        $data = $request->all();
        $img_name = $this->upload_crop_image($nav_menu);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['updated_by'] = 1;
        $update = $nav_menu->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
