<?php

namespace App\Http\Controllers\FrontEnd;


use App\Models\Book;
use App\Models\BookCategory;

class BookController extends FrontEndController
{


    public function __construct(Book $model)
    {
        parent::__construct($model);
    }


    public function show($id)
    {

        $item = $this->model->findOrFail($id);
        return view($this->method_view, compact('item'));

    }

    public function view($id)
    {
        $books_category = BookCategory::Find($id);

        $all_books= BookCategory::Find($id)->books()->paginate(6);

        return view('front_end.books.view', compact('books_category','all_books'));

    }

}
