<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\Activity;
use App\Models\AdministrativeBodies;
use App\Models\Bar;
use App\Models\BookActivity;
use App\Models\BookCategory;
use App\Models\Box;
use App\Models\Branch;
use App\Models\BranchNew;
use App\Models\Circulars;
use App\Models\Contact;
use App\Models\Deed;
use App\Models\Edition;
use App\Models\EditionCategory;
use App\Models\Event;
use App\Models\Founder;
use App\Models\FriendSite;
use App\Models\LastEdition;
use App\Models\LastMeeting;
use App\Models\LastNew;
use App\Models\Major;
use App\Models\Member;
use App\Models\Menu;
use App\Models\NavMenu;
use App\Models\OpeningWord;
use App\Models\PensionFound;
use App\Models\PublishingCondition;
use App\Models\Setting;
use App\Models\Slider;
use App\Models\SocialMedia;
use App\Models\Staff;
use App\Models\UnionSpecial;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class FrontEndController extends Controller
{
    protected $model;
    protected $controller_name;
    protected $module_name;
    protected $module_title;
    protected $method_name;
    protected $method_title;
    protected $admin_view = 'front_end';
    protected $method_view;
    protected $asset_version = 1.6;
    //  protected $index_route;


    public function __construct(Model $model = null)
    {
        app()->setLocale('ar');
        $this->model = $model;
        $this->controller_name = $this->getControllerName();
        $this->module_name = Str::snake(Str::plural($this->controller_name));
        $this->method_name = request()->route()->getActionMethod();
        $this->method_view = $this->admin_view . '.' . $this->module_name . '.' . $this->method_name;


        $this->module_title = trans($this->module_name . '.module_title');
        $this->method_title = $this->method_name == 'index' ? trans($this->module_name . '.module_title') : trans('admin.' . $this->method_name) . ' ' . trans($this->module_name . '.single');
        $sliders = Slider::active()->orderByRaw('-item_order DESC')->get();

        $abouts = About::active()->orderByRaw('-item_order DESC')->get();
        $activities = Activity::active()->orderByRaw('-item_order DESC')->get();
        $pension_founds = PensionFound::active()->orderByRaw('-item_order DESC')->get();
        $circulars = Circulars::active()->orderByRaw('-item_order DESC')->get();
        $events = Event::active()->orderByRaw('-item_order DESC')->get();
        $last_meetings = LastMeeting::active()->orderByRaw('-item_order DESC')->get();
        $book_activities = BookActivity::active()->orderByRaw('-item_order DESC')->get();

        $socials = SocialMedia::active()->where('status', 1)->get();
        $nav_menus = NavMenu::active()->get();
        $boxes = Box::active()->get();
        $bars = Bar::active()->get();
        $book_categories = BookCategory::active()->orderByRaw('-item_order DESC')->get();
        $branches = Branch::active()->orderByRaw('-item_order DESC')->get();
        $branche_news = BranchNew::active()->orderByRaw('-item_order DESC')->get();
        $publishing_conditions = PublishingCondition::active()->orderByRaw('-item_order DESC')->get();
        $editions = Edition::active()->orderByRaw('-item_order DESC')->paginate(3);
        $edition_categories = EditionCategory::active()->orderByRaw('-item_order DESC')->get();
        $last_editions = Edition::active()->new()->orderByRaw('-item_order DESC')->get();

        $last_news = LastNew::active()->new()->orderByRaw('id DESC')->take(6)->get();

        $news = LastNew::active()->orderByRaw('-item_order DESC')->orderBy('id','DESC')->paginate(9);;



        $staff = Staff::active()->orderByRaw('-item_order DESC')->get();
        $administrative_bodies = AdministrativeBodies::active()->orderByRaw('-item_order DESC')->get();
        $friend_sites = FriendSite::active()->orderByRaw('-item_order DESC')->get();
        $union_specials = UnionSpecial::active()->orderByRaw('-item_order DESC')->get();
        $members = Member::active()->orderByRaw('-item_order DESC')->OrderByTranslation('name','ASC')->paginate(12);
        $deeds = Deed::active()->orderByRaw('-item_order DESC')->get();
        $majors = Major::active()->orderByRaw('-item_order DESC')->get();
        $founders = Founder::active()->orderByRaw('-item_order DESC')->get();
        $menus = Menu::active()->orderByRaw('-item_order DESC')->get();

        $contacts = Contact::find(1);
        $generalSetting = Setting::find(1);
        $opening_word = OpeningWord::find(1);
        $home = trans('frontend.home');
        $pageSetting = $this->getMenuByName($this->module_name);
        $subSetting = $this->getNavMenuByName($this->module_name);
        view()->share([
            'module_name' => $this->module_name,
            'module_title' => $this->module_title,
            'method_name' => $this->method_name,
            'method_title' => $this->method_title,
            'asset_version' => $this->asset_version,
            'abouts' => $abouts,
            'activities' => $activities,
            'pension_founds' => $pension_founds,
            'circulars' => $circulars,

            'menus_image' => $menus->where('name', $this->module_name)->first() ?
                                $menus->where('name', $this->module_name)->first()->image_path
                            : ($nav_menus->where('name', $this->module_name)->first() ? $nav_menus->where('name', $this->module_name)->first()->image_path : null ),
            'menus' => $menus,
            'boxes' => $boxes,
            'socials' => $socials,
            'contacts' => $contacts,
            'home' => $home,
            'sliders' => $sliders,
            'generalSetting' => $generalSetting,
            'pageSetting' => $pageSetting,
            'subSetting' => $subSetting,
            'pageTitle' => $pageSetting['title'] ?? $subSetting['title'] ?? $home,
            'nav_menus' => $nav_menus,
            'news' => $news,
            'last_news' => $last_news,
            'book_categories' => $book_categories,
            'editions' => $editions,
            'edition_categories' => $edition_categories,
            'administrative_bodies' => $administrative_bodies,
            'events' => $events,
            'book_activities' => $book_activities,
            'last_meetings' => $last_meetings,

            'last_editions' => $last_editions,
            'branches' => $branches,
            'branche_news' => $branche_news,
            'publishing_conditions' => $publishing_conditions,
            'bars' => $bars,
            'opening_word' => $opening_word,
            'staff' => $staff,
            'members' => $members,
            'deeds' => $deeds,
            'majors' => $majors,
            'founders' => $founders,
            'friend_sites' => $friend_sites,
            'union_specials' => $union_specials,
        ]);
    }

    protected function getControllerName()
    {
        return str_replace('Controller', '', class_basename($this));
    }

    public function getMenuByName($name)
    {
        return Menu::where('name', $name)->get()->first();
    }

 public function getNavMenuByName($name)
    {
        return NavMenu::where('name', $name)->get()->first();
    }


}
