<?php

namespace App\Http\Controllers\Old;

use App\Http\Controllers\Controller;
use App\Models\About;
use App\Models\AdministrativeBodies;
use App\Models\BranchNew;
use App\Models\LastNew;
use App\Models\Member;
use App\OldModels\CategoryDetail;
use App\OldModels\CategoryTitle;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class OldController extends Controller
{
    public function index()
    {
        $category_titles = CategoryTitle::all();
        return $category_titles;

    }

    public function categoryDetails($cat_id)
    {
        $category_title = CategoryTitle::
        with(['sub_titles' => function ($query) {
            $query->with('details');
        }])
            ->find($cat_id);
        return $category_title;
    }

    public function cat($cat_id)
    {

        $category_title = CategoryTitle::
        with(['sub_titles' => function ($query) {
            $query->with('details');
        }])
            ->with(['details' => function ($query) {
                $query->OrderBy('numeric_title', 'ASC');
            }])
            ->find($cat_id);
        return $category_title;
    }

    public function about()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('abouts')->truncate();
        DB::table('about_translations')->truncate();

        $cat_id = 60;
        $category_title = CategoryTitle::
        //with('sub_titles')
        /*with(['sub_titles' => function ($query) {
            $query->with('details');
        }])*/
        with(['sub_titles' => function ($query) {
            $sub_title_ids = [126, 129, 127, 65, 64, 63];
            $query->OrderBy('numeric_cat', 'ASC')
                ->with('details')
                ->whereIn('category_id', $sub_title_ids);
        }])
            ->with('details')
            ->find($cat_id);

        $sub_titles = $category_title->sub_titles;

        foreach ($sub_titles as $index => $sub_title) {

            foreach ($sub_title['details'] as $detail) {

                About::create([

                    'ar' => [
                        'title' => $detail['title[ar]'],
                        'short_description' => $detail['small_title[ar]'],
                        'description' => $detail['full_text[ar]'],
                        'auther' => $detail['auther[ar]'],

                    ],
                    'en' => [
                        'title' => $detail['title[en]'],
                        'short_description' => $detail['small_title[en]'],
                        'description' => $detail['full_text[en]'],
                        'auther' => $detail['auther[en]'],

                    ],
                    'image' => $detail['prod_img_1'],
                    'image_2' => $detail['prod_img_2'],
                    'tags' => $detail['tags'],
                    'link_gallary' => $detail['link_gallary'],
                    'link_video' => $detail['link_video'],
                    'details_day' => $detail['details_day'],
                    'det_date' => $detail['det_date'],
                    'allow_print' => $detail['allow_print'],
                    'add_comment' => $detail['add_comment'],
                    'news_bar' => $detail['news_bar'],
                    'content_form' => $detail['content_form'],
                    'email_form' => $detail['email_form'],
                    'appear_form' => $detail['appear_form'],
                    'num_read' => $detail['num_read'],
                    'appear' => $detail['appear'],
                    'archive' => $detail['archive'],
                    'latitude' => $detail['latitude'],
                    'longitude' => $detail['longitude'],
                    'mainnews' => $detail['mainnews'],
                    'newbooks' => $detail['newbooks'],
                    'lastbooks' => $detail['lastbooks'],
                    'marquee_books' => $detail['marquee_books'],
                    'numeric_title' => $detail['numeric_title'],
                    'time_add' => $detail['time_add'],

                ]);

                DB::statement('SET FOREIGN_KEY_CHECKS=0');

            }


        }
        return $index;

    }


    public function branches_news()
    {
        $cat_id = 132;
        /*$category_title = CategoryTitle::
        //with('sub_titles')
//        with(['sub_titles' => function ($query) {
//            $query->with('details');
//        }])
        with(['sub_titles' => function ($query) {
            $query->OrderBy('numeric_cat', 'ASC')
                ->with(['details' => function ($query) {
                    $query->OrderBy('numeric_title', 'ASC');
                }])//->whereIn('category_id',$sub_title_ids)
            ;
        }])
            ->with(['details' => function ($query) {
                $query->OrderBy('id', 'ASC');
            }])
            ->find($cat_id);*/
        $category_details =  CategoryDetail::where('p_id',$cat_id)
            //->offset(0)->limit(10)
            //->skip(300)->take(100)
            ->get();
        //return $category_details;
       // DB::statement('SET FOREIGN_KEY_CHECKS=0');
       // DB::table('branch_news')->truncate();
        //        DB::table('branch_new_translations')->truncate();

        foreach ($category_details as $index => $category_detail)
        {
            BranchNew::create([

                'image' => $category_detail['prod_img_1']  ,
                'ar' => [
                    'title' => $category_detail['title[ar]'] ,
                    'short_description' => $category_detail['small_title[ar]'] ,
                    'description' => $category_detail['full_text[ar]'] ,
                ],
                'en' => [
                    'title' => $category_detail['title[en]'] ,
                    'short_description' => $category_detail['small_title[en]'] ,
                    'description' => $category_detail['full_text[en]'] ,

                ]
            ]);
            DB::statement('SET FOREIGN_KEY_CHECKS=0');
        }
        return $index;
    }

    public function news()
    {



        $cat_id = 91;
        /*$category_title = CategoryTitle::
        with('sub_titles')
            ->with(['details' => function ($query) {
                $query->OrderBy('id', 'DESC');
            }])
            ->find($cat_id);*/

        $details = CategoryDetail::where('p_id',$cat_id)
            //->offset(0)->limit(10)
            ->skip(0)->take(100)
            ->get();
        //return $details;
       // DB::statement('SET FOREIGN_KEY_CHECKS=0');
       // DB::table('last_news')->truncate();
       // DB::table('last_new_translations')->truncate();
        foreach ($details as $index => $detail) {

            LastNew::create([

                'ar' => [
                    'title' => $detail['title[ar]'],
                    'short_description' => $detail['small_title[ar]'],
                    'description' => $detail['full_text[ar]'],
                    'auther' => $detail['auther[ar]'],

                ],
                'en' => [
                    'title' => $detail['title[en]'],
                    'short_description' => $detail['small_title[en]'],
                    'description' => $detail['full_text[en]'],
                    'auther' => $detail['auther[en]'],

                ],
                'old_id' => $detail['id'],
                'image' => $detail['prod_img_1'],
                'image_2' => $detail['prod_img_2'],
                'tags' => $detail['tags'],
                'link_gallary' => $detail['link_gallary'],
                'link_video' => $detail['link_video'],
                'details_day' => $detail['details_day'],
                'det_date' => $detail['det_date'],
                'allow_print' => $detail['allow_print'],
                'add_comment' => $detail['add_comment'],
                'news_bar' => $detail['news_bar'],
                'content_form' => $detail['content_form'],
                'email_form' => $detail['email_form'],
                'appear_form' => $detail['appear_form'],
                'num_read' => $detail['num_read'],
                'appear' => $detail['appear'],
                'archive' => $detail['archive'],
                'latitude' => $detail['latitude'],
                'longitude' => $detail['longitude'],
                'mainnews' => $detail['mainnews'],
                'new' => $detail['mainnews'],
                'newbooks' => $detail['newbooks'],
                'lastbooks' => $detail['lastbooks'],
                'marquee_books' => $detail['marquee_books'],
                'numeric_title' => $detail['numeric_title'],
                'time_add' => $detail['time_add'],

            ]);
            DB::statement('SET FOREIGN_KEY_CHECKS=0');

        }
        return $index;

    }


    public function cat_15()
    { // فروع الاتحاد
        $cat_id = 15;
        $category_title = CategoryTitle::
        with('sub_titles')
            ->with(['details' => function ($query) {
                $query->OrderBy('numeric_title', 'ASC');
            }])
            ->find($cat_id);
        return $category_title;
    }

    public function cat_63()
    { //شروط الانتساب الى اتحاد الكتاب العرب
        $cat_id = 63;
        $category_title = CategoryTitle::
        with('sub_titles')
            ->with(['details' => function ($query) {
                $query->OrderBy('numeric_title', 'ASC');
            }])
            ->find($cat_id);
        return $category_title;
    }

    public function cat_92()
    { // الهيئات الإدارية

        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('administrative_bodies')->truncate();
        DB::table('administrative_bodies_translations')->truncate();

        $cat_id = 92;
        $category_title = CategoryTitle::
        with('sub_titles')
            ->with(['details' => function ($query) {
                $query->OrderBy('numeric_title', 'ASC');
            }])
            ->find($cat_id);
        $details = $category_title->details;
        foreach ($details as $index => $detail) {

            AdministrativeBodies::create([

                'ar' => [
                    'title' => $detail['title[ar]'],
                    'short_description' => $detail['small_title[ar]'],
                    'description' => $detail['full_text[ar]'],
                    'auther' => $detail['auther[ar]'],

                ],
                'en' => [
                    'title' => $detail['title[en]'],
                    'short_description' => $detail['small_title[en]'],
                    'description' => $detail['full_text[en]'],
                    'auther' => $detail['auther[en]'],

                ],
                'image' => $detail['prod_img_1'],
                'image_2' => $detail['prod_img_2'],
                'tags' => $detail['tags'],
                'link_gallary' => $detail['link_gallary'],
                'link_video' => $detail['link_video'],
                'details_day' => $detail['details_day'],
                'det_date' => $detail['det_date'],
                'allow_print' => $detail['allow_print'],
                'add_comment' => $detail['add_comment'],
                'news_bar' => $detail['news_bar'],
                'content_form' => $detail['content_form'],
                'email_form' => $detail['email_form'],
                'appear_form' => $detail['appear_form'],
                'num_read' => $detail['num_read'],
                'appear' => $detail['appear'],
                'archive' => $detail['archive'],
                'latitude' => $detail['latitude'],
                'longitude' => $detail['longitude'],
                'mainnews' => $detail['mainnews'],
                'newbooks' => $detail['newbooks'],
                'lastbooks' => $detail['lastbooks'],
                'marquee_books' => $detail['marquee_books'],
                'numeric_title' => $detail['numeric_title'],
                'time_add' => $detail['time_add'],

            ]);
            DB::statement('SET FOREIGN_KEY_CHECKS=0');

        }
        return $index;

    }

    public function cat_97()
    { // شروط النشر في الاتحاد
        $cat_id = 97;
        $category_title = CategoryTitle::
        with(['sub_titles' => function ($query) {
            $query->OrderBy('numeric_cat', 'ASC')
                ->with('details');
        }])
            ->with(['details' => function ($query) {
                $query->OrderBy('numeric_title', 'ASC');
            }])
            ->find($cat_id);
        return $category_title;
    }

    public function cat_74()
    { // الإصدارات الدورية
        $cat_id = 74;
        $category_title = CategoryTitle::
        with(['sub_titles' => function ($query) {
            $query->OrderBy('numeric_cat', 'ASC')
                ->with('details');
        }])
            ->with(['details' => function ($query) {
                $query->OrderBy('numeric_title', 'ASC');
            }])
            ->find($cat_id);
        return $category_title;
    }

    public function cat_81()
    { // دليل الأعضاء


        $cat_id = 81;
        /*$category_title = CategoryTitle::
        with(['sub_titles' => function ($query) {
            $query->OrderBy('numeric_cat', 'ASC')
                ->with('details');
        }])
            ->with(['details' => function ($query) {
                $query->OrderBy('numeric_title', 'ASC');
            }])
            ->find($cat_id);*/
        $category_details =  CategoryDetail::where('p_id',$cat_id)
            //->offset(0)->limit(10)
            ->skip(1000)->take(500)
            ->get();

         // return $category_details;
        //   DB::statement('SET FOREIGN_KEY_CHECKS=0');
        //  DB::table('members')->truncate();
        //  DB::table('member_translations')->truncate();

        foreach ($category_details as $index => $detail) {

            Member::create([

                'ar' => [
                    'name' => $detail['title[ar]'],
                    'short_description' => $detail['small_title[ar]'],
                    'description' => $detail['full_text[ar]'],
                    'auther' => $detail['auther[ar]'],

                ],
                'en' => [
                    'name' => $detail['title[en]'],
                    'short_description' => $detail['small_title[en]'],
                    'description' => $detail['full_text[en]'],
                    'auther' => $detail['auther[en]'],

                ],
                'image' => $detail['prod_img_1'],
                'image_2' => $detail['prod_img_2'],
                'tags' => $detail['tags'],
                'link_gallary' => $detail['link_gallary'],
                'link_video' => $detail['link_video'],
                'details_day' => $detail['details_day'],
                'det_date' => $detail['det_date'],
                'allow_print' => $detail['allow_print'],
                'add_comment' => $detail['add_comment'],
                'news_bar' => $detail['news_bar'],
                'content_form' => $detail['content_form'],
                'email_form' => $detail['email_form'],
                'appear_form' => $detail['appear_form'],
                'num_read' => $detail['num_read'],
                'appear' => $detail['appear'],
                'archive' => $detail['archive'],
                'latitude' => $detail['latitude'],
                'longitude' => $detail['longitude'],
                'mainnews' => $detail['mainnews'],
                'newbooks' => $detail['newbooks'],
                'lastbooks' => $detail['lastbooks'],
                'marquee_books' => $detail['marquee_books'],
                'numeric_title' => $detail['numeric_title'],
                'time_add' => $detail['time_add'],

            ]);
            //   DB::statement('SET FOREIGN_KEY_CHECKS=0');

        }
        return $index;
    }

}
