<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class LastNewRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = isset($this->last_new) ? $this->last_new->id : null;
        $rules = [
            'image' => 'image|mimes:jpg,jpeg,png',
        ];

        foreach(config('translatable.locales') as $locale){
            if($locale=='ar'){
                $rules += [$locale.'.title' => 'required'];
            }else{
                $rules += [$locale.'.title' => 'nullable'];
            }
        }

        return $rules;
    }
}
