<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return auth()->check();
    }

    public function rules()
    {

        if(request()->isMethod('put') ){
            $rules['new_password'] = ['required', 'string', 'min:4'];
            $rules['password_confirmation'] = 'required';
        }

        return $rules;
    }
}
