<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;

use Illuminate\Database\Eloquent\Model;

class AppModel extends Model
{

    use SoftDeletes;
    protected $dates = ['deleted_at'];
    protected $host  = 'http://awu.sy/' ;

    public function getImagePathAttribute()
    {
        return $this->image ? $this->host.'photo/'.$this->image: null;
    }

    public function getImageThumbPathAttribute()
    {
        return $this->image ? $this->host.'thumb_photo/'.$this->image: null;
    }

    public function getImageSmallPathAttribute()
    {
        return $this->image ? $this->host.'small_thumb_photo/'.$this->image: null;
    }
    /*public function getImagePathAttribute()
    {
        return $this->image ? asset('uploads/'.$this->table.'/'.$this->image): null;
    }

    public function getImageThumbPathAttribute()
    {
        return $this->image ? asset('uploads/'.$this->table.'/thumbs/'.$this->image): null;
    }*/

    public function createdBy(){
        return $this->hasOne(User::class,'id','created_by')->select('id','name');
    }

    public function updatedBy(){
        return $this->hasOne(User::class,'id','updated_by');
    }

    public function deletedBy() {
        return $this->hasOne(User::class, 'id', 'deleted_by');
    }

    /**
     * Scope a query to only include active items.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

 public function scopeNew($query)
    {
        return $query->where('new', 1);
    }



}
