<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNavMenuItemTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('nav_menu_item_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('nav_menu_item_id')->unsigned();
            $table->string('title')->nullable();
            $table->string('locale')->index();
            $table->unique(['nav_menu_item_id','locale']);
            $table->foreign('nav_menu_item_id')->references('id')->on('nav_menu_items')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nav_menu_item_translations');
    }
}
