<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVoteTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vote_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('vote_id')->unsigned();
            $table->string('question')->nullable();
            $table->string('locale')->index();
            $table->unique(['vote_id','locale']);
            $table->foreign('vote_id')->references('id')->on('votes')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vote_translations');
    }
}
