<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBarTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('bar_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('bar_id')->unsigned();
            $table->text('title')->nullable();
            $table->string('locale')->index();
            $table->unique(['bar_id','locale']);
            $table->foreign('bar_id')->references('id')->on('bars')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('bar_translations');
    }
}
