<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCategoryDetailTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('category_detail_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('category_detail_id')->unsigned();
            $table->text('title')->nullable();
            $table->text('small_title')->nullable();
            $table->longText('full_title')->nullable();
            $table->string('auther')->nullable();



            $table->string('locale')->index();
            $table->unique(['category_detail_id','locale']);
            $table->foreign('category_detail_id')->references('id')->on('category_details')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('category_detail_translations');
    }
}
