<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePublishingConditionTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('publishing_condition_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('publishing_condition_id')->unsigned();

            $table->string('title')->nullable();
            $table->text('short_description')->nullable();
            $table->text('description')->nullable();

            $table->string('locale')->index();
            $table->unique(['publishing_condition_id','locale'],'publishing_cond_locale');
            $table->foreign('publishing_condition_id','publishing_cond_foreign')->references('id')
                ->on('publishing_conditions')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('publishing_condition_translations');
    }
}
