<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEditionCategoryTranslationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('edition_category_translations', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('edition_category_id')->unsigned();
            $table->string('title')->nullable();
            $table->text('description')->nullable();

            $table->string('locale')->index();
            $table->unique(['edition_category_id','locale']);
            $table->foreign('edition_category_id')->references('id')
                ->on('edition_categories')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('edition_category_translations');
    }
}
