<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Category;
class CategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('Categories')->truncate();
        DB::table('Category_translations')->truncate();

        $items = [
            [1, 'الرئيسية', 'Home', NULL, 0, 1, 0, NULL, 0, 0, '?', 0, 1, 0, 0, 1],
            [3, 'إتصل بنا', '', '', 0, 2, 0, NULL, 0, 0, '', 0, 1, 0, 0, 11],
            [64, 'قانون حماية الملكية', NULL, NULL, 60, 2, 0, NULL, 0, 1, '', 0, 1, 0, 0, 8],
            [55, 'اتحاد الكتاب العرب', NULL, NULL, 55, 2, 1, NULL, 0, 0, '', 0, 1, 0, 0, 1],
            [56, 'معلومات عن اتحاد الكتاب العرب', NULL, NULL, 55, 1, 0, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [83, 'الأسبوع الأدبي', NULL, NULL, 74, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [72, 'روايات', NULL, NULL, 66, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [126, 'رئيس الاتحاد', '', '', 60, 2, 0, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [15, 'فروع الاتحاد', '', '', 60, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 6],
            [74, 'الإصدارات الدورية', NULL, NULL, 0, 2, 1, NULL, 0, 0, '', 0, 1, 0, 0, 2],
            [63, 'شروط الانتساب الى اتحاد الكتاب العرب', NULL, NULL, 60, 2, 0, NULL, 0, 1, '', 0, 1, 0, 0, 7],
            [99, 'الشروط الواجب توافرها في المخطوطات', NULL, NULL, 97, 2, 0, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [92, 'الهيئات الإدارية', NULL, NULL, 60, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 5],
            [84, 'الموقف الأدبي', NULL, NULL, 74, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [79, 'الفكر السياسي', NULL, NULL, 74, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [80, 'التراث العربي', NULL, NULL, 74, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 1],
            [71, 'دراسات', NULL, NULL, 66, 2, 1, NULL, 0, 1, '', 0, 1, 0, 0, 1],
        ];

        for($i=0 ; $i < count($items); $i++)

            Category::create([
                'ar' => ['title' => $items[$i][1]],
                'en' => ['title' => null],
                'id' =>  $items[$i][0],
                'link' =>  $items[$i][10],
                'image' =>  $items[$i][7],
                'kind' =>  $items[$i][6],
            ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=0');
    }
}
