<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\NavMenu;
class NavMenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('nav_menus')->truncate();
        DB::table('nav_menu_translations')->truncate();

        $items = [
            
            ['abouts','عن الاتحاد'],
            ['books','الكتب'],
            ['publishing_conditions','شروط النشر'],
            ['editions','الإصدارات الدورية'],
            ['branches','فروع الاتحاد'],
            ['branch_news','أخبار الفروع '],
            ['activities','نشاطات الاتحاد'],
            ['pension_founds','صندوق التقاعد'],
            ['circulars','تعاميم'],
            ['members','دليل الأعضاء'],
        ];

        for($i=0 ; $i < count($items); $i++)

            NavMenu::create([
                'name' =>  $items[$i][0],
                'ar' => ['title' => $items[$i][1] ]
            ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=0');
    }
}
