<?php

use App\Models\SocialMedia;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SocialMediaDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('social_media')->truncate();

        $items = [
            'facebook' => 'Facebook',
            'twitter' => 'Twitter',
            'youtube' => 'Youtube',
            'telegram' => 'Telegram',
            'google-plus' => 'Google Plus',
            'instagram' => 'Instagram',
            'linkedin' => 'Linkedin',
            'vk' => 'vk'
        ];


        foreach ($items as $key => $item) {

            SocialMedia::create([
               'title' => $item,
                'type' => $key,
            ]);

        }


    }
}
