<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\Vote;
class VotesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('votes')->truncate();
        DB::table('vote_translations')->truncate();

        $items = [
            [10, 'ما رأيكم بملحق أدب الأطفال الذي يوزع مجاناً مع الأسبوع الأدبي؟'],
            [11, 'ما هو تقييمكم لمجلة الفكر السياسي؟'],
            [12, 'ماهو رأيكم بندوة:  المثقفون العرب والأزمة السورية ـأفكار وحلول ـ'],
            [13, 'ماهي الدورية الأكثر تميزاً من إصدارات الاتحاد خلال عام 2012'],
            [15, 'ما هو رأيكم بالتصميم الجديد لأغلفة الاتحاد؟'],
            [16, 'ما هو رأيكم في النشاطات الثقافية التي يقيمها اتحاد الكتاب العرب؟'],
        ];

        for($i=0 ; $i < count($items); $i++)

            Vote::create([
                'ar' => ['question' => $items[$i][1]],
                'en' => ['question' => null],
                'id' =>  $items[$i][0],
            ]);

        DB::statement('SET FOREIGN_KEY_CHECKS=0');
    }
}
