@extends('layouts.admin.app')

@section('content')
    <div class="alert alert-info">
        <div class="alert alert-info">
            <p>- {{trans('admin.img_allow_note.type',['[jpg, jpeg, png]'])}}</p>
            <p>- {{trans('admin.img_allow_note.ratio',['['.$image_ratio.']'])}}</p>
            <p>- {{trans('admin.img_allow_note.min_w',[$image_width])}}</p>
        </div>
    </div>
    <form class="form-horizontal form" role="form"
          action="{{isset($item) ? route($module_name.'.update' , $item->id) : route($module_name.'.store')}}"
          method="POST"
          enctype="multipart/form-data">
        @csrf
        @if (isset($item))
            @method("PUT")
        @endif


        <div class="tabbed-info">
            <ul class="nav nav-tabs" role="tablist">
                @foreach(config('translatable.locales') as $locale)
                    <li class="{{$locale=='ar' ? 'active':''}}"><a data-toggle="tab"
                                                                   href="#tab-{{$locale}}">@lang('admin.'.$locale)</a>
                    </li>
                @endforeach
            </ul>
            <div class="tab-content">
                @foreach(config('translatable.locales') as $locale)
                    <div id="tab-{{$locale}}" class="tab-pane {{$locale=='ar' ? 'active' : ''}}">
                        <div class="form-group">
                            <label for="{{$locale}}[title]"
                                   class="col-form-label col-lg-2 text-left">@lang('admin.title')
                                (@lang('admin.'.$locale)): <i class="text-danger">*</i></label>
                            <div class="col-lg-8">
                                <input type="text" name="{{$locale}}[title]" id="{{$locale}}[title]"
                                       class="form-control  {{$locale!='ar' ? 'ltr':''}}" placeholder=""
                                       value="{{isset($item) && $item->translate($locale)
                                        !=null ? $item->translate($locale)->title : old($locale.'.title') }}">
                                @error($locale.'.title')
                                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                                    {{ $message }}
                                </p>
                                @enderror

                            </div>
                        </div>
                        <div class="form-group">
                            <label for="{{$locale}}[short_description]"
                                   class="control-label col-lg-2 text-right">@lang('admin.short_description')
                                (@lang('admin.'.$locale))
                                : </label>
                            <div class="col-lg-8">
                                            <textarea name="{{$locale}}[short_description]" id="{{$locale}}[short_description]" rows="5"
                                                      class="form-control {{$locale=='ar' ? 'rtl':'ltr'}}" >{{isset($item)  && $item->translate($locale) !=null ?
                                                      $item->translate($locale)->short_description : old($locale.'.short_description') }}</textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="{{$locale}}[description]"
                                   class="col-form-label col-lg-2 text-left">@lang('admin.description')
                                (@lang('admin.'.$locale))
                                : </label>

                            <div class="col-lg-8">
                                            <textarea name="{{$locale}}[description]" id="{{$locale}}[description]"
                                                      class="form-control {{$locale=='ar' ? 'textarea_rtl':'textarea_ltr'}}">{{isset($item)  && $item->translate($locale) !=null ? $item->translate($locale)->description : old($locale.'.description') }}</textarea>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>


        <div class="form-group image-box">

            <label for="image"
                   class="col-form-label col-lg-2 text-left">@lang('admin.image')
                :</label>
            <div class="col-lg-8">
                <input type="file" name="image" id="image" onchange="initGrop('{{$image_width}}','{{$image_height}}' ,event);"/>
                @error('image')
                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                    {{ $message }}
                </p>
                @enderror
                <p class="text-danger" id="error"></p>
            </div>

        </div>

        <div class="form-group " id="image_div">
            <input type="hidden" id="x1" name="x1">
            <input type="hidden" id="y1" name="y1">
            <input type="hidden" id="x2" name="x2">
            <input type="hidden" id="y2" name="y2">
            <input type="hidden" id="filesize" name="filesize">
            <input type="hidden" id="filetype" name="filetype">
            <input type="hidden" id="filedim" name="filedim">
            <input type="hidden" id="h" name="h">
            <input type="hidden" id="w" name="w">
            <label for="image_file" class="col-lg-2 col-form-label"> </label>
            <div class="col-lg-8" id="interface">
                @if(isset($item) && !empty($item->image))
                    <button type="button"
                            class="btn btn-danger btn-flat confirm btn-sm delimg" data-toggle="tooltip"
                            data-original-title="@lang('admin.delete_image')" data-placement="top"
                            onclick="deleteItem('{{route($module_name.'.delete_image',$item->id)}}')">
                        <i class="fa fa-trash-o fa-sm"></i></button>
                    <img id="preview" src="{{asset($uploads_folder.'/'.$module_name.'/'.$item->image)}}"
                         class="img-thumbnail"/>
                @else
                    <img id="preview">
                @endif
            </div>
        </div>
        <div class="form-group">
            <div class="col-md-8 col-md-offset-2">
                <button type="submit" class="btn btn-sm btn-primary"><i
                        class="fa fa-save"></i> {{trans('admin.save')}}</button>
            </div>
        </div>


    </form>
@endsection

@push('js')


@endpush
