@extends('layouts.admin.app')

@section('content')
    <form class="form-horizontal form" role="form"
          action="{{isset($item) ? route($module_name.'.update' , $item->id) : route($module_name.'.store')}}"
          method="POST"
          enctype="multipart/form-data">
        @csrf
        @if (isset($item))
            @method("PUT")
        @endif


        <div class="tabbed-info">
            <ul class="nav nav-tabs" role="tablist">
                @foreach(config('translatable.locales') as $locale)
                    <li class="{{$locale=='ar' ? 'active':''}}"><a data-toggle="tab"
                                                                   href="#tab-{{$locale}}">@lang('admin.'.$locale)</a>
                    </li>
                @endforeach
            </ul>
            <div class="tab-content">
                @foreach(config('translatable.locales') as $locale)
                    <div id="tab-{{$locale}}" class="tab-pane {{$locale=='ar' ? 'active' : ''}}">
                        <div class="form-group">
                            <label for="{{$locale}}[title]"
                                   class="col-form-label col-lg-2 text-left">@lang('admin.title')
                                (@lang('admin.'.$locale)): <i class="text-danger">*</i></label>
                            <div class="col-lg-8">
                                <textarea type="text" name="{{$locale}}[title]" id="{{$locale}}[title]"
                                          @isset($item) rows="<?= strlen($item->title)/100+5 ?>" @endisset

                                          class="form-control  {{$locale!='ar' ? 'ltr':''}}" >
                                        {{isset($item)&&$item->translate($locale)!=null?$item->translate($locale)->title:old($locale.'.title') }}

                                </textarea>
                                @error($locale.'.title')
                                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                                    {{ $message }}
                                </p>
                                @enderror

                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        <div class="form-group">
            <label for="link"
                   class="col-form-label col-lg-2 text-left">@lang('admin.link'): <i class="text-danger">*</i></label>
            <div class="col-lg-8">
                <input type="text" name="link" id="link"
                       class="form-control ltr" placeholder=""
                       value="{{isset($item) && $item->link !=null ? $item->link : old('link') }}">
                @error('link')
                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                    {{ $message }}
                </p>
                @enderror

            </div>
        </div>


        <div class="form-group">
            <div class="col-md-8 col-md-offset-2">
                <button type="submit" class="btn btn-sm btn-primary"><i
                            class="fa fa-save"></i> {{trans('admin.save')}}</button>
            </div>
        </div>


    </form>
@endsection

@push('js')


@endpush
