@extends('layouts.admin.app')

@section('widget-toolbar')
    <a  href="{{route($module_name.'.active',$item->id)}}"
        class="btn btn-xs btn-white btn-{{$item->status==1 ? 'primary': 'warning'}}" title=""
        data-rel="tooltip" data-placement="top"
        data-original-title="{{$item->status==1 ? trans('admin.inactive'): trans('admin.active')}}"
        data-loading-text="<i class='fa fa-spinner fa-spin '></i>"
        onclick="active(this,event);">
        <i class="ace-icon fa fa-{{$item->status==1 ? 'check': 'ban'}}"></i>
    </a>

    <a class="btn btn-white btn-info btn-xs" href="{{route($module_name.'.edit',$item->id)}}" data-rel="tooltip"
       data-placement="top" title="@lang('admin.edit')" data-original-title=" @lang('admin.edit')">
        <i class="ace-icon fa fa-pencil"></i>
    </a>

@endsection
@section('content')
    <form class="form-horizontal form" role="form" >
        <div class="tabbed-info">
            <ul class="nav nav-tabs" role="tablist">
                @foreach(config('translatable.locales') as $locale)
                    <li class="{{$locale=='ar' ? 'active':''}}">
                        <a data-toggle="tab"   href="#tab-{{$locale}}"> @lang('admin.'.$locale)</a>
                    </li>
                @endforeach
            </ul>
            <div class="tab-content">
                @foreach(config('translatable.locales') as $locale)
                    <div id="tab-{{$locale}}" class="tab-pane {{$locale=='ar' ? 'active' : ''}}">
                        <div class="form-group">
                            <label for="{{$locale}}[title]"
                                   class="col-form-label col-lg-2 ">@lang('admin.title')
                                (@lang('admin.'.$locale))</label>
                            <div class="col-lg-8">
                                {{$item->translate($locale)->title}}

                            </div>
                        </div>
                        <div class="form-group">
                            <label for="{{$locale}}[description]"
                                   class="col-form-label col-lg-2">@lang('admin.description')
                                (@lang('admin.'.$locale))</label>

                            <div class="col-lg-8">
                               {!! $item->translate($locale)->description  !!}
                            </div>
                        </div>

                    </div>
                @endforeach
            </div>
        </div>

        <div class="form-group image-box">
            <label for="image"
                   class="col-form-label col-lg-2 text-left">@lang('admin.image')
                :</label>
            <div class="col-lg-8">
                @if($item->image != null)
                    <img src="{{$item->image_thumb_path}}" class="img-thumbnail"/>
                @else
                    @lang('admin.no_image')
                @endif
            </div>
        </div>
    </form>

@endsection


