@extends('layouts.admin.app')
@section('widget-toolbar')
    <span>

    </span>
@endsection
@section('content')

    <form class="form-horizontal form" role="form"
          action="{{isset($item) ? route($module_name.'.update' , $item->id) : route($module_name.'.store')}}"
          method="POST"
          enctype="multipart/form-data">
        @csrf
        @if (isset($item))
            @method("PUT")
        @endif

        <div class="form-group">
            <label for="title"
                   class="col-form-label col-lg-2 text-right">@lang('admin.title')
                :</label>
            <div class="col-lg-8">
                <input type="text" name="title" id="title"
                       class="form-control  rtl" placeholder=""
                       value="{{isset($item) ? $item->title : old('title') }}">
                @error('name')
                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                    {{ $message }}
                </p>
                @enderror
            </div>
        </div>


        <div class="form-group">
            <label for="address"
                   class="col-form-label col-lg-2 text-right">@lang('admin.address')
                : </label>

            <div class="col-lg-8">
                <textarea name="address" rows="3" id="address"
                          class="form-control textarea-rtl">{{isset($item)  ? $item->address : old('address') }}</textarea>
            </div>
        </div>



        <div class="form-group">
            <label for="phone"
                   class="col-form-label col-lg-2 text-right">@lang('admin.phone') : </label>
            <div class="col-lg-8">
                <input type="text" name="phone" id="phone"
                       class="form-control ltr text-left" placeholder=""
                       value="{{isset($item)  ? $item['phone'] : old('phone') }}">
            </div>
        </div>



        <div class="form-group">
            <label for="mobile"
                   class="col-form-label col-lg-2 text-right">@lang('admin.mobile'): </label>
            <div class="col-lg-8">
                <input type="text" name="mobile" id="mobile"
                       class="form-control ltr text-left" placeholder=""
                       value="{{isset($item)  ? $item['mobile'] : old('mobile') }}">
            </div>
        </div>



        <div class="form-group">
            <label for="email_1"
                   class="col-form-label col-lg-2 text-right">@lang('admin.default_email'): </label>
            <div class="col-lg-8">
                <input type="email" name="email" id="email_1"
                       class="form-control ltr text-left" placeholder=""
                       value="{{isset($item) ? $item['email'] : old('email') }}">
            </div>
        </div>

        <div class="form-group">
            <label for="email_2"
                   class="col-form-label col-lg-2 text-right">@lang('admin.email_2'): </label>
            <div class="col-lg-8">
                <input type="email" name="email_2" id="email_2"
                       class="form-control ltr text-left" placeholder=""
                       value="{{isset($item) ? $item['email_2'] : old('email_2') }}">
            </div>
        </div>

        <div class="form-group">
            <label for="mail_box"
                   class="col-form-label col-lg-2 text-right">@lang('admin.mail_box'): </label>
            <div class="col-lg-8">
                <input type="text" name="mail_box" id="mail_box"
                       class="form-control ltr text-left" placeholder=""
                       value="{{isset($item) ? $item['mail_box'] : old('mail_box') }}">
            </div>
        </div>

        <div class="form-group">
            <label for="fax"
                   class="col-form-label col-lg-2 text-right">@lang('admin.fax')
                : </label>

            <div class="col-lg-8">
                <input type="fax" name="fax" id="fax"
                       class="form-control ltr text-left" placeholder=""
                       value="{{isset($item) ? $item['fax'] : old('fax') }}">
            </div>
        </div>
        <div class="form-group">
            <label for="description"
                   class="col-form-label col-lg-2 text-right">@lang('admin.description')
                : </label>

            <div class="col-lg-8">
                <textarea name="description" rows="3" id="description"
                          class="form-control textarea-rtl"
                          @isset($item) rows="<?= strlen($item->description)/100+5 ?>" @endisset
                >{{isset($item)  ? $item->description : old('description') }}</textarea>
            </div>
        </div>


        <div class="form-group ">
            <div class="col-lg-2"></div>
            <div class="col-lg-8">
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="fa fa-save"></i> @lang('admin.save')
                </button>
            </div>
        </div>


    </form>
@endsection

@push('js')
    <script>
        var selectImgWidth, selectImgHeight, jcrop_api;
        window.initGrop = function (w, h, e) {
            e.preventDefault();
            document.getElementById('interface').innerHTML = '<img id="preview" />';
            document.getElementById('error').style.display = 'none';
            document.getElementById('image_div').style.display = 'none';
            var previewId = document.getElementById('preview');
            previewId.src = '';
            clearInfo();
            // Get selected file parameters
            var selectedImg = $('#image')[0].files[0];
            console.log(selectedImg);
            // Preview the selected image with object of HTML5 FileReader class
            // Make the HTML5 FileReader Object
            var oReader = new FileReader();
            oReader.onload = function (e) {
                // e.target.result is the DataURL (temporary source of the image)

                previewId.src = e.target.result;
                // FileReader onload event handler
                previewId.onload = function () {
                    // display the image with fading effect
                    $('#image_div').fadeIn(500);
                    selectImgWidth = previewId.naturalWidth; //set the global image width
                    selectImgHeight = previewId.naturalHeight;//set the global image height
                    if (selectImgWidth < w || selectImgHeight < h) {
                        document.getElementById('error').style.display = 'block';
                        document.getElementById('error').innerHTML = 'Image dimensions must be larger than  [' + h + ' * ' + w + ']';
                        document.getElementById('image_div').style.display = 'none';
                        document.getElementById('interface').innerHTML = '<img id="preview" />';
                        $('#image').parent().parent().removeClass('has-success');
                        $('#image').parent().parent().addClass('has-error');
                        $('#submitBtn').attr('disabled', 'disabled');
                    } else {
                        // destroy Jcrop if it is already existed
                        if (typeof jcrop_api != 'undefined')
                            jcrop_api.destroy();

                        // initialize Jcrop Plugin on the selected image
                        $('#preview').Jcrop({
                            minSize: [w, h], // min crop size
                            boxWidth: 700,
                            setSelect: [0, 0, w, h],
                            aspectRatio: w / h,
                            bgFade: true,
                            bgOpacity: .3,
                            onChange: updateInfo,
                            onSelect: updateInfo,
                            onRelease: clearInfo,
                            //bgColor: '#fff'// you can use bgColor:'' to transparent
                        }, function () {
                            // Store the Jcrop API in the jcrop_api variable
                            jcrop_api = this;
                        });
                    }
                };
            };

            // read selected file as DataURL
            oReader.readAsDataURL(selectedImg);

        }

        /*function checkForm() {
        if (parseInt($('#w').val())) return true;
        $('.error').html(' الرجاء أختيار منطقة للقطع بعدها تستطيع الرفع').show();
        return false;
        };*/

        function updateInfo(e) {
            $('#x1').val(e.x);
            $('#y1').val(e.y);
            $('#x2').val(e.x2);
            $('#y2').val(e.y2);
            $('#w').val(e.w);
            $('#h').val(e.h);
        };

        function clearInfo() {
            $('#x1').val('');
            $('#y1').val('');
            $('#x2').val('');
            $('#y2').val('');
            $('.info #w').val('');
            $('.info #h').val('');
        };
    </script>

@endpush
