@extends('layouts.admin.app')
@section('css')

@endsection

@section('content')
    <form
        action="{{isset($item) ? route('users.update' , $item->id) : route('users.store')}}"
        class="form-horizontal"
        id="form-validate" method="POST"
        enctype="multipart/form-data">
        @csrf
        @if (isset($item))
            @method("PUT")
        @endif
        <div class="form-group">
            <label for="name" class="control-label col-lg-2 text-left">@lang('users.name'): <i class="text-danger">*</i></label>
            <div class="col-lg-6">
                <input id="name" type="text"
                       class="form-control" name="name"
                       value="{{ isset($item) ? $item->name : old('name') }}" required autocomplete="name" autofocus>
                @error('name')
                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                    {{ $message }}
                </p>
                @enderror
            </div>
        </div>
        <div class="form-group">
            <label for="email" class="control-label col-lg-2 text-left">@lang('users.email'):</label>

            <div class="col-lg-6">
                <input id="email" type="email"
                       class="form-control text-left ltr" name="email"
                       value="{{ isset($item) ? $item->email : old('email') }}" autocomplete="email">

            </div>
        </div>
        <div class="form-group">
            <label for="username" class="control-label col-lg-2 text-left">@lang('users.username'): <i
                    class="text-danger">*</i></label>
            <div class="col-lg-6">
                <input id="username" type="text"
                       class="form-control  text-left ltr" name="username"
                       value="{{ isset($item) ? $item->username : old('username') }}" required autocomplete="username">
                @error('username')
                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                    {{ $message }}
                </p>
                @enderror
            </div>
        </div>

        <div class="form-group">
            <label for="password"
                   class="control-label col-lg-2 text-left">@lang('users.password'): <i
                    class="text-danger">*</i></label>

            <div class="col-lg-6">
                <input id="password" type="password"
                       class="form-control  text-left ltr"
                       name="password" {{ isset($item) ?  '' : 'required' }} autocomplete="new-password">
                @error('password')
                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                    {{ $message }}
                </p>
                @enderror
            </div>
        </div>
        <div class="form-group">
            <label for="password-confirm" class="control-label col-lg-2 text-left">@lang('users.password_confirmation')
                : <i class="text-danger">*</i></label>
            <div class="col-md-6">
                <input id="password-confirm" type="password" class="form-control text-left ltr"
                       name="password_confirmation" {{ isset($item) ?  '' : 'required' }}
                       autocomplete="new-password">
                @error('password_confirmation')
                <p class="invalid-feedback text-danger text-right rtl" role="alert">
                    {{ $message }}
                </p>
                @enderror
            </div>
        </div>


        <div class="form-group">
            <div class="col-lg-2"></div>
            <div class="col-lg-8">
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="fa fa-save"></i> @lang('admin.save')
                </button>
            </div>
        </div>

    </form>

@endsection
@push('js')
    <script></script>
@endpush


