@php
    $status_class = $data->status == 1 ? 'btn-success' : 'btn-warning';
    $status_icon = $data->status == 1 ? 'check' : 'ban';
    $status_title = $data->status == 1 ? trans('admin.inactive') : trans('admin.active');

    $new_class = $data->new == 1 ? 'btn-success' : 'btn-warning';

    $new_title = $data->new == 1 ? trans('admin.not_new') : trans('admin.new');
@endphp
<div class="btn-group">
    @if($data->deleted_at==null)
        @if(in_array('is_new',$module_actions))
            <a href="{{route($module_name . '.is_new', $data->id)}}"
               class="btn btn-xs {{$new_class}}"
               data-container="body" data-rel="tooltip" data-placement="top"
               data-loading-text="<i class='fa fa-spinner fa-spin'></i>"
               data-original-title="{{$new_title}}"
               title="{{$new_title}}"
               onclick="active(this,event);">
                <i class="fa fa-star "></i>
            </a>
        @endif
            @if(in_array('active',$module_actions))
                <a href="{{route($module_name . '.active', $data->id)}}"
                   class="btn btn-xs {{$status_class}}"
                   data-container="body" data-rel="tooltip" data-placement="top"
                   data-loading-text="<i class='fa fa-spinner fa-spin'></i>"
                   data-original-title="{{$status_title}}"
                   title="{{$status_title}}"
                   onclick="active(this,event);">
                    <i class="fa fa-{{$status_icon}} "></i>
                </a>
            @endif
        @if(in_array('edit',$module_actions))
            <a href="{{route($module_name.'.edit',$data->id)}}"
               @if(isset($actions_modal) && in_array('edit',$actions_modal))
               data-toggle="modal" data-target="#ajaxModal"
               @endif
               class="btn btn-xs btn-info"
               data-container="body" data-rel="tooltip"
               data-placement="top" data-original-title="{{trans('admin.edit')}}">
                <i class="fa fa-edit"></i>
            </a>
        @endif
        @if(in_array('delete',$module_actions))
            <a href="javascript:;" class="btn btn-xs btn-danger"
               data-container="body" data-rel="tooltip" data-placement="top"
               data-original-title="@lang('admin.delete')"
               onclick="deleteItem('{{route($module_name . '.destroy', [$data->id, 'soft_delete'])}}')">
                <i class="fa fa-trash"></i>
            </a>
        @endif
    @else
        @if(in_array('delete',$module_actions))
            <button class="btn btn-xs btn-info"
                    data-container="body" data-rel="tooltip" data-placement="top"
                    title="@lang('admin.restore')"
                    data-original-title="@lang('admin.restore')"

                    onclick="restoreItem('{{route($module_name.'.restore',[$data->id])}}')">
                <i class="fa fa-undo"></i>
            </button>
        @endif
        @if(in_array('delete',$module_actions))
            <button class="btn btn-danger btn-xs"
                    data-container="body" data-rel="tooltip" data-placement="top"
                    title="@lang('admin.force_delete')"
                    data-original-title="@lang('admin.force_delete')"

                    onclick="deleteItem('{{route($module_name.'.destroy',$data->id)}}')">
                <i class="fa fa-trash"></i>
            </button>
        @endif
    @endif
</div>
