@extends('layouts.frontend.app')

@push('css')
   {{-- <link rel="stylesheet" href="{{asset("frontend/assets/css/last-news.css")}}">--}}
@endpush

@section('content')
@include('layouts.frontend.includes.header-pages')

    {{-- start last news section --}}
    <div class="last-news text-center">
        <div class="container">
            <h2 class="news-heading wow zoomIn"> @lang('frontend.last_news')</h2>
            <div class="row">
                @foreach($news as $new_item)
                    <div class="col-md-4 col-xs-12 col-sm-6 news-item">
                        <div class="card wow jackInTheBox" data-wow-offset="250" data-wow-delay=".3s">
                            <figure class="c4-izmir c4-border-bottom-left c4-gradient-bottom-right" tabindex="0" style="--primary-color: #15c6dd; --secondary-color: #000e65; --image-opacity: .5;">

                                <img class="img-responsive" src="{{$new_item->image_path}}" alt="" >

                                <figcaption class="c4-layout-bottom-left">
                                    <div class="c4-reveal-right c4-delay-100">
                                        <h3>
                                            <i class="icofont-book"></i>
                                        </h3>
                                    </div>
                                </figcaption>
                            </figure>
                            <div class="caption">
                                <div class="caption-content">
                                    <div class="news-head">
                                        <h3 class=" col-xs-text-center">{{$new_item->title}} </h3>
                                    </div>

                                    <div class="parg desc4">

                                        {!! $new_item->short_description !!}

                                    </div>
                                </div>

                                <a href="{{route('last_news.details',$new_item->id)}}"
                                   class="news-details">
                                    @lang('frontend.more')
                                </a>
                            </div>
                        </div>

                    </div>
                    @if($loop->iteration%3==0)
                         </div><div class="row">
                    @endif
                @endforeach
            </div>

            <div  class="news-more text-center">      {{ $news->links() }}</div>
        </div>
    </div>
    {{--end last news section --}}
    {{-- start new edition section --}}
    @include('components.frontend.new_edition')

    {{--end new edition section --}}


    {{--start friend sites --}}
    @include('components.frontend.friendsite')
    {{--end friend sites--}}
@endsection
