@extends('layouts.frontend.app')

@push('css')
   {{-- <link rel="stylesheet" href="{{asset("frontend/assets/css/last-news.css")}}">--}}
@endpush

@section('content')
@include('layouts.frontend.includes.header-pages')

    {{-- start last news section --}}
    <div class="last-news text-center">
        <div class="container">
            <h2 class="news-heading"> @lang('frontend.pension_founds')</h2>
            <div class="row">
                @foreach($pension_founds as $pension_found)
                    <div class="col-md-4 col-xs-12 col-sm-6 news-item">
                        <a href="{{route('pension_founds.details',$pension_found->id)}}">
                            <div class="news-img">
                                <img class="img-responsive" src="{{$pension_found->image_path}}" alt="" >
                            </div>
                        </a>
                        <div class="caption">
                            <div class="caption-content">
                                <div class="news-head">
                                    <h3 class=" col-xs-text-center">{{$pension_found->title}} </h3>
                                </div>

                                <div class="desc">
                                    <p class="news-desc">
                                        {!! $pension_found->short_description !!}
                                    </p>
                                </div>
                            </div>

                            <a href="{{route('pension_founds.details',$pension_found->id)}}"
                               class="news-details">
                                @lang('frontend.more')
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>

        </div>
    </div>
    {{--end last news section --}}
    {{-- start new edition section --}}
    @include('components.frontend.new_edition')

    {{--end new edition section --}}


    {{--start friend sites --}}
    @include('components.frontend.friendsite')
    {{--end friend sites--}}
@endsection
