<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
    <meta charset="utf-8" />
    <title>{{trans('admin.admin_title')}} | {{$module_title}} </title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0" />

    <link rel="stylesheet" href="{{mix('css/admin.app.css')}}">
    <link rel="stylesheet" href="{{asset('admin/bootstrapValidator/bootstrapValidator.min.css')}}">
    @if(app()->getLocale()=='ar')
        <link rel="stylesheet" href="{{asset('admin/assets/css/ace-rtl.css')}}">
    @endif
@yield('css')
    <link rel="stylesheet" href="{{asset('admin/assets/css/colorbox.css')}}" />
    <link rel="stylesheet" href="{{asset('admin/assets/my_css/style.css')}}">

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="{{asset('css/ace-part2.css')}}" class="ace-main-stylesheet" />
    <![endif]-->

    <!--[if lte IE 9]>
    <link rel="stylesheet" href="{{asset('admin/assets/css/ace-ie.css')}}" />
    <![endif]-->

    <!-- inline styles related to this page -->

    <!-- ace settings handler -->
    <script src="{{asset('admin/assets/js/ace-extra.js')}}"></script>

    <!-- HTML5shiv and Respond.js for IE8 to support HTML5 elements and media queries -->

    <!--[if lte IE 8]>
    <script src="{{asset('admin/assets/js/html5shiv.js')}}"></script>
    <script src="{{asset('admin/assets/js/respond.js')}}"></script>
    <![endif]-->
    <script>
        (function () {
            window.Laravel = {
                csrfToken: '{{ csrf_token() }}'
            };
        })();
        var app_locale = '{!! config('app.locale') !!}';
        var table_settings = {};
        var asset = '{{asset('/')}}';
        var method_name = '{{$method_name}}';
        @if($module_name !='home')
        var index_route = '{{route($module_name.'.index')}}';
        @endif
        var module_name = '{{$module_name}}';
    </script>
</head>

<body class="no-skin {{app()->getLocale()=='ar' ? 'rtl' : ''}}">
<!-- #section:basics/navbar.layout -->
<div id="app">
@include('layouts.admin.includes.navbar')
<!-- /section:basics/navbar.layout -->
<div class="main-container" id="main-container">


    <!-- #section:basics/sidebar -->
    @include('layouts.admin.includes.sidebar')

    <!-- /section:basics/sidebar -->
    <div class="main-content">
        <div class="main-content-inner">
            <!-- #section:basics/content.breadcrumbs -->
            <div class="breadcrumbs" id="breadcrumbs">
                <ul class="breadcrumb">
                    <li>

                        <i class="ace-icon fa fa-home home-icon"></i>
                        <a href="{{route('admin')}}"> @lang('home.module_title')</a>
                    </li>

                    @if($method_name=='index' || $method_name==null)
                    <li class="active">{{$module_title}}</li>
                    @else
                    <li ><a href="{{route($module_name.'.index')}}"> {{$module_title}} </a></li>
                    @endif




                </ul><!-- /.breadcrumb -->

                <!-- #section:basics/content.searchbox -->
                {{--<div class="nav-search" id="nav-search">
                    <form class="form-search">
								<span class="input-icon">
									<input type="text" placeholder="Search ..." class="nav-search-input" id="nav-search-input" autocomplete="off" />
									<i class="ace-icon fa fa-search nav-search-icon"></i>
								</span>
                    </form>
                </div>--}}
                <div class="nav-search">

                    @if(request()->has('trashed'))
                        <a href="{{route($module_name.'.index',$param?? '')}}"
                           class="btn btn-inverse btn-xs">@lang('admin.back') <i
                                class="fa fa-arrow-left"></i> </a>
                    @endif
                    @if(!request()->has('trashed') && (isset($deleted_items) && $deleted_items->count()>0))
                        <a href="{{route($module_name.'.index',['trashed',$param?? ''])}}"
                           class="btn btn-danger btn-xs"><i
                                class="fa fa-trash"></i> @lang('admin.trashed')</a>
                    @endif
                </div>
                <!-- /.nav-search -->

                <!-- /section:basics/content.searchbox -->
            </div>

            <!-- /section:basics/content.breadcrumbs -->
            <div class="page-content">
                <!-- #section:settings.box -->
                {{--@include('layouts.admin.includes.settings')--}}
                <!-- /.ace-settings-container -->

                <!-- /section:settings.box -->
                <div class="row">
                    <div class="col-xs-12">
                        <!-- PAGE CONTENT BEGINS -->
                        <div class="widget-box">
                            <div class="widget-header">
                                <h4 class="widget-title">{{$method_title ?? ''}}</h4>


                                <div class="widget-toolbar">

                                        @hasSection('widget-toolbar')
                                            @yield('widget-toolbar')
                                        @else
                                            @if($method_name=='index')
                                            <a href="{{route($module_name.'.create')}}" class="btn btn-primary btn-xs"><i class="ace-icon fa fa-plus"></i>{{trans('admin.create')}}</a>
                                            @endif
                                        @endif


                                </div>
                            </div>

                            <div class="widget-body">

                                <div class="widget-main">

                                    @if ($message = \Session::get('success'))
                                        <div class="alert alert-success">
                                            {{ $message }}
                                        </div>
                                    @endif
                                        @if ($message = \Session::get('error'))
                                        <div class="alert alert-danger">
                                            {{ $message }}
                                        </div>
                                    @endif
                                    @yield('content')
                                </div>
                            </div>
                        </div>

                        <!-- PAGE CONTENT ENDS -->
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.page-content -->
        </div>
    </div><!-- /.main-content -->


    <a href="#" id="btn-scroll-up" class="btn-scroll-up btn btn-sm btn-inverse">
        <i class="ace-icon fa fa-angle-double-up icon-only bigger-110"></i>
    </a>
    <div class="modal fade draggable-modal" id="ajaxModal" tabindex="-1" role="basic" aria-hidden="true">
        <div class="modal-dialog">


            <div class="modal-content">
                <div class="modal-body ">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin bigger-250"></i>
                        <span>&nbsp;&nbsp;   </span>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div><!-- /.main-container -->
</div>

<!--[if IE]>
<script type="text/javascript">
    window.jQuery || document.write("<script src='{{asset('admin/assets/js/jquery1x.js')}}'>"+"<"+"/script>");
</script>
<![endif]-->
<script type="text/javascript">
    if('ontouchstart' in document.documentElement) document.write("<script src='{{asset('admin/assets/js/jquery.mobile.custom.js')}}'>"+"<"+"/script>");
</script>

<script src="{{mix('js/admin.app.js')}}"></script>

<script src="{{asset('admin/bootstrapValidator/bootstrapValidator.min.js')}}"></script>
@if(app()->getLocale()=='ar')
    <script src="{{asset('admin/bootstrapValidator/ar_MA.js')}}"></script>
@endif
<script src="{{asset('admin/assets/js/date-time/bootstrap-datepicker.js')}}"></script>
<script src="{{asset('admin/assets/js/date-time/bootstrap-timepicker.js')}}"></script>
<script src="{{asset('admin/assets/js/date-time/moment.js')}}"></script>
<script src="{{asset('admin/assets/js/date-time/daterangepicker.js')}}"></script>
<script src="{{asset('admin/assets/js/date-time/bootstrap-datetimepicker.js')}}"></script>
<script src="{{asset('admin/assets/js/bootstrap-colorpicker.js')}}"></script>
<script src="{{asset('admin/assets/js/jquery.bootstrap-duallistbox.js')}}"></script>
<script src="{{asset('admin/assets/js/jquery.colorbox.js')}}"></script>
<script src="{{asset('admin/assets/my_js/script.js')}}"></script>
<script type="text/javascript">
    jQuery(function($) {
        $('#colorpicker1').colorpicker();

        $("body").delegate(".date-picker", "focusin", function () {
            $(this).datepicker({
                autoclose: true,
                todayHighlight: true
            })
                //show datepicker when clicking on the icon
                .next().on(ace.click_event, function () {
                $(this).prev().focus();
            });
        });
    });

</script>


<script type="text/javascript">
    jQuery(function($) {
        var $overflow = '';
        var colorbox_params = {
            rel: 'colorbox',
            reposition:true,
            scalePhotos:true,
            scrolling:false,
            previous:'<i class="ace-icon fa fa-arrow-left"></i>',
            next:'<i class="ace-icon fa fa-arrow-right"></i>',
            close:'&times;',
            current:'{current} of {total}',
            maxWidth:'100%',
            maxHeight:'100%',
            onOpen:function(){
                $overflow = document.body.style.overflow;
                document.body.style.overflow = 'hidden';
            },
            onClosed:function(){
                document.body.style.overflow = $overflow;
            },
            onComplete:function(){
                $.colorbox.resize();
            }
        };

        $('.ace-thumbnails [data-rel="colorbox"]').colorbox(colorbox_params);
        $("#cboxLoadingGraphic").html("<i class='ace-icon fa fa-spinner orange fa-spin'></i>");//let's add a custom loading icon


        $(document).one('ajaxloadstart.page', function(e) {
            $('#colorbox, #cboxOverlay').remove();
        });
    })
</script>


<script src="{!! asset('admin/assets/plugins/tinymce/tinymce.min.js') !!}"></script>
<script src="{!! asset('admin/assets/my_js/tinymce_settings.js') !!}"></script>


@stack('js')
</body>
</html>
