<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
    <meta charset="utf-8">
    <title><?php echo app('translator')->get('admin.app_name'); ?> | <?php echo $__env->yieldContent('title',$module_title ?? trans('admin.admin_title')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Optimize mobile viewport -->
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <!-- default favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/png"/>
    <!--App Styles -->
    <link href="<?php echo e(mix('css/admin.app.css')); ?>" rel="stylesheet">
<!--[if lte IE 9]>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/ace-part2.css')); ?>" class="ace-main-stylesheet" />
    <![endif]-->

<!--[if lte IE 9]>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/css/ace-ie.css')); ?>" />
    <![endif]-->

    <!-- ace settings handler -->
    <script src="<?php echo e(asset('admin/assets/js/ace-extra.js')); ?>"></script>

    <!-- HTML5shiv and Respond.js for IE8 to support HTML5 elements and media queries -->

<!--[if lte IE 8]>
    <script src="<?php echo e(asset('admin/assets/js/html5shiv.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/js/respond.js')); ?>"></script>
    <![endif]-->

</head>
<body class="login-layout light-login">
<div id="app">
    <div class="space-30"></div>
    <div class="main-container ">
        <div class="main-content">

            <div class="row">
                <div class="col-sm-10 col-sm-offset-1">
                    <div class="login-container">

                        <div class="space-6"></div>

                        <div class="position-relative">
                            <div id="login-box" class="login-box visible widget-box no-border">
                                <div class="widget-body">
                                    <div class="widget-main">
                                        <div class="center">
                                            <img src="<?php echo e(asset('images/logo.png')); ?>" style="background-color: #666666"
                                                 class="img-thumbnail">
                                        </div>


                                        <div class="space-6"></div>

                                        <form action="<?php echo e(route('login')); ?>" method="post" id="loginForm" class=""
                                              accept-charset="utf-8">
                                            <?php echo e(csrf_field()); ?>

                                            <fieldset>
                                                <label class="block clearfix">
                                            <span class="block input-icon input-icon-right">
                                                <input type="text" name="username" value="" id="username"
                                                       class="form-control <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       placeholder="<?php echo e(__('username')); ?>" value="<?php echo e(old('username')); ?>"
                                                       required autocomplete="username" autofocus/>

                                                <i class="ace-icon fa fa-user"></i>
                                                <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <p class="invalid-feedback text-danger rtl text-right" role="alert">
                                                        <small><?php echo e($message); ?></small>
                                                    </p>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </span>
                                                </label>

                                                <label class="block clearfix">
                                            <span class="block input-icon input-icon-right">
                                                <input type="password" name="password" value="" id="password"
                                                       class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       placeholder="<?php echo e(__('Password')); ?>"
                                                       name="password" required autocomplete="current-password"/>
                                                <i class="ace-icon fa fa-lock"></i>
                                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <p class="invalid-feedback text-danger rtl text-right" role="alert">
                                                      <small><?php echo e($message); ?></small>
                                                    </p>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </span>
                                                </label>

                                                <div class="space"></div>

                                                <div class="clearfix">

                                                    <button type="submit" class="btn btn-block btn-sm btn-primary">
                                                        <i class="ace-icon fa fa-key"></i>
                                                        <span class="bigger-110">دخول</span>
                                                    </button>
                                                </div>

                                                <div class="space-4"></div>
                                            </fieldset>
                                        </form>
                                        <div class="space-6"></div>

                                    </div><!-- /.widget-main -->

                                </div><!-- /.widget-body -->
                            </div><!-- /.login-box -->
                        </div><!-- /.position-relative -->

                    </div>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.main-content -->
    </div><!-- /.main-container -->
</div>

<!-- BEGIN App Mix Scripts -->
<script src="<?php echo e(mix('js/admin.app.js')); ?>" defer></script>
<!-- END App Mix Scripts -->

</body>
</html>


<?php /**PATH /home/awu/new.awu.sy/resources/views/auth/login.blade.php ENDPATH**/ ?>