<?php
function trunc($phrase, $max_words) {
   $phrase_array = explode(' ',$phrase);
   if(count($phrase_array) > $max_words && $max_words > 0)
      $phrase = implode(' ',array_slice($phrase_array, 0, $max_words)).'...';
   return $phrase;
}

function urlTitle($str,$separator = 'dash',$lowercase = TRUE)
    {

        if ($separator == 'dash')
        {

            $search     = '_';
            $replace    = '-';

        }else
        {

            $search     = '-';
            $replace    = '-';

        }

        $trans = array(
                        '&\#\d+?;'              => '',
                        '&\S+?;'                => '',
                        '\s+'                   => $replace,
                        '[^أ-يa-z0-9\-_]'       => '',
                        $replace.'+'            => $replace,
                        $replace.'$'            => $replace,
                        '^'.$replace            => $replace,
                        '\.+$'                  => ''
                        );

        $str = trim(strip_tags($str));
        $str = preg_replace("#\/#ui",'-',$str);

        foreach ($trans AS $key => $val)
        {

            $str = preg_replace("#".$key."#ui", $val, $str);

        }

        if($lowercase === TRUE)
        {

            $str = mb_strtolower($str);

        }
	
        return trim(stripslashes($str));
}
//-----------------------------------------//
//-----------------------------------------//
function get_extension($imagetype)
   {
       if(empty($imagetype)) return false;
       switch($imagetype)
       {
           case 'image/bmp': return '.bmp';
           case 'image/cis-cod': return '.cod';
           case 'image/gif': return '.gif';
           case 'image/ief': return '.ief';
           case 'image/jpeg': return '.jpg';
           case 'image/pipeg': return '.jfif';
           case 'image/tiff': return '.tif';
           case 'image/x-cmu-raster': return '.ras';
           case 'image/x-cmx': return '.cmx';
           case 'image/x-icon': return '.ico';
           case 'image/x-portable-anymap': return '.pnm';
           case 'image/x-portable-bitmap': return '.pbm';
           case 'image/x-portable-graymap': return '.pgm';
           case 'image/x-portable-pixmap': return '.ppm';
           case 'image/x-rgb': return '.rgb';
           case 'image/x-xbitmap': return '.xbm';
           case 'image/x-xpixmap': return '.xpm';
           case 'image/x-xwindowdump': return '.xwd';
           case 'image/png': return '.png';
           case 'image/x-jps': return '.jps';
           case 'image/x-freehand': return '.fh';
           default: return false;
       }
   }
//--
function string_cut($string,$cut_size){
  $StringArray=explode(" ",$string);
for($i=0;$i<$cut_size;$i++)
{
$string_cut.=" "."$StringArray[$i]";
}
return "$string_cut"."..."; 
}
//---
function string_cut_pro($string,$cut_size){
  $StringArray=explode(" ",$string);
for($i=0;$i<$cut_size;$i++)
{
$string_cut.=" "."$StringArray[$i]";
}
return "$string_cut"; 
}
//---
function watermark($SourceFile, $WatermarkFile, $SaveToFile = NULL){ 
	header('Content-type: image/jpeg');
    $watermark = @imagecreatefrompng($WatermarkFile) 
	or exit('Cannot open the watermark file.');
    imageAlphaBlending($watermark, false); 
    imageSaveAlpha($watermark, true); 
    $image_string = @file_get_contents($SourceFile) 
	or exit('Cannot open image file.'); 
    $image = @imagecreatefromstring($image_string) 
	or exit('Not a valid image format.'); 
    $imageWidth=imageSX($image); 
    $imageHeight=imageSY($image); 
    $watermarkWidth=imageSX($watermark); 
    $watermarkHeight=imageSY($watermark); 
    //$coordinate_X =($imageWidth-$watermarkWidth)/2; 
    //$coordinate_Y =($imageHeight-$watermarkHeight)/2; 
	$coordinate_X =0; 
    $coordinate_Y =$imageHeight-$watermarkHeight; 
    imagecopy($image, $watermark, $coordinate_X, $coordinate_Y, 
        0, 0, $watermarkWidth, $watermarkHeight); 
    if(!($SaveToFile)) header('Content-Type: image/jpeg'); 
    imagejpeg ($image, $SaveToFile, 100); 
    imagedestroy($image); 
    imagedestroy($watermark); 
    if(!($SaveToFile)) exit; 
}  
//----
function multimd5($pass){
$ex=md5(md5($pass));
$x='@wWw~oRienThoSpItal.cOm0';
$xx=md5(md5($x));
$a=substr($ex,4,16);
$b=substr($xx,10,16);
$c=$b.$a;
$d= md5(md5($c));
return $d;
}
//----
function removeFromEnd($string, $stringToRemove) {
    $stringToRemoveLen = strlen($stringToRemove);
    $stringLen = strlen($string);
   
    $pos = $stringLen - $stringToRemoveLen;

    $out = substr($string, 0, $pos);

    return $out;
}
//----
function date_formated($date,$lang){
	
	$day=date('l',$date);
	$month=date('F',$date);
	$daynum=date('d',$date);
	$year=date('Y',$date);
	//--
	switch($day){
		case 'Monday':
		$xdayar='الاثنين';
		$xdayen='Monday';
		break;
		case 'Tuesday':
		$xdayar='الثلاثاء';
		$xdayen='Tuesday';
		break;
		case 'Wednesday':
		$xdayar='الأربعاء';
		$xdayen='Wednesday';
		break;
		case 'Thursday':
		$xdayar='الخميس';
		$xdayen='Thursday';
		break;
		case 'Friday':
		$xdayar='الجمعة';
		$xdayen='Friday';
		break;
		case 'Saturday':
		$xdayar='السبت';
		$xdayen='Saturday';
		break;
		case 'Sunday':
		$xdayar='الأحد';
		$xdayen='Sunday';
		break;
		}
		//--
	switch($month){
		case 'January':
		$xmonthar='يناير';
		$xmonthen='January';
		break;
		case 'February':
		$xmonthar='فبراير';
		$xmonthen='February';
		break;
		case 'March':
		$xmonthar='مارس';
		$xmonthen='March';
		break;
		case 'April':
		$xmonthar='ابريل';
		$xmonthen='April';
		break;
		case 'May':
		$xmonthar='مايو';
		$xmonthen='May';
		break;
		case 'June':
		$xmonthar='يونيو';
		$xmonthen='June';
		break;
		case 'July':
		$xmonthar='يوليو';
		$xmonthen='July';
		break;
		case 'August':
		$xmonthar='اغسطس';
		$xmonthen='August';
		break;
		case 'September':
		$xmonthar='سبتمبر';
		$xmonthen='September';
		break;
		case 'October':
		$xmonthar='اكتوبر';
		$xmonthen='October';
		break;
		case 'November':
		$xmonthar='نوفمبر';
		$xmonthen='November';
		break;
		case 'December':
		$xmonthar='ديسمبر';
		$xmonthen='December';
		break;
		}
		//--
		switch($lang){
			case 'ar':
			$total=$daynum.' '.$xmonthar.', '.$year;
			break;
			case 'en':
			$total=$daynum.' '.$xmonthen.', '.$year;
			break;
			}
		return $total;
	}
//----
function uploadImages($type,$images,$prefix){
		  
        switch($type){
                case 1:
                $uploaddir = '../img/uploads1/';
                break;
        }
        $img = array();
        for($i=0;$i<count($images['name']);$i++){


                if(!empty($images['name'][$i])){
					$separator=explode('.',$images['name'][$i]);
					$ext=$separator[1];
					$new=$prefix;
					$images['name'][$i]=$new.'.'.$ext;

                        $uploadfile = $uploaddir.$images['name'][$i];
                            if(move_uploaded_file($images['tmp_name'][$i], strtolower($uploadfile))){
                                   $img[]= strtolower($images['name'][$i]);
                           }else{
                                   return "error while moving files";
                            }

                }
				

        }
        return $img;
}
//---------
function changeImages($type,$images,$oldimages,$prefix){
        switch($type){
                case 1:
                $uploaddir = '../img/uploads1/';
                break;
        }
        $img = array();
        for($i=0;$i<count($images['name']);$i++){


                if(!empty($images['name'][$i])){
					$separator=explode('.',$images['name'][$i]);
					$ext=$separator[1];
					$new=$prefix;
					$images['name'][$i]=$new.'.'.$ext;
                                $uploadfile = $uploaddir.$images['name'][$i];
                                $deletefile = $uploaddir.$oldimages[$i];
								unlink($deletefile);
                                if(move_uploaded_file($images['tmp_name'][$i], strtolower($uploadfile))){
                                        $img[$i] = strtolower($images['name'][$i]);
                                        
                                }else{
                                        return "error while moving files";
                                }

                }
         for ($j=count($img);$j<7;$j++)
         {
            $img[$j] = $oldimages[$j];
         }

        }
        return $img;
}
//---------
function deleteImages($type, $images)
{
   switch($type){
                case 1:
                $deletefromdir = '../img/uploads1/small/';
                break;
                case 2:
                $deletefromdir = '../img/uploads1/larg/';
                break;
                case 3:
                $deletefromdir = '../img/uploads1/medium/';
                break;
                case 4:
                $deletefromdir = '../img/uploads1/';
                break;
                case 5:
                $deletefromdir = '../img/uploads1/home/';
                break;
                case 6:
                $deletefromdir = '../img/uploads1/xsmall/';
                break;
   }
   $delimg = array();
    for($i=0;$i<count($images);$i++){
            if($images[$i])
            {
               $filetodelete = $deletefromdir.$images[$i];
                if(unlink($filetodelete)){

                }else{
                  return "error while deleteing files";
                }

            }

    }
    return 1;
}
//---------------------------------------
function uploadImagesOut($type,$images,$prefix){
		  
        switch($type){
                case 1:
                $uploaddir = './img/uploads1/';
                break;
        }
        $img = array();
        for($i=0;$i<count($images['name']);$i++){


                if(!empty($images['name'][$i])){
					$separator=explode('.',$images['name'][$i]);
					$ext=$separator[1];
					$new=$prefix;
					$images['name'][$i]=$new.'.'.$ext;

                        $uploadfile = $uploaddir.$images['name'][$i];
                            if(move_uploaded_file($images['tmp_name'][$i], strtolower($uploadfile))){
                                   $img[]= strtolower($images['name'][$i]);
                           }else{
                                   return "error while moving files";
                            }

                }
				

        }
        return $img;
}

?>