<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\FriendSiteRequest;
use App\Models\FriendSite;
use Illuminate\Http\Request;

class FriendSiteController extends AdminController
{
    public function __construct(FriendSite $model)
    {
        parent::__construct();
        $this->model = $model;
        view()->share([

        ]);
    }

    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)
                ->editColumn('name', function ($data) {
                    return $data->name ? '<a href="' . route($this->module_name . '.show', $data->id) . '">' . $data->name . '</a>' : '';
                })
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['name','actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }
    public function store(FriendSiteRequest $request)
    {
        $data = $request->all();
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }
    public function update(FriendSiteRequest $request, FriendSite $friend_site)
    {
        $data = $request->all();
        $data['updated_by'] = 1;
        $update = $friend_site->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
