<?php

namespace App\Http\Controllers\Admin;


use App\Http\Requests\MemberReqest;
use App\Models\Member;

class MemberController extends AdminController
{
    public function __construct(Member $model)
    {
        parent::__construct();
        $this->model = $model;
        $this->image_width = 150;
        $this->image_height = 200;
        $this->image_ratio = '3/4';
        view()->share([

            'uploads_folder' => $this->uploads_folder,
            'image_width' => $this->image_width,
            'image_height' => $this->image_height,
            'image_ratio' => $this->image_ratio,

        ]);
    }

    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;

        if (request()->ajax()) {
            return datatables()->of($items)
                ->editColumn('name', function ($data) {
                    return $data->name ? '<a href="' . route($this->module_name . '.show', $data->id) . '">' . $data->name . '</a>' : '';
                })
                ->editColumn('image', function ($data) {
                    return $data->image ? '<img src="' . $data->image_thumb_path . '" class="img-thumbnail" style="width: 50px">' : '<i class="fa fa-image no-img" >';
                })
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['name','image','actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }
    public function store(MemberReqest $request)
    {
        $image = $request['image'] ?? null;

        $data = $request->all();
        $img_name = $this->upload_crop_image(null, $request->image);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }
    public function update(MemberReqest $request, Member $member)
    {
        $data = $request->all();

        $img_name = $this->upload_crop_image($member);
        if ($img_name) {
            $data['image'] = $img_name;
        }
        $data['updated_by'] = 1;
        $update = $member->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
