<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\NavMenuItemRequest;
use App\Models\NavMenu;
use App\Models\NavMenuItem;
use Illuminate\Http\Request;

class NavMenuItemController extends AdminController
{
    public function __construct(NavMenuItem $model)
    {
        parent::__construct();
        $this->model = $model;
         view()->share([

        ]);
    }
    public function index()
    {
        $deleted_items = $this->model->onlyTrashed()
            ->with(['deletedBy' => function ($query) {
                $query->select('id', 'name');
            }])
            ->get();
        $all_items = $this->model->orderByRaw('-item_order DESC')
            ->with('createdBy')
            ->get();

        $items = request()->has('trashed') ? $deleted_items : $all_items;
        if (request()->ajax()) {
            return datatables()->of($items)
                ->editColumn('nav_menu_id',function ($data){
                    return $data->navMenu ? $data->navMenu->name : '--';
                })
                ->addColumn('order_form', $this->components_view . '.order_form')
                ->addColumn('actions', function ($data) {
                    return view($this->components_view . '.actions', compact('data'))
                        ->with('module_actions', $this->module_actions);
                })
                ->rawColumns(['nav_menu_id','order_form', 'actions'])
                ->make(true);
        }
        return view($this->method_view, compact('items'))->with('deleted_items', $deleted_items);
    }
    public function create()
    {
        $this->method_view = $this->admin_view.'.'.$this->module_name.'.form';

            if(\Request::has('nav_menu_id'))
            {
                $menu_id = Request('nav_menu_id');
                $nav_menu = NavMenu::find($menu_id);
                return view($this->method_view , compact('nav_menu'));
            }
            else{
                $nav_menus = NavMenu::all();
                return view($this->method_view , compact('nav_menus'));
            }
    }
    public function store(NavMenuItemRequest $request)
    {
        $data = $request->all();
        $data['created_by'] = auth()->user()->id;
        $this->model::create($data);
        session()->flash('success', $this->created_successfully);
        return redirect($this->index_route);
    }

    public function edit($id)
    {
        $this->method_view = $this->admin_view.'.'.$this->module_name.'.form';
        $item = $this->model->withTrashed()->findOrFail($id);
        $nav_menus = NavMenu::all();

        return view($this->method_view , compact(['nav_menus','item']));

    }
    public function update(NavMenuItemRequest $request, NavMenuItem $nav_menu_item)
    {
        $data = $request->all();
        $data['updated_by'] = 1;
        $update = $nav_menu_item->update($data);
        session()->flash('success', $this->updated_successfully);
        return redirect($this->index_route);
    }
}
